<?php
/**
 * DocMan SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_docman extends SefExt
{
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
        if (!is_null($uri->getVar('dir')))
            $this->nonSefVars['dir'] = $uri->getVar('dir');
        if (!is_null($uri->getVar('order')))
            $this->nonSefVars['order'] = $uri->getVar('order');
        
        // Find the token variable and remove it
        $vars = $uri->getQuery(true);
        $keys = array_keys($vars);
        foreach ($keys as $key) {
            if (strlen($key) == 32 && preg_match('/^[0-9a-f]+$/i', $key)) {
                $this->ignoreVars[$key] = $uri->getVar($key);
            }
        }
    }
    
    /**
     * Get array of nested categories from given category id
     */
    function getCategories($catId, $lastOnly = false)
    {
        $db = & JFactory::getDBO();
        $sefConfig = & SEFConfig::getConfig();
        
        $categories = array();
        // check if we want our URLs translated
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';
        
        while ($catId > 0) {
            $db->setQuery("SELECT `title`$jfTranslate, `parent_id` FROM `#__categories` WHERE `id` = " . $catId);
            $row = $db->loadObject();
            
            $name = ($this->params->get('add_categoryId', '0') != '0' ? $catId . '-' : '') . $row->title;
            array_unshift($categories, $name);
            // get parent category Id (if not loading only last)
            $catId = $lastOnly ? 0 : $row->parent_id;
        }
        return $categories;
    }

    function getDocument($id)
    {
        $db = &JFactory::getDBO();
        $id = (int) $id;
        if ($id > 0) {
            $query = 'SELECT id, dmname, catid FROM #__docman WHERE id = ' . $id;
            $db->setQuery($query);
            $row = $db->loadAssoc();
            if (is_array($row) && count($row) == 3) {
                return $row;
            }
        }
        return null;
    }
    
    function create(&$uri)
    {
        $sefConfig =& SEFConfig::getConfig();
        $this->params = SEFTools::getExtParams('com_docman');
        
        $vars = $uri->getQuery(true);
        extract($vars);

        // JF translate extension.
        $catShowType = $this->params->get('categories', '2');

        $title = array();       
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);               
        
        // we do not work with view, it is added by joomla
        if (isset($view)) {
            /*switch ($view) {
                case 'docman':
                case 'search':
                case 'document':
                case 'download':
                    $task = '';
                    break;
            }*/
            // remove it completely
            $uri->delVar('view');
            unset($view);
            // we will simply ignore it
            //$ignoreSefVars['view'] = $view;
        }
                
        if (isset($task)) {
            switch ($task) {
            case 'cat_view':
            case 'upload':
                // all categories                    
                if ($catShowType == '2') {
                    $catNames = $this->getCategories($gid);                        
                    foreach ($catNames as $cat) $title[] = $cat;
                // one category (or none)
                } else {
                    $catNames = $this->getCategories($gid, true);
                    $title[] = @$catNames[count($catNames) - 1];
                }
                
                // if upload
                if ($task == 'upload') {
                    $title[] = JText::_('Upload');
                    if (isset($step)) {
                        $title[] = JText::_('Step') . '-' . $step;
                    }
                }
                break;
            case 'doc_download':
            case 'doc_details':
            case 'doc_view':
            case 'doc_move':
            case 'doc_edit':
            case 'doc_checkin':
            case 'doc_checkout':
            case 'doc_update':
            case 'doc_reset':
            case 'doc_delete':
            case 'doc_publish':
            case 'doc_unpublish':
            case 'license_result':
                if (($doc = $this->getDocument($gid))) {
                    $catID = $doc['catid'];                        
                    
                    // categories
                    if ($catShowType > 0) {                            
                        // all categories
                        if ($catShowType == '2') {
                            $catNames = $this->getCategories($catID); 
                            foreach ($catNames as $cat) $title[] = $cat;
                        // one category
                        } elseif ($catShowType == '1') {
                            $catNames = $this->getCategories($catID, true);
                            $title[] = @$catNames[count($catNames) - 1];
                        }
                    }

                    // document name
                    $title[] = ($this->params->get('add_documentId', '0') == '1' ? $gid.'-' : '') . $doc['dmname'];

                    // additional task
                    switch ($task) {
                        case 'doc_download':
                            $title[] = JText::_('Download'); break;
                        case 'doc_details':
                            $title[] = JText::_('Details'); break;
                        case 'doc_view':
                            $title[] = JText::_('View'); break;
                        case 'doc_move':
                            $title[] = JText::_('Move'); break;
                        case 'doc_edit':
                            $title[] = JText::_('Edit'); break;
                        case 'doc_checkout':
                            $title[] = JText::_('Checkout'); break;
                        case 'doc_checkin':
                            $title[] = JText::_('Checkin'); break;
                        case 'doc_update':
                            $title[] = JText::_('Update'); break;
                        case 'doc_reset':
                            $title[] = JText::_('Reset'); break;
                        case 'doc_delete':
                            $title[] = JText::_('Delete'); break;
                        case 'doc_publish':
                            $title[] = JText::_('Publish'); break;
                        case 'doc_unpublish':
                            $title[] = JText::_('Unpublish'); break;
                        case 'license_result':
                            $title[] = JText::_('License result'); break;
                    }
                }
                break;
            case 'search_form':
                $title[] = JText::_('Search');
                break;
            default:
                $title[] = $task;
            }
            unset($task);
        }
        
        $newUri = $uri;
        if (count($title) > 0) {
            // Handle nonSef variables
            $this->_createNonSefVars($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, $task, @$limit, @$limitstart, @$lang, $this->nonSefVars, $this->ignoreVars);
        }

        return $newUri;
    }

}
?>
