<?php
/**
 * JForms SEF extension for Joomla!
 *
 * @copyright  2009 Denis Dulici
 * @license	    GNU General Public License
 * www.denisdulici.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_jforms extends SefExt
{
    var $params;

    function getFormTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT `id`, `title` FROM `#__jforms_forms` WHERE `id` = $id");
        $form = $database->loadObject();
        if($form) {
            $name = ( ($this->params->get('formid_inc', '0') != '0') ? $id.'-' : '' ).$form->title;
            return $name;
        } else {
            return null;
        }
    }

    function beforeCreate(&$uri) {
        // Remove the part after ':' from variables
        if( !is_null($uri->getVar('id')) )       SEFTools::fixVariable($uri, 'id');
        return;
    }

    function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_jforms');

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if( isset($view) ) {
            switch($view) {
				case 'form':
                    if( isset($id) ) {
                        $title[] = $this->getFormTitle($id);
                    }
                    unset($view);
                    break;
            }
        }
		
		$nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $newUri;
    }
}
?>