<?php

/**
 * Customer controller.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  controllers
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed JoomLIB helpers
AImporter::helper('booking', 'controller', 'parameter', 'request');

class BookingControllerCustomer extends AController
{
    
    /**
     * Main model
     * 
     * @var BookingModelCustomer
     */
    var $_model;

    function __construct($config = array())
    {
        parent::__construct($config);
        if (! class_exists('BookingModelCustomer')) {
            AImporter::model('customer');
        }
        $this->_model = new BookingModelCustomer();
        $this->_controllerName = CONTROLLER_CUSTOMER;
    }

    /**
     * Display default view - customers list	
     */
    function display()
    {
        switch ($this->getTask()) {
        	case 'block':
            case 'trash':
            case 'restore':
                $this->state($this->getTask());
                break;
            case 'detail':
                JRequest::setVar('view', 'customer');
                break;
            default:
                JRequest::setVar('view', 'customers');
                break;
        }
        parent::display();
    }

    /**
     * Display browse customers page into element window.
     */
    function element()
    {
        $this->display();
    }

    /**
     * Open editing form page.
     */
    function editing()
    {
        parent::editing('customer');
    }

    /**
     * Cancel edit operation. Check in customer and redirect to customers list. 
     */
    function cancel()
    {
        parent::cancel('Customer editing canceled');
    }

    /**
     * Save customer.
     * 
     * @param boolean $apply true state on edit page, false return to browse list
     */
    function save($apply = false)
    {
        JRequest::checkToken() or jexit('Invalid Token');
        
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $config = &AFactory::getConfig();
        
        $post = JRequest::get('post');
        
        if (IS_ADMIN)
            $post['id'] = ARequest::getCid();
        
        elseif (IS_SITE) {
            if ($user->id) {
                $this->_model->setIdByUserId();
                $post['id'] = $this->_model->getId();
            } else
                $post['id'] = 0;
        }
        
        $isNew = $post['id'] == 0;
        $id = $this->_model->store($post);
        
        if ($id !== false) {
            $mainframe->enqueueMessage(JText::_('Successfully saved'), 'message');
            
            if (IS_SITE) {
                
                if ($isNew) {
                    
                    if (! $user->id) {
                    	$items = $mainframe->getUserState(OPTION . '.user_reservation_items'); // reservation which user has created in guest session
                        $mainframe->login(array('password' => $post['password'] , 'username' => $post['username']), array('remember' => 1 , 'return' => ARoute::detail($this->_controllerName)));
                        $mainframe->setUserState(OPTION . '.user_reservation_items', $items); // set reservation for new session
                    }
                    $user = &JFactory::getUser();
                    /* @var $user JUser */
                    
                    if ($config->mailingRegistrationClient && $user->email) {
                    	$email = JModel::getInstance('Email', 'BookingModel')->getItem($config->mailingRegistrationClient);
                        JUtility::sendMail(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname'), $user->email, $email->subject, $this->replaceEmailBody($email->body, $user, $post, $this->_model->_table), $email->mode);
                    }
                    
                    if ($config->mailingRegistrationManager && $config->mailingManager)
                    	$email = JModel::getInstance('Email', 'BookingModel')->getItem($config->mailingRegistrationManager);
                    	JUtility::sendMail(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname'), $config->mailingManager, $email->subject, $this->replaceEmailBody($email->body, $user, $post, $this->_model->_table), $email->mode);
                }
                
                if (($startSubjectId = JRequest::getInt('startSubjectId')))
                    $customParams['startSubjectId'] = $startSubjectId;
                else
                    $customParams = array();
                
                if (JRequest::getString('return') == 'reservation')
                	JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_booking&view=reservation&layout=form'));
                else
                	ARequest::redirectDetail($this->_controllerName, null, $customParams);
            
            } elseif ($apply)
                ARequest::redirectEdit($this->_controllerName, $id);
            
            else
                ARequest::redirectList($this->_controllerName);
        
        } else {
            JRequest::setVar('error', 1);
            
            foreach ($this->_model->_errors as $error) {
                $language = &JFactory::getLanguage();
                /* @var $language JLanguage */
                $language->load('com_users', JPATH_ADMINISTRATOR);
                $mainframe->enqueueMessage(JText::_($error), 'error');
            }
            
            $this->editing();
        }
    }

    /**
     * Prepare registration e-mail body.
     * 
     * @param string $body e-mail body
     * @param JUser $user Joomla! user 
     * @param array $post request data
     * @param TableCustomer $customer
     * 
     * @return string 
     */
    function replaceEmailBody($body, &$user, &$post, &$customer)
    {
        $body = str_replace('{REGISTRATION DATE}', AHtml::date($user->registerDate, ADATE_FORMAT_LONG), $body);
        $body = str_replace('{USERNAME}', $user->username, $body);
        $body = str_replace('{PASSWORD}', $post['password'], $body);
        $body = str_replace('{EMAIL}', $user->email, $body);
        $body = str_replace('{NAME}', BookingHelper::formatName($customer), $body);
        $body = str_replace('{COMPANY}', $customer->company, $body);
        $body = str_replace('{ADDRESS}', BookingHelper::formatAddress($customer), $body);
        $body = str_replace('{TELEPHONE}', $customer->telephone, $body);
        $body = str_replace('{FAX}', $customer->fax, $body);
        foreach ($customer->fields as $field)
        	$body = str_replace('{' . JString::strtoupper($field['title']) . '}', $field['value'], $body);
        
		$body .= "\n\n" . BookingHelper::get();
		
        
        return $body;
    }
}

?>