<?php

/**
 * Scheduke parameter element.
 *
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	elements
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class JElementSchedule extends JElement
{

	/**
	 * (non-PHPdoc)
	 * @see JElement::fetchElement()
	 */
	public function fetchElement($name, $value, $node, $control_name = null)
	{
		$match = array();
		if (preg_match('/^(\d+)t(\d+)d(\d+)h(\d+)m$/', $value, $match)) {
			$type = $match[1];
			$days = $match[2];
			$hours = $match[3];
			$minutes = $match[4];
		} else {
			$type = 1;
			$days = 0;
			$hours = 0;
			$minutes = 10;
		}
		$code = '<table>';
		$code .= '	<tr>';
		$code .= '		<td>';
		$code .= '			<select name="jelementscheduletype" id="jelementscheduletype" onchange="jelementschedule()" style="margin-bottom: 0">';
		$code .= '				<option value="1">' . JText::_('reservation done after') . '</option>';
		$code .= '			</select>';
		$code .= '		</td>';
		$code .= '		<td>';
		$code .= '			<input type="text" id="jelementscheduledays" name="jelementscheduledays" value="' . $days . '" size="1" onkeyup="jelementschedule()" autocomplete="off" style="width: auto" />';
		$code .= '		</td>';
		$code .= '		<td>';
		$code .= '			<label for="jelementscheduledays" style="min-width: 0">' . JText::_('Days') . '</label>';
		$code .= '		</td>';		
		$code .= '		<td>';
		$code .= '			<input type="text" id="jelementschedulehours" name="jelementschedulehours" value="' . $hours . '" size="1" maxlength="2" onkeyup="jelementschedule()" autocomplete="off" title="' . htmlspecialchars(JText::_('0-23 hours')) . '" style="width: auto" />';
		$code .= '		</td>';		
		$code .= '		<td>';
		$code .= '			<label for="jelementschedulehours" style="min-width: 0">' . JText::_('Hours') . '</label>';
		$code .= '		</td>';		
		$code .= '		<td>';		
		$code .= '			<input type="text" id="jelementscheduleminutes" name="jelementscheduleminutes" value="' . $minutes . '" size="1" maxlength="2" onkeyup="jelementschedule()" autocomplete="off" title="' . htmlspecialchars(JText::_('0-59 minutes')) . '" style="width: auto" />';
		$code .= '		</td>';		
		$code .= '		<td>';
		$code .= '			<label for="jelementscheduleminutes" style="min-width: 0">' . JText::_('Minutes') . '</label>';
		$code .= '		</td>';
		$code .= '	</tr>';
		$code .= '</table>';
		
		$code .= '<input type="hidden" id="jelementschedulevalue" name="' . $control_name . '[' . $name . ']" value="' . $value . '" />';
		$code .= '<p style="clear: both; margin: 0px; padding: 0px;">' . JText::_('Cron URL') . ' ';
		$code .= '	<a href="' . JURI::root() . 'index.php?option=com_booking&amp;controller=reservation&amp;task=followup" target="_blank">';
		$code .= JURI::root() . 'index.php?option=com_booking&amp;controller=reservation&amp;task=followup';
		$code .= '	</a>';
		$code .= '</p>';
		$code .= '
			<script type="text/javascript">
				//<![CDATA[
				function jelementschedule() {
				
					$("jelementscheduledays").value = $("jelementscheduledays").value.toInt(); 
					$("jelementschedulehours").value = $("jelementschedulehours").value.toInt(); 
					$("jelementscheduleminutes").value = $("jelementscheduleminutes").value.toInt();
					
					if ($("jelementscheduledays").value == "NaN")
						$("jelementscheduledays").value = 0;
					if ($("jelementschedulehours").value == "NaN")
						$("jelementschedulehours").value = 0;
					if ($("jelementscheduleminutes").value == "NaN")
						$("jelementscheduleminutes").value = 0;
				
					if ($("jelementschedulehours").value > 23)
						$("jelementschedulehours").value = 23;
				
					if ($("jelementscheduleminutes").value > 59)
						$("jelementscheduleminutes").value = 59;
					
					$("jelementschedulevalue").value = $("jelementscheduletype").value + "t" + $("jelementscheduledays").value + "d" + $("jelementschedulehours").value + "h" + $("jelementscheduleminutes").value + "m";
				}
				//]]>
			</script>';
		return $code;
	}
}

?>