<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelClosingdays extends JModel
{
	
	public function populateState()
	{
		$app = JFactory::getApplication();
		$this->setState('filter.search', $app->getUserStateFromRequest('com_booking.closingdays.filter.search', 'filter_search'));
		$this->setState('list.limitstart', $app->getUserStateFromRequest('com_booking.locations.filter.limitstart', 'limitstart', 0, 'int'));
		$this->setState('list.limit', $app->getUserStateFromRequest('com_booking.closingdays.filter.limit', 'limit', 5, 'int'));
		$this->setState('list.ordering', $app->getUserStateFromRequest('com_booking.closingdays.filter.order', 'filter_order', 'id'));
		$this->setState('list.direction', $app->getUserStateFromRequest('com_booking.closingdays.filter.orderdir', 'filter_order_Dir', 'asc'));
	}

	public function getItems()
	{
		$this->populateState();
		
		$query = 'SELECT c.*, u.name AS editor 
				FROM #__booking_closingday AS c
				LEFT JOIN #__users AS u ON u.id = c.checked_out ';

		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->quote('%'.JString::strtolower($search).'%');
			$query .= "WHERE (LOWER(c.title) LIKE $search OR LOWER(c.text) LIKE $search)";
		}
		
		$query .= 'ORDER BY ' . $this->getState('list.ordering') . ' ' . $this->getState('list.direction');
		
		$this->_db->setQuery($query);
		return $this->_db->loadObjectList();
	}
	
	public function getTotal()
	{
		$query = 'SELECT COUNT(*)
				FROM #__booking_closingday ';
	
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->quote('%'.JString::strtolower($search).'%');
			$query .= "WHERE (LOWER(c.title) LIKE $search OR LOWER(c.text) LIKE $search)";
		}
		
		$this->_db->setQuery($query);
		return $this->_db->loadResult();
	}
	
	public function getPagination()
	{
		jimport('joomla.html.pagination');
		$pagination = new JPagination($this->getTotal(), $this->getState('list.limitstart'), $this->getState('list.limit'));
		return $pagination;
	}
	
	/**
	 * Get all closing days which affected subject.
	 * @param int $subjectId
	 * @return array
	 */
	public function getSubjectClosingDays($subjectId)
	{
		
		$query = 'SELECT c.title, c.text, c.date_up, c.date_down, c.time_up, c.time_down ';
		$query .= 'FROM #__booking_closingday AS c ';
		$query .= 'JOIN #__booking_closingday_subject AS s ON s.closingday_id = c.id ';
		$query .= 'WHERE subject_id = ' . (int) $subjectId;
		
		$this->_db->setQuery($query);
		$subjectClosingDays = $this->_db->loadObjectList();
		
		foreach ($subjectClosingDays as $i => $subjectClosingDay) {
			$subjectClosingDay->up = $subjectClosingDay->date_up . ' ' . $subjectClosingDay->time_up;
			$subjectClosingDay->down = $subjectClosingDay->date_down . ' ' . ($subjectClosingDay->time_down == '00:00:00' ? '23:59:59' : $subjectClosingDay->time_down);
		}
			
		return $subjectClosingDays;
	}
}