<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelLocations extends JModel
{

	public function populateState()
	{
		$app = JFactory::getApplication();
		$this->setState('filter.search', $app->getUserStateFromRequest('com_booking.locations.filter.search', 'filter_search', '', 'string'));
		$this->setState('filter.pick_up', $app->getUserStateFromRequest('com_booking.locations.filter.pick_up', 'filter_pick_up', '', 'string'));
		$this->setState('filter.drop_off', $app->getUserStateFromRequest('com_booking.locations.filter.drop_off', 'filter_drop_off', '', 'string'));
		$this->setState('list.limitstart', $app->getUserStateFromRequest('com_booking.locations.filter.limitstart', 'limitstart', 0, 'int'));
		$this->setState('list.limit', $app->getUserStateFromRequest('com_booking.locations.filter.limit', 'limit', 5, 'int'));
		$this->setState('list.ordering', $app->getUserStateFromRequest('com_booking.locations.filter.order', 'filter_order', 'id'));
		$this->setState('list.direction', $app->getUserStateFromRequest('com_booking.locations.filter.orderdir', 'filter_order_Dir', 'asc'));
	}

	public function getItems()
	{
		$this->populateState();
		
		$query = 'SELECT l.id, l.title, l.pick_up, l.drop_off, l.checked_out, l.checked_out_time, u.name AS editor 
				FROM #__booking_location AS l
				LEFT JOIN #__users AS u ON u.id = l.checked_out ' . $this->getWhere();
		
		$query .= ' ORDER BY ' . $this->getState('list.ordering', 'l.title').' '.$this->getState('list.direction', 'asc');
		
		$this->_db->setQuery($query);
		return $this->_db->loadObjectList();
	}
	
	public function getPickUp()
	{
		$query = 'SELECT id, title FROM #__booking_location WHERE pick_up = 1 ORDER BY title';
		$this->_db->setQuery($query);
		$items = $this->_db->loadObjectList();
		$pickUp = array();
		foreach ($items as $item)
			$pickUp[] = $item->title;
		return $pickUp;
	}
	
	public function getDropOff()
	{
		$query = 'SELECT id, title FROM #__booking_location WHERE drop_off = 1 ORDER BY title';
		$this->_db->setQuery($query);
		$items = $this->_db->loadObjectList();
		$dropOff = array();
		foreach ($items as $item)
			$dropOff[] = $item->title;
		return $dropOff;
	}
	
	public function getTotal()
	{
		$query = 'SELECT COUNT(*) 
				FROM #__booking_location ' . $this->getWhere();
		
		$this->_db->setQuery($query);
		return $this->_db->loadResult();
	}
	
	public function getPagination()
	{
		jimport('joomla.html.pagination');
		$pagination = new JPagination($this->getTotal(), $this->getState('list.limitstart'), $this->getState('list.limit'));
		return $pagination;
	}
	
	public function getWhere()
	{
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->quote('%'.JString::strtolower($search).'%');
			$where[] = 'LOWER(l.title) LIKE ' . $search;
		}
		
		$pick_up = $this->getState('filter.pick_up');
		if ($pick_up !== '')
			$where[] = 'l.pick_up = ' . (int) $pick_up;
		
		$drop_off = $this->getState('filter.drop_off');
		if ($drop_off !== '')
			$where[] = 'l.drop_off = ' . (int) $drop_off;
		
		if (!empty($where))
			return ' WHERE ' . implode(' AND ', $where);
		
		return '';
	}
}