<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

/* @var $this BookingViewClosingday */

defined('_JEXEC') or die;

?>
<script type="text/javascript">
<!--
	function submitbutton(task)
	{
		if (task == 'cancel')
			return submitform(task);
		var f = $('adminForm');
		var items = document.getElements('input[name^=item]');
		var checked = false;
		for (var i = 0; i < items.length; i++) {
			if (items[i].checked) {
				checked = true;
				break;
			}
		}
		if (trim(f.title.value) == '' || f.date_up.value == '' || f.date_down.value == '' || f.time_up.value == '' || f.time_down.value == '' || !checked) 
			return alert('<?php echo JText::_('Add required fields', true); ?>');
		if (f.date_up.value > f.date_down.value)
			return alert('<?php echo JText::_('Date Range Invalid', true); ?>');
		if (f.time_up.value != '00:00' && f.time_down.value != '00:00' && (f.time_up.value >= f.time_down.value))
			return alert('<?php echo JText::_('Time Range Invalid', true); ?>');
		return submitform(task);
	}
//-->
</script>
<form action="<?php echo JRoute::_('index.php?option=com_booking&controller=closingday&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm">
	<div class="col">
		<fieldset class="adminform" class="width-60">
			<legend>
				<?php echo JText::_('Details'); ?>
			</legend>
			<table>
				<tr>
					<td class="key">
						<label for="title"><?php echo JText::_('Title'); ?> *</label>
					</td> 
					<td>
						<input type="text" name="title" id="title" value="<?php echo $this->escape($this->item->title); ?>" size="80" />
					</td>
				</tr>
				<tr>
					<td class="key">
						<label for="date_up"><?php echo JText::_('Date Up'); ?> *</label>
					</td> 
					<td>
						<?php echo AHtml::getCalendar($this->item->date_up, 'date_up', 'date_up', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?>
					</td>
				</tr>
				<tr>
					<td class="key">
						<label for="date_down"><?php echo JText::_('Date Down'); ?> *</label>
					</td> 
					<td>
						<?php echo AHtml::getCalendar($this->item->date_down, 'date_down', 'date_down', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?>
					</td>
				</tr>				
				<tr>
					<td class="key">
						<label for="time_up"><?php echo JText::_('Time Up'); ?> *</label>
					</td> 
					<td>
						<?php echo 	AHtml::getTimePicker($this->item->time_up, 'time_up', true, '', true); ?>
					</td>
				</tr>
				<tr>
					<td class="key">
						<label for="time_down"><?php echo JText::_('Time Down'); ?> *</label>
					</td>
					<td>
						<?php echo 	AHtml::getTimePicker($this->item->time_down, 'time_down', true, '', true); ?>
					</td>
				</tr>				
			</table>
			<fieldset>
				<legend><?php echo JText::_('Text'); ?></legend>
				<?php $editor = JFactory::getEditor();
					echo $editor->display('text', $this->item->text, 800, 600, 50, 10); ?>
			</fieldset>
		</fieldset>
	</div>
	<div class="col">
		<fieldset class="adminform">
			<legend>
				<?php echo JText::_('Affected Items'); ?> *
			</legend>
			<table>
				<tr>
					<th><input type="checkbox" onclick="checkAll(<?php echo count($this->subjects); ?>)" value="" name="toggle"></th>
					<th><?php echo JText::_('Check All'); ?></th>
				</tr>
				<?php foreach ($this->subjects as $i => $subject) { ?>
					<tr>
						<td>
							<input type="checkbox" name="item[]" id="cb<?php echo $i; ?>" value="<?php echo $subject->id; ?>" <?php if ($subject->affected) { ?>checked="checked"<?php } ?> />
						</td>
						<td>
							<label for="item<?php echo $subject->id; ?>"><?php echo $subject->treename; ?></label>
						</td>
					</tr>
				<?php } ?>
			</table>
		</fieldset>
	</div>
	<div>
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="task" value="" /> 
		<input type="hidden" name="return" value="<?php echo JRequest::getCmd('return');?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>