<?php

/**
 * Reservation edit form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

/* @var $this BookingViewReservation */

defined('_JEXEC') or die('Restricted access');

AHtml::title(JText::sprintf('Reservation Num', $this->reservation->id), 'categories');
JToolBarHelper::save();
JToolBarHelper::apply();

if ($this->reservation->id) {
	JToolBarHelper::custom('detail', 'preview', 'preview', 'Detail', false);
}

JToolBarHelper::cancel();

JHTML::_('behavior.modal');

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<div class="col width-50">
		<fieldset class="adminform">
    		<legend><?php echo JText::_('Customer'); ?></legend>
    		<table class="admintable">
    			<tr>
    				<td class="key"><label><?php echo JText::_('Note'); ?>:</label></td>
    				<td><?php echo JText::_('Create new reservation info'); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('User'); ?>:</label></td>
    				<td><?php echo JElementCustomer::fetchElement($this->reservation->customer); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="title_before"><?php echo JText::_('Title before'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="title_before" id="title_before" size="30" maxlength="255" value="<?php echo $this->reservation->title_before; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="firstname"><?php echo JText::_('First name'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="firstname" id="firstname" size="30" maxlength="255" value="<?php echo $this->reservation->firstname; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="middlename"><?php echo JText::_('Middle name'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="middlename" id="middlename" size="30" maxlength="255" value="<?php echo $this->reservation->middlename; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="surname"><?php echo JText::_('Surname'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="surname" id="surname" size="30" maxlength="255" value="<?php echo $this->reservation->surname; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="title_after"><?php echo JText::_('Title after'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="title_after" id="title_after" size="30" maxlength="255" value="<?php echo $this->reservation->title_after; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="company"><?php echo JText::_('Company'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="company" id="company" size="30" maxlength="255" value="<?php echo $this->reservation->company; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="company_id"><?php echo JText::_('Company ID'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="company_id" id="company_id" size="30" maxlength="255" value="<?php echo $this->reservation->company_id; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="vat_id"><?php echo JText::_('Vat ID'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="vat_id" id="vat_id" size="30" maxlength="255" value="<?php echo $this->reservation->vat_id; ?>" /></td>
    			</tr>    			    			
    			<?php
    				if (is_array($this->reservation->fields)) {  
    					foreach ($this->reservation->fields as $name => $field) { 
    			?>		 
		    		 		<tr>
		    					<td class="key"><label for="<?php echo $name; ?>"><?php echo $field['title']; ?>: </label></td>
    							<td><input class="text_area" type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" size="30" maxlength="255" value="<?php echo $this->escape($field['value']); ?>" /></td>
		    				</tr>
		    	<?php 
    					} 
    				}
    				if (!$this->reservation->id) {
		    	?>
		    		<tr>
		    			<td class="key"><label for="notify_customer"><?php echo JText::_('Notify Customer by E-mail'); ?>: </label></td>
		    			<td><input type="checkbox" name="notify_customer" id="notify_customer" value="1" /></td>
		    		</tr>
		    	<?php } ?>
    		</table>
    	</fieldset>

    	<div id="reservedItems">
    	
    	<?php if ($this->ajaxForItems) { ob_clean(); ob_start(); } ?>
    	
    	<?php 
    	$options = array();
    	$options[] = JHTML::_('select.option', '', JText::_('Select list'));
		$options[] = JHTML::_('select.option', RESERVATION_TYPE_HOURLY, JText::_('Hourly'));
		$options[] = JHTML::_('select.option', RESERVATION_TYPE_DAILY, JText::_('Daily'));
		$options[] = JHTML::_('select.option', RESERVATION_TYPE_PERIOD, JText::_('Period'));
						
    	if (count($this->reservedItems))
    		$k = 0;
    		foreach ($this->reservedItems as $reservedItem){
				$id = empty($reservedItem->id) ? $k++ : $reservedItem->id;
    			?>
    	<fieldset class="adminform" id="reservationItem<?php echo $id; ?>">		
    			
    	<?php if (!empty($reservedItem->boxIds)) { // adding new reservation ?>		
    		<?php foreach ($reservedItem->boxIds as $bid) { ?>
				<input type="hidden" name="boxIds[<?php echo $id?>][]" value="<?php echo $bid; ?>" />
			<?php } ?>
		<?php } else { // edit existing ?>
			<input type="hidden" name="boxIds[<?php echo $id?>][]" value="" />
		<?php } ?>
		<input type="hidden" name="ctype[<?php echo $id?>]" value="<?php echo $reservedItem->ctype; ?>" />
    	
    	
    		<legend><?php echo JText::sprintf('Reservation Item Num', $id); ?></legend>
    		
    		<input type="hidden" name="id[<?php echo $id?>]" value="<?php echo $id?>">
    		
    		<table class="admintable">
   				<tr>	
   					<td></td>
   					<td class="aIconLegend aIconUnpublish">
   						<a href="javascript:removeReservationItem(<?php echo $id; ?>, <?php echo $this->reservation->id; ?>)" title=""><?php echo JText::_('Remove Item'); ?></a>
   					</td>
   				</tr>
    			<tr>	
    				<td class="key"><label for="subject[<?php echo $id?>]"><?php echo JText::_('Subject'); ?>:</label></td>
    				<td><?php echo JElementSubject::fetchElement('subject['.$id.']', $reservedItem->subject, SUBJECT_BOOKABLE); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label for="rtype[<?php echo $id?>]"><?php echo JText::_('Reservation type'); ?>:</label></td>
    				<td><?php echo JHTML::_('select.genericlist', $options, 'rtype['.$id.']', '', 'value', 'text', $reservedItem->rtype, 'rtype['.$id.']'); ?></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="subject_title[<?php echo $id?>]"><?php echo JText::_('Subject title'); ?>:</label></td>
    				<td><input class="text_area" type="text" name="subject_title[<?php echo $id?>]" id="subject_title[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->subject_title; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="capacity[<?php echo $id?>]"><?php echo JText::_('Capacity'); ?>:</label></td>
    				<td>
    					<select name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]" <?php if (!$this->reservation->id) { ?>onchange="refreshReservation()"<?php } ?>>
    						<?php for ($i = 1; $i <= $this->subjects[$reservedItem->subject]->total_capacity; $i++) { ?>
    							<option value="<?php echo $i; ?>"<?php if ($i == $reservedItem->capacity) { ?> selected="selected"<?php } ?>>
    								<?php echo $i; ?>
    							</option>
    						<?php } ?>
    					</select>
    				</td>
    			</tr>
    			<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
    				<tr>	
    					<td class="key"><label for="period_time_up[<?php echo $id?>]"><?php echo JText::_('Period Time Up'); ?>: </label></td>
    					<td><?php echo AHtml::getTimePicker($reservedItem->period_time_up, 'period_time_up['.$id.']'); ?></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_time_down[<?php echo $id?>]"><?php echo JText::_('Period Time Down'); ?>: </label></td>
    					<td><?php echo AHtml::getTimePicker($reservedItem->period_time_down, 'period_time_down['.$id.']'); ?></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_time_down[<?php echo $id?>]"><?php echo JText::_('Period Type'); ?>: </label></td>
    					<td>
    						<?php 
    							$options = array(JHtml::_('select.option', '', JText::_('Select Period Type')));
    							$options[] = JHtml::_('select.option', PERIOD_TYPE_DAILY, JText::_('Daily'));
    							$options[] = JHtml::_('select.option', PERIOD_TYPE_WEEKLY, JText::_('Weekly'));
    							$options[] = JHtml::_('select.option', PERIOD_TYPE_MONTHLY, JText::_('Monthly'));
    							$options[] = JHtml::_('select.option', PERIOD_TYPE_YEARLY, JText::_('Yearly'));
    							echo JHtml::_('select.genericlist', $options, 'period_type['.$id.']', '', 'value', 'text', $reservedItem->period_type);
    					 	?>
    					 </td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_recurrence[<?php echo $id?>]"><?php echo JText::_('Period Recurrence'); ?>: </label></td>
    					<td><input type="text" name="period_recurrence[<?php echo $id?>]" id="period_recurrence[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->period_recurrence; ?>" /></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_monday[<?php echo $id?>]"><?php echo JText::_('Period Monday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_monday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_monday[<?php echo $id?>]" id="period_monday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_monday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_tuesday[<?php echo $id?>]"><?php echo JText::_('Period Tuesday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_tuesday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_tuesday[<?php echo $id?>]" id="period_tuesday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_tuesday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_wednesday[<?php echo $id?>]"><?php echo JText::_('Period Wednesday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_wednesday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_wednesday[<?php echo $id?>]" id="period_wednesday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_wednesday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_thursday[<?php echo $id?>]"><?php echo JText::_('Period Thursday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_thursday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_thursday[<?php echo $id?>]" id="period_thursday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_thursday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_friday[<?php echo $id?>]"><?php echo JText::_('Period Friday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_friday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_friday[<?php echo $id?>]" id="period_friday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_friday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_saturday[<?php echo $id?>]"><?php echo JText::_('Period Saturday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_saturday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_saturday[<?php echo $id?>]" id="period_saturday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_saturday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_sunday[<?php echo $id?>]"><?php echo JText::_('Period Sunday'); ?>: </label></td>
    					<td>
    						<input type="hidden" name="period_sunday[<?php echo $id?>]" value="0" />
    						<input type="checkbox" name="period_sunday[<?php echo $id?>]" id="period_sunday[<?php echo $id?>]" value="1" <?php if ($reservedItem->period_sunday) { ?>checked="checked"<?php } ?> />
    					</td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_month[<?php echo $id?>]"><?php echo JText::_('Period Month'); ?>: </label></td>
    					<td>
    						<?php 
    							$options = array(JHtml::_('select.option', '', JText::_('Select Period Month')));
    							$options[] = JHtml::_('select.option', 1, JText::_('JANUARY'));
    							$options[] = JHtml::_('select.option', 2, JText::_('FEBRUARY'));
    							$options[] = JHtml::_('select.option', 3, JText::_('MARCH'));
    							$options[] = JHtml::_('select.option', 4, JText::_('APRIL'));
    							$options[] = JHtml::_('select.option', 5, JText::_('MAY'));
    							$options[] = JHtml::_('select.option', 6, JText::_('JUNE'));
    							$options[] = JHtml::_('select.option', 7, JText::_('JULY'));
    							$options[] = JHtml::_('select.option', 8, JText::_('AUGUST'));
    							$options[] = JHtml::_('select.option', 9, JText::_('SEPTEMBER'));
    							$options[] = JHtml::_('select.option', 10, JText::_('OCTOBER'));
    							$options[] = JHtml::_('select.option', 11, JText::_('NOVEMBER'));
    							$options[] = JHtml::_('select.option', 12, JText::_('DECEMBER'));
    							echo JHtml::_('select.genericlist', $options, 'period_month['.$id.']', '', 'value', 'text', $reservedItem->period_month);
    					 	?>
    					 </td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_week<?php echo $id?>"><?php echo JText::_('Period Week'); ?>: </label></td>
    					<td>
    						<?php 
    							$options = array(JHtml::_('select.option', '', JText::_('Select Period Week')));
    							$options[] = JHtml::_('select.option', 1, JText::_('1st Week'));
    							$options[] = JHtml::_('select.option', 2, JText::_('2nd Week'));
    							$options[] = JHtml::_('select.option', 3, JText::_('3rd Week'));
    							$options[] = JHtml::_('select.option', 4, JText::_('4th Week'));
    							echo JHtml::_('select.genericlist', $options, 'period_week['.$id.']', '', 'value', 'text', $reservedItem->period_week);
    					 	?>
    					 </td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_day[<?php echo $id?>]"><?php echo JText::_('Period Day'); ?>: </label></td>
    					<td>
    						<?php 
    							$options = array(JHtml::_('select.option', '', JText::_('Select Period Day')));
    							$options[] = JHtml::_('select.option', 1, JText::_('Monday'));
    							$options[] = JHtml::_('select.option', 2, JText::_('Tuesday'));
    							$options[] = JHtml::_('select.option', 3, JText::_('Wednesday'));
    							$options[] = JHtml::_('select.option', 4, JText::_('Thursday'));
    							$options[] = JHtml::_('select.option', 5, JText::_('Friday'));
    							$options[] = JHtml::_('select.option', 6, JText::_('Saturday'));
    							$options[] = JHtml::_('select.option', 7, JText::_('Sunday'));
    							echo JHtml::_('select.genericlist', $options, 'period_day['.$id.']', '', 'value', 'text', $reservedItem->period_day);
    					 	?>
    					 </td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_end[<?php echo $id?>]"><?php echo JText::_('Period End Type'); ?>: </label></td>
    					<td>
    						<?php 
    							$options = array(JHtml::_('select.option', '', JText::_('Select Period End Type')));
    							$options[] = JHtml::_('select.option', PERIOD_END_TYPE_NO, JText::_('No End Date'));
    							$options[] = JHtml::_('select.option', PERIOD_END_TYPE_AFTER, JText::_('End After Occurrences'));
    							$options[] = JHtml::_('select.option', PERIOD_END_TYPE_DATE, JText::_('End By Date'));
    							echo JHtml::_('select.genericlist', $options, 'period_end['.$id.']', '', 'value', 'text', $reservedItem->period_end);
    					 	?>
    					 </td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_occurrences[<?php echo $id?>]"><?php echo JText::_('Period Occurrences'); ?>: </label></td>
    					<td><input type="text" name="period_occurrences[<?php echo $id?>]" id="period_occurrences[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->period_occurrences; ?>" /></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_date_up[<?php echo $id?>]"><?php echo JText::_('Period Date Up'); ?>: </label></td>
    					<td><?php echo AHtml::getCalendar($reservedItem->period_date_up, 'period_date_up['.$id.']', 'period_date_up['.$id.']', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="period_date_down[<?php echo $id?>]"><?php echo JText::_('Period Date Down'); ?>: </label></td>
    					<td><?php echo AHtml::getCalendar($reservedItem->period_date_down, 'period_date_up['.$id.']', 'period_date_up['.$id.']', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?></td>
    				</tr>
    			<?php } else { ?>
    				<tr>	
    					<td class="key"><label for="from[<?php echo $id?>]"><?php echo JText::_('From'); ?>:</label></td>
    					<td><?php echo AHtml::getCalendar($reservedItem->from, 'from['.$id.']', 'from['.$id.']', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); ?></td>
    				</tr>
    				<tr>	
    					<td class="key"><label for="to[<?php echo $id?>]"><?php echo JText::_('To'); ?>:</label></td>
    					<td><?php echo AHtml::getCalendar($reservedItem->to, 'to['.$id.']', 'to['.$id.']', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); ?></td>
    				</tr>
    			<?php } ?>
    			<tr>	
    				<td class="key"><label for="message[<?php echo $id?>]"><?php echo JText::_('Message') ?></label></td>
    				<td><input class="text_area" type="text" name="message[<?php echo $id?>]" id="message[<?php echo $id?>]" size="50" maxlength="255" value="<?php echo $reservedItem->message; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="price[<?php echo $id?>]"><?php echo ITEM_PRICE_TIP ?></label></td>
    				<td><input class="text_area" type="text" name="price[<?php echo $id?>]" id="price[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->price; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="fullPrice[<?php echo $id?>]"><?php echo FULL_PRICE_TIP ?> </label></td>
    				<td><input class="text_area" type="text" name="fullPrice[<?php echo $id?>]" id="fullPrice[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->fullPrice; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="fullPriceSupplements[<?php echo $id?>]"><?php echo FULL_PRICE_SUPPLEMENTS_TIP ?> </label></td>
    				<td><input class="text_area" type="text" name="fullPriceSupplements[<?php echo $id?>]" id="fullPriceSupplements[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->fullPriceSupplements; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="deposit[<?php echo $id?>]"><?php echo ITEM_DEPOSIT_TIP ?> </label></td>
    				<td><input class="text_area" type="text" name="deposit[<?php echo $id?>]" id="deposit[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->deposit; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="fullDeposit[<?php echo $id?>]"><?php echo FULL_DEPOSIT_TIP ?> </label></td>
    				<td><input class="text_area" type="text" name="fullDeposit[<?php echo $id?>]" id="fullDeposit[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->fullDeposit; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<!--
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Deposit must be paid before'); ?>:</label></td>
    				<td colspan="5"><?php echo BookingHelper::formatExpiration($reservedItem->cancel_time,$reservedItem->from); ?></td>
    			</tr>
    			-->
    			<tr>	
    				<td class="key"><label for="tax[<?php echo $id?>]"><?php echo BookingHelper::showTax($reservedItem->tax); ?>: </label></td>
    				<td><input class="text_area" type="text" name="tax[<?php echo $id?>]" id="tax[<?php echo $id?>]" size="30" maxlength="255" value="<?php echo $reservedItem->tax; ?>" onkeyup="ACommon.toFloat(this)" /></td>
    			</tr>
    			<?php if (!$this->reservation->id) { ?>   
    				<tr>	
    					<td></td>
    					<td><button onclick="return refreshReservation()"><?php echo JText::_('Refresh'); ?></button></td>
    				</tr> 			
    			<?php } ?>
    		</table>
    	</fieldset>
    	
    	<fieldset class="adminform" id="reservationItemSupplements<?php echo $id; ?>">
    		<legend><?php echo JText::sprintf('Supplements Num', $id); ?></legend>
    		<table class="admintable">
    		
    		<?php
    			foreach ($reservedItem->supplementsRaw as $supplement) {
					$value = $capacity = null;
					foreach ($reservedItem->supplements as $item) {
						$toCompare = $this->reservation->id ? $item->supplement : $item->id;
						if ($toCompare == $supplement->id) {
							$value = $item->value;
							$capacity = $item->capacity;
							break;
						}
					}
			?>
					<tr>
						<td class="key">
							<label for="supplement<?php echo $supplement->id; ?>"><?php echo $supplement->title; ?>: </label>
						</td>
						<td>
							<?php echo BookingHelper::displaySupplementInput($supplement, $value, $capacity, $id, ($this->reservation->id ? '' : 'onchange="refreshReservation()"')); ?>
						</td>
					</tr>	    			
    		<?php } ?>
			</table>
		</fieldset>
		
		<?php } ?>
		
		<?php if ($this->ajaxForItems) $ajaxOutput['items'] = ob_get_clean(); ?>
		
    </div>
    
    </div>
    <div class="col width-50">
    	<fieldset class="adminform">
    		<legend><?php echo JText::_('Contact'); ?></legend>
    		<table class="admintable">
    			<tr>	
    				<td class="key"><label for="street"><?php echo JText::_('Street'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="street" id="street" size="30" maxlength="255" value="<?php echo $this->reservation->street; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="city"><?php echo JText::_('City'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="city" id="city" size="30" maxlength="255" value="<?php echo $this->reservation->city; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="zip"><?php echo JText::_('Zip'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="zip" id="zip" size="30" maxlength="255" value="<?php echo $this->reservation->zip; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="country"><?php echo JText::_('Country'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="country" id="country" size="30" maxlength="255" value="<?php echo $this->reservation->country; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="email"><?php echo JText::_('Email'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="email" id="email" size="30" maxlength="255" value="<?php echo $this->reservation->email; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="telephone"><?php echo JText::_('Telephone'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="telephone" id="telephone" size="30" maxlength="255" value="<?php echo $this->reservation->telephone; ?>" /></td>
    			</tr>
    			<tr>	
    				<td class="key"><label for="fax"><?php echo JText::_('Fax'); ?>: </label></td>
    				<td><input class="text_area" type="text" name="fax" id="fax" size="30" maxlength="255" value="<?php echo $this->reservation->fax; ?>" /></td>
    			</tr>
    			<tr>	
		    		<td class="key"><label for="note"><?php echo JText::_('Note'); ?>: </label></td>
		    		<td>
		    			<textarea name="note" id="note" cols="50" rows="10"><?php echo $this->reservation->note; ?></textarea>
		    		</td>
		    	</tr>
    		</table>
    	</fieldset>

    	<div id="reservationTotal">
    	
    	<?php if ($this->ajaxForItems) { ob_clean(); ob_start(); } ?>
    	
    	<fieldset class="adminform">
    		<legend><?php echo JText::_('Reservation Status and Payment'); ?></legend>
    		
    		<table class="admintable">
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Payment Status'); ?>: </label></td>
    				<td>
						<select name="paid" id="paid">
							<option value="<?php echo RESERVATION_RECEIVE; ?>" <?php if ($this->reservation->paid == RESERVATION_RECEIVE) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Paid in full'); ?></option>
								<option value="<?php echo RESERVATION_RECEIVE_DEPOSIT; ?>" <?php if ($this->reservation->paid == RESERVATION_RECEIVE_DEPOSIT) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Deposit Paid'); ?></option>
								<option value="<?php echo RESERVATION_PENDING; ?>" <?php if ($this->reservation->paid == RESERVATION_PENDING) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Unpaid'); ?></option>
						</select>
					</td>
    			</tr>
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Reservation Status'); ?>: </label></td>
    				<td>
    				<?php if ($this->reservation->state === null) $this->reservation->state = RESERVATION_ACTIVE; ?>
						<select name="state" id="state">
							<option value="<?php echo RESERVATION_PRERESERVED; ?>" <?php if ($this->reservation->state == RESERVATION_PRERESERVED) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Pre-Reserved'); ?></option>
								<option value="<?php echo RESERVATION_ACTIVE; ?>" <?php if ($this->reservation->state == RESERVATION_ACTIVE) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Reserved'); ?></option>
								<option value="<?php echo RESERVATION_STORNED; ?>" <?php if ($this->reservation->state == RESERVATION_STORNED) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Cancelled'); ?></option>
								<option value="<?php echo RESERVATION_TRASHED; ?>" <?php if ($this->reservation->state == RESERVATION_TRASHED) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Trashed'); ?></option>
								<option value="<?php echo RESERVATION_CONFLICTED; ?>" <?php if ($this->reservation->state == RESERVATION_CONFLICTED) { ?>selected="selected"<?php } ?>>
								<?php echo JText::_('Conflicted'); ?></option>
						</select>
					</td>
    			</tr>
    			    			<tr>
					<td class="key"><label><?php echo JText::_('Total Price'); ?>: </label></td>
					<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullPrice); ?></strong></td>
				</tr>
				<tr>
					<td class="key"><label><?php echo JText::_('Tax'); ?>: </label></td>
					<td><strong><?php echo BookingHelper::displayPrice(BookingHelper::getFullTax($this->reservedItems)); ?></strong></td>
				</tr>
		   		<tr>
					<td class="key"><label><?php echo JText::_('Deposit'); ?>: </label></td>
					<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullDeposit); ?></strong></td>
				</tr>
				<tr>
			    	<td class="key"><label><?php echo JText::_('Deposit must be paid before'); ?>: </label></td>
					<td><strong><?php echo $this->depositExpires; ?></strong></td>				
	    		</tr>
    		</table>
    	</fieldset>
    	
    	<?php 
    		if ($this->ajaxForItems) { 
    			$ajaxOutput['total'] = ob_get_clean();
    			$ajaxOutput = json_encode($ajaxOutput);
    			die($ajaxOutput);
    		}
    	?>
    	
    	</div>
    	
   	</div>
   	<div class="clr">&nbsp;</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
	<input type="hidden" name="boxchecked" value="1"/>
	<input type="hidden" name="cid[]" value="<?php echo $this->reservation->id; ?>"/>
	<input type="hidden" name="task" value=""/>
	<?php echo JHTML::_('form.token'); ?>
</form>