<?php

/**
 * Subject-rezervation-types edit form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

$options[] = JHTML::_('select.option', '', JText::_('Select list'));
$options[] = JHTML::_('select.option', RESERVATION_TYPE_HOURLY, JText::_('Hourly'));
$options[] = JHTML::_('select.option', RESERVATION_TYPE_DAILY, JText::_('Daily'));

$days[] = JHTML::_('select.option', 'any', JText::_('Anyday'));
$days[] = JHTML::_('select.option', 'mon', JText::_('Monday'));
$days[] = JHTML::_('select.option', 'tue', JText::_('Tuesday'));
$days[] = JHTML::_('select.option', 'wed', JText::_('Wednesday'));
$days[] = JHTML::_('select.option', 'thu', JText::_('Thursday'));
$days[] = JHTML::_('select.option', 'fri', JText::_('Friday'));
$days[] = JHTML::_('select.option', 'sat', JText::_('Saturday'));
$days[] = JHTML::_('select.option', 'sun', JText::_('Sunday'));

?>	
<div class="width-100" id="reservation-types">
	<fieldset class="adminform">
    	<legend class="hasTip" title="<?php echo $this->escape(JText::_('Reservation types')) . '::' . $this->escape(JText::_('Reservation types top info')); ?>">
    		<?php echo JText::_('Reservation Settings'); ?> 
    	</legend>
    	<div class="col" style="width: 100%">
    		<table class="template">
    			<tr>
    				<td>
    					<input type="checkbox" class="inputCheckbox" name="rlimit_set" id="rlimit_set" value="1"<?php if ($this->subject->rlimit_set) { ?> checked="checked"<?php } ?> onclick="EditSubject.setRLimit()" />
    					<label for="rlimit_set" class="hasTip" title="<?php echo $this->escape(JText::_('Reservation limit')) . '::' . $this->escape(JText::_('Reservation limit info')); ?>"><?php echo JText::_('Set reservation limit'); ?></label>
    				</td>
    				<td colspan="2" >
    					<div id="rlimit_box"<?php if (! $this->subject->rlimit_set) { ?> style="display: none"<?php } ?>>
    						<label for="rlimit_count" style="float: left"><?php echo JText::_('Reservation limit count'); ?></label>
    						<input type="text" style="float: left" name="rlimit_count" id="rlimit_count" value="<?php echo $this->subject->rlimit_count; ?>" onkeyup="ACommon.toInt(this)" size="5" />
    						<label for="rlimit_days" style="float: left"><?php echo JText::_('reservation limit items'); ?></label>
    						<input type="text" style="float: left" name="rlimit_days" id="rlimit_days" value="<?php echo $this->subject->rlimit_days; ?>" onkeyup="ACommon.toInt(this)" size="5" />
    						<label style="float: left"><?php echo JText::_('reservation limit units'); ?></label>
    					</div>
    				</td>
    			</tr>
    			<tr>
					<td colspan="3">
    					<input type="checkbox" class="inputCheckbox" name="price_overlay" id="price_overlay" value="1" <?php if ($this->subject->price_overlay == 1) { ?>checked="checked"<?php } ?> />
    					<label class="hasTip" for="price_overlay" title="<?php echo $this->escape(($title = JText::_('Overlay Prices'))) . '::' . $this->escape(JText::_('Overlay Prices info')); ?>"><?php echo $title; ?></label>
    				</td>
    			</tr>
				<tr>
					<td colspan="3">
    					<input type="checkbox" class="inputCheckbox" name="display_only_one_rtype" id="display_only_one_rtype" value="1" <?php if ($this->subject->display_only_one_rtype == 1) { ?>checked="checked"<?php } ?> />
    					<label class="hasTip" for="display_only_one_rtype" title="<?php echo $this->escape(($title = JText::_('Display only one rtype'))) . '::' . $this->escape(JText::_('Display only one rtype info')); ?>"><?php echo $title; ?></label>
    				</td>
    			</tr>
    			<tr>
    				<td>
    					<input type="checkbox" class="inputCheckbox" name="use_fix_shedule" id="use_fix_shedule" value="1" <?php if ($this->subject->use_fix_shedule) { ?>checked="checked"<?php } ?> onclick="$('shedule_from').style.display = $('shedule_to').style.display = this.checked ? '' : 'none'" />		
    					<label class="hasTip" for="use_fix_shedule" title="<?php echo $this->escape(($title = JText::_('Use fix shedule'))) . '::' . $this->escape(JText::_('Use fix shedule info')); ?>"><?php echo $title; ?></label>
    				</td>
    				<td>
    					<div id="shedule_from"<?php if (! $this->subject->use_fix_shedule) { ?> style="display: none"<?php } ?>>
    						<label for="shedule_from"><?php echo JText::_('From'); ?><span class="star"> *</span></label>
    						<?php echo AHtml::getTimePicker($this->subject->shedule_from, 'shedule_from', true, '', true); ?>
    					</div>
    				</td>
    				<td>
    					<div id="shedule_to"<?php if (! $this->subject->use_fix_shedule) { ?> style="display: none"<?php } ?>>
    						<label for="shedule_to"><?php echo JText::_('To'); ?><span class="star"> *</span></label>
    						<?php echo AHtml::getTimePicker($this->subject->shedule_to, 'shedule_to', true, '', true); ?>
    					</div>
    					<!-- 
    					<label for="reserving" class="hasTip" title="<?php echo $this->escape(JText::_('Reserving')) . '::' . $this->escape(JText::_('Reserving info')); ?>"></label>
						<?php
    						$options2[] = JHTML::_('select.option', RESERVING_EXCLUSIVE, JText::_('Reserving exclusive'));
    						$options2[] = JHTML::_('select.option', RESERVING_CHAIN, JText::_('Reserving chain'));
    						$options2[] = JHTML::_('select.option', RESERVING_OVERLAP, JText::_('Reserving overlap'));
    						echo JHTML::_('select.genericlist', $options2, 'reserving', '', 'value', 'text', $this->subject->reserving);
   						?>
    					-->
    				</td>
    			</tr> 
    			<tr>
    				<td>
    					<input type="checkbox" class="inputCheckbox" name="night_booking" id="night_booking" value="1" <?php if ($this->subject->night_booking) { ?>checked="checked"<?php } ?> onclick="$('night_booking_from').style.display = $('night_booking_to').style.display = this.checked ? '' : 'none'" />
    					<label class="hasTip" for="night_booking" title="<?php echo $this->escape(($title = JText::_('Night booking'))) . '::' . $this->escape(JText::_('Night booking info')); ?>"><?php echo $title; ?></label>
    				</td>
    				<td>
    					<div id="night_booking_from"<?php if (! $this->subject->night_booking) { ?> style="display: none"<?php } ?>>
    						<label for="night_booking_from"><?php echo JText::_('Check In'); ?><span class="star"> *</span></label>
    						<?php echo AHtml::getTimePicker($this->subject->night_booking_from, 'night_booking_from', true, ''); ?>
    					</div>
    				</td>
    				<td>
    					<div id="night_booking_to"<?php if (! $this->subject->night_booking) { ?> style="display: none"<?php } ?>>
    						<label for="night_booking_to"><?php echo JText::_('Check Out'); ?><span class="star"> *</span></label>
    						<?php echo AHtml::getTimePicker($this->subject->night_booking_to, 'night_booking_to', true, ''); ?>
    					</div>
    				</td>
    			</tr>
    			<tr>
    				<td>
    					<label class="hasTip" for="min_limit" title="<?php echo $this->escape(($title = JText::_('Min rtype limit'))) . '::' . $this->escape(JText::_('Min rtype limit info')); ?>"><?php echo $title; ?></label>
    				</td>
    				<td colspan="2">
    					<input type="text" name="min_limit" id="min_limit" value="<?php echo $this->subject->min_limit; ?>" onkeyup="ACommon.toInt(this)" class="number" size="5"/>
    				</td>
    			</tr>
			</table>
		</div>
	</fieldset>
	<fieldset class="adminform">
    	<legend class="hasTip" title="<?php echo $this->escape(JText::_('Reservation types')) . '::' . $this->escape(JText::_('Reservation types top info')); ?>">
    		<?php echo JText::_('Reservation types'); ?> 
    	</legend>
    	<div class="col">
    		<?php
    			//new
	    		$bar = &JToolBar::getInstance('r-types');
	    		$bar->appendButton('ALink', 'new', 'Add', 'EditSubject.addRtype()');
	    		$bar->appendButton('ALink', 'delete', 'Delete', 'EditSubject.removeRtypes()');
	    		echo $bar->render();
    			//old
    			/*
    			$bar = &JToolBar::getInstance('r-types');
        		$bar->appendButton('Link', 'new', 'Add', 'javascript:EditSubject.addRtype();');
        		$bar->appendButton('Link', 'delete', 'Delete', 'javascript:EditSubject.removeRtypes();');
        		echo $bar->render();
        		*/
    		?>
    		<div class="clr"></div>
			<table class="template">
				<thead>
					<tr>
						<th rowspan="2" valign="top">&nbsp;</th>
						<th rowspan="2" valign="top"><h3><?php echo JText::_('ID'); ?></h3></th>
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Title'); ?><span class="star"> *</span></h3></th>
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Type'); ?><span class="star"> *</span></h3></th>
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Description'); ?></h3></th>
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Limit Restrictions'); ?></h3></th>
						<!-- 
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Capacity unit'); ?></h3></th>
						 -->
						<th colspan="3" align="center" valign="top"><h3><?php echo JText::_('Settings only for hourly reservation types'); ?></h3></th>
						<!-- 
						<th rowspan="2" valign="top"><h3><?php echo JText::_('Special offer'); ?></h3></th>
						 -->
					</tr>
					<tr>
						<th valign="top"><h3><?php echo JText::_('Time Unit'); ?><span class="star"> *</span></h3></th>
						<th valign="top"><h3><?php echo JText::_('Gap Time'); ?></h3></th>
					</tr>
				</thead>
				<tbody id="rtypes">
				<?php 
					$pcount = count($this->rtypes);
					for ($i = 0; $i < $pcount; $i++) {
						$rtype = &$this->rtypes[$i];
						/* @var $rtype TableReservationType */
						TableReservationType::display($rtype);
						$id = $i ? $rtype->id : ''; 
					?>
						<tr <?php if (! $id) { echo 'id="rtype" style="display: none;"'; } ?>>
							<td class="check" valign="top">
								<input type="checkbox" class="inputCheckbox" name="rcid[]" value="1"/>
							</td>
							<td class="id" valign="top">
								<?php echo $id ? $id : '<i>' . JText::_('New') . '</i>'; ?>
							</td>
							<td valign="top">
								<input type="text" name="<?php echo RTYPES_PREFIX; ?>title[<?php echo $id; ?>]" value="<?php echo $rtype->title; ?>" class="title"/>
							</td>
							<td valign="top">
								<?php echo JHTML::_('select.genericlist', $options, RTYPES_PREFIX . 'type[' . $id . ']', 'onchange="EditSubject.setReservationType(this)"', 'value', 'text', $rtype->type); ?>
							</td>
							<td valign="top">
								<textarea name="<?php echo RTYPES_PREFIX; ?>description[<?php echo $id; ?>]" class="description" rows="1" cols="50"><?php echo $rtype->description; ?></textarea>
							</td>
							<td valign="top">
								<div class="limitLegend" style="float: left">
									<label for="min<?php echo $rtype->id; ?>" class="hasTip" title="<?php echo $this->escape(JText::_('Min limit')) . '::' . $this->escape(JText::_('Min limit info')); ?>"><?php echo JText::_('Min limit'); ?></label>
									<input id="min<?php echo $rtype->id; ?>" type="text" name="<?php echo RTYPES_PREFIX; ?>min[<?php echo $id; ?>]" value="<?php echo $rtype->min; ?>" />
								</div>
								<div class="limitLegend" style="float: left">
									<label for="max<?php echo $rtype->id; ?>" class="hasTip" title="<?php echo $this->escape(JText::_('Max limit')) . '::' . $this->escape(JText::_('Max limit info')); ?>"><?php echo JText::_('Max limit'); ?></label>
									<input id="max<?php echo $rtype->id; ?>" type="text" name="<?php echo RTYPES_PREFIX; ?>max[<?php echo $id; ?>]" value="<?php echo $rtype->max; ?>" />
								</div>
								<div class="limitLegend">
									<label for="fix<?php echo $rtype->id; ?>" class="hasTip" title="<?php echo $this->escape(JText::_('Fix limit')) . '::' . $this->escape(JText::_('Fix limit info')); ?>"><?php echo JText::_('Fix limit'); ?></label>
									<input id="fix<?php echo $rtype->id; ?>" type="text" name="<?php echo RTYPES_PREFIX; ?>fix[<?php echo $id; ?>]" value="<?php echo $rtype->fix; ?>" />
								</div>
								<div class="limitLegend">
									<label for="fix<?php echo $rtype->id; ?>" class="hasTip" title="<?php echo $this->escape(JText::_('Fix from')) . '::' . $this->escape(JText::_('Fix from info')); ?>"><?php echo JText::_('Fix from'); ?></label>
									<?php echo JHTML::_('select.genericlist', $days, RTYPES_PREFIX . 'fix_from[' . $id . ']', '', 'value', 'text', $rtype->fix_from); ?>
								</div>					
								<div class="limitLegend">
									<input type="hidden" name="<?php echo RTYPES_PREFIX; ?>book_fix_past[<?php echo $id; ?>]" value="0" />
									<input id="book_fix_past<?php echo $rtype->id; ?>" type="checkbox" name="<?php echo RTYPES_PREFIX; ?>book_fix_past[<?php echo $id; ?>]" value="1" <?php if ($rtype->book_fix_past) { ?>checked="checked"<?php } ?> />
									<label for="book_fix_past<?php echo $rtype->id; ?>" class="hasTip" title="<?php echo $this->escape(JText::_('Book fix limit to the past')) . '::' . $this->escape(JText::_('Book fix limit to the past info')); ?>"><?php echo JText::_('Book fix limit to the past'); ?></label>
								</div>			
							</td>
							<!-- 
							<td valign="top">
								<input type="text" name="<?php echo RTYPES_PREFIX; ?>capacity_unit[<?php echo $id; ?>]" value="<?php echo $rtype->capacity_unit; ?>" class="number" onkeyup="ACommon.toInt(this)" />
							</td>
							 -->
							<td class="time" valign="top">
								<input type="text" name="<?php echo RTYPES_PREFIX; ?>time_unit[<?php echo $id; ?>]" value="<?php echo $rtype->time_unit; ?>" class="number" onkeyup="ACommon.toInt(this)" />
							</td>
							<td class="time" valign="top">
								<input type="text" name="<?php echo RTYPES_PREFIX; ?>gap_time[<?php echo $id; ?>]" value="<?php echo $rtype->gap_time; ?>" class="number" onkeyup="ACommon.toInt(this)" />
							</td>
							<!-- 
							<td valign="top" align="center">
								<input type="checkbox" name="<?php echo RTYPES_PREFIX; ?>special_offer[<?php echo $id; ?>]" value="1" <?php if ($rtype->special_offer) { ?>checked="checked"<?php } ?> class="inputCheckbox" />
							</td>
							 -->
						</tr>
					<?php } ?>
						<tr id="rtype-empty" <?php if ($pcount > 1) { ?>style="display: none;"<?php } ?>><td colspan="7" class="emptyList"><?php echo JText::_('Empty reservation types list'); ?></td></tr>
				</tbody>
			</table>
		</div>
		<div class="clr"></div>
    </fieldset>
</div>    