/**
 * Javascript for edit reservation form.
 * 
 * @version $Id$
 * @package ARTIO Booking
 * @subpackage assets
 * @copyright Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link http://www.artio.net Official website
 */

/**
 * Valid form before submit. Standard in Joomla! administration.
 * 
 * @param pressbutton
 *            button selected in toolbar
 */

var rfields = new Array();

var ViewReservation = {

	submitbutton : function(pressbutton) {
		var form = ACommon.getForm();
		switch (pressbutton) {
		case 'save':
		case 'apply':
			break;
		default:
			submitform(pressbutton);
			return;
		}
		for ( var i = 0; i < rfields.length; i++) {
			var field = rfields[i];
			var el = document.getElementById(field.name);
			if (el) {
				var value = trim(el.value);
				if (value == '' || value == '0') {
					alert(field.msg);
					return;
				}
				if (el.name == 'email' && !isEmail(value)) {
					alert(LGErrAddReservationValidEmail);
					return;
				}
			}
		}
		if (form.capacity != undefined) {
			if (trim(form.capacity.value) == '') {
				alert(LGErrAddReservationCapacity);
				return;
			} else if (!AValidator.isInt(form.capacity.value)) {
				alert(LGErrReservationCapacityMustBeInteger);
				return;
			}
		}
		if (form.subject != undefined
				&& (trim(form.subject.value) == '' || trim(form.subject.value) == '0')) {
			alert(LGErrAddReservationSubject);
			return;
		}
		if (form.subject_title != undefined
				&& trim(form.subject_title.value) == '') {
			alert(LGErrAddReservationSubjectTitle);
			return;
		}
		if (form.from != undefined && trim(form.from.value) == '') {
			alert(LGErrAddReservationFrom);
			return;
		}
		if (!ACommon.validDateTimeInterval('from', 'to', LGErrReservationInvalidInterval)) {
			return;
		}
		if (form.to != undefined && trim(form.to.value) == '') {
			alert(LGErrAddReservationTo);
			return;
		}
		if (form.price != undefined && trim(form.price.value) == '') {
			alert(LGErrAddReservationPrice);
			return;
		}
		if (form.captcha != undefined && trim(form.captcha.value) == '') {
			alert(LGErrAddCaptcha);
			return;
		}
		if (form.rtype != undefined && trim(form.rtype.value) == '') {
			alert(LGErrAddRType);
			return;
		}
		if (form.accept_terms_of_contract != undefined && !form.accept_terms_of_contract.checked) {
			alert(LGErrAcceptContract);
			return;
		}
		if (form.accept_terms_of_privacy != undefined && !form.accept_terms_of_privacy.checked) {
			alert(LGErrAcceptPrivacy);
			return;
		}
		submitform(pressbutton);
	}
}

try {
	/**
	 * Joomla! 1.6.x
	 */
	Joomla.submitbutton = function(pressbutton) {
		return ViewReservation.submitbutton(pressbutton);
	}
} catch (e) {}
/**
 * Joomla! 1.5.x
 */
function submitbutton(pressbutton) {
	return ViewReservation.submitbutton(pressbutton);
}

function refreshReservation() {
	$('adminForm').task.value = 'refresh';
	$('adminForm').controller.value = '';
	new Request({
	    url: 'index.php?option=com_booking&view=reservation&layout=form&ajaxForItems=1',
	    method: 'post',
	    data: $('adminForm').toQueryString(),
	    async: false,
	    onSuccess: function(responseText) {
	    	var data = JSON.decode(responseText);
	        $('reservedItems').set('html', data['items']);
	        $('reservationTotal').set('html', data['total']);
	        $('adminForm').controller.value = 'reservation';
	    },
	}).send();
	return false;
}

function removeReservationItem(id, rid) {
	if (rid == 0) {
		$('reservationItem'+id).dispose();
		$('reservationItemSupplements'+id).dispose();
		refreshReservation();
	} else {
		if (confirm(LGAreYouSure))
			new Request({
				url: 'index.php?option=com_booking&controller=reservation&task=remove_item_db&tmpl=component',
				method: 'get',
				data: {'id' : id, 'rid': rid},
				async: false,
				onSuccess: function(responseText) {
					if (responseText == '1') {
						if ($('reservationItem'+id))
							$('reservationItem'+id).dispose();
						if ($('reservationItemSupplements'+id))
							$('reservationItemSupplements'+id).dispose();
					} else {
						alert(LGErrDisallowRemoveOnlyItem);
					}
				},
			}).send();
	}
}