<?php

/**
 * Reservation edit form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservation */

$config = AFactory::getConfig();

?>
<div class="edit item-page">
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<h1><?php echo JText::_('Reservation')?></h1>
	<div class="bookingToolbar">
		<a class="aIconToolSave tool save" title="<?php echo JText::_('Save', true); ?>" href="javascript:submitbutton('save')"><?php echo JText::_('Save', true); ?></a>
		<a class="aIconToolApply tool apply" title="<?php echo JText::_('Apply', true); ?>" href="javascript:submitbutton('apply')"><?php echo JText::_('Apply', true); ?></a>
		<a class="aIconToolCancel tool cancel" title="<?php echo JText::_('Cancel', true); ?>" href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATIONS)); ?>"><?php echo JText::_('Cancel', true); ?></a>
		<div class="clr"></div>
	</div>
		<fieldset>
    		<legend><?php echo JText::_('Customer'); ?></legend>
    		<table>
	    		<tr>
    				<td class="key"><label><?php echo JText::_('Customer'); ?>:</label></td>
    				<td><?php echo JElementCustomer::fetchElement($this->reservation->customer); ?></td>
    			</tr>    			
	    		<tr>
    				<td class="key"><label for="title_before"><?php echo JText::_('Title before'); ?>: </label></td>
    				<td><input type="text" name="title_before" id="title_before" maxlength="255" value="<?php echo $this->reservation->title_before; ?>" /></td>
    			</tr>
	    		<tr>
    				<td class="key"><label for="firstname"><?php echo JText::_('First name'); ?>: </label></td>
    				<td><input type="text" name="firstname" id="firstname" maxlength="255" value="<?php echo $this->reservation->firstname; ?>" /></td>
    			</tr>
	    		<tr>
	    			<td class="key"><label for="middlename"><?php echo JText::_('Middle name'); ?>: </label></td>
	    			<td><input type="text" name="middlename" id="middlename" maxlength="255" value="<?php echo $this->reservation->middlename; ?>" /></td>
	    		</tr>	
	    		<tr>
	    			<td class="key"><label for="surname"><?php echo JText::_('Surname'); ?>: </label></td>
	    			<td><input type="text" name="surname" id="surname" maxlength="255" value="<?php echo $this->reservation->surname; ?>" /></td>
	    		</tr>
	    		<tr>
	    			<td class="key"><label for="title_after"><?php echo JText::_('Title after'); ?>: </label></td>
	    			<td><input type="text" name="title_after" id="title_after" maxlength="255" value="<?php echo $this->reservation->title_after; ?>" /></td>
	    		</tr>
	    		<tr>
	    			<td class="key"><label for="company"><?php echo JText::_('Company'); ?>: </label></td>
	    			<td><input type="text" name="company" id="company" maxlength="255" value="<?php echo $this->reservation->company; ?>" /></td>
	    		</tr>
	    		<tr>
	    			<td class="key"><label for="company_id"><?php echo JText::_('Company ID'); ?>: </label></td>
	    			<td><input type="text" name="company_id" id="company_id" maxlength="255" value="<?php echo $this->reservation->company_id; ?>" /></td>
	    		</tr>
	    		<tr>
	    			<td class="key"><label for="vat_id"><?php echo JText::_('Vat ID'); ?>: </label></td>
	    			<td><input type="text" name="vat_id" id="vat_id" maxlength="255" value="<?php echo $this->reservation->vat_id; ?>" /></td>
	    		</tr>
    		<?php if (is_array($config->rsExtra)) { 
    				foreach ($config->rsExtra as $field) { ?>
	    				<tr>
	    					<td class="key"><label for="<?php echo $field['name']; ?>"><?php echo $field['title']; ?>: </label></td>
	    					<td><input type="text" name="<?php echo $field['name']; ?>" id="<?php echo $field['name']; ?>" size="60" maxlength="255" value="<?php echo AUtils::getArrayValue($this->reservation->fields, $field['name'] . '.value'); ?>" /></td>
	    			</tr>
			<?php } 
    			} ?>
			</table>
    	</fieldset>
    <?php     	
    	$z=0;
		$countReservedItems = count($this->reservedItems);
    	if ($countReservedItems)
    		foreach ($this->reservedItems as $reservedItem){
				$id = $z++;
				$subject = $this->subjects[$reservedItem->subject];

	?>
    	<fieldset id="reservationItem<?php echo $reservedItem->id; ?>">
    		<legend><?php if ($countReservedItems>1) echo '#'.$z.' '?><?php echo JText::_('Reservation'); ?></legend>
    		
    		<input type="hidden" name="id[<?php echo $id?>]" value="<?php echo $reservedItem->id?>" />
    		<input type="hidden" name="subject[<?php echo $id?>]" value="<?php echo $reservedItem->subject?>" />
    		<input type="hidden" name="subject_title[<?php echo $id?>]" value="<?php echo $reservedItem->subject_title?>" />
    		<input type="hidden" name="rtype[<?php echo $id?>]" value="<?php echo $reservedItem->rtype?>" />
    		<?php if (!empty($reservedItem->boxIds)) { ?>
    			<?php foreach ($reservedItem->boxIds as $bid) { ?>
					<input type="hidden" name="boxIds[<?php echo $id?>][]" value="<?php echo $bid; ?>" />
				<?php } ?>
			<?php } else { ?>
				<input type="hidden" name="boxIds[<?php echo $id?>][]" value="<?php echo $bid; ?>" />
			<?php } ?>
    		<table>    		
	    	<tr>
	    		<td class="key"><label></label></td>
   				<td><a class="aIconLegend aIconUnpublish" href="javascript:removeReservationItem(<?php echo $reservedItem->id; ?>, <?php echo $this->reservation->id; ?>)" title=""><?php echo JText::_('Remove Item'); ?></a></td>
			</tr>    		
	    	<tr>
	    		<td class="key"><label for="subject_title[<?php echo $id?>]"><?php echo JText::_('Subject'); ?>: </label></td>
	    		<td><input type="text" name="subject_title[<?php echo $id?>]" id="subject_title[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->subject_title; ?>" /></td>
	    	</tr>
    		<tr>
    			<td class="key"><label for="capacity[<?php echo $id?>]"><?php echo JText::_('Capacity'); ?>: </label></td>
    			<td><input type="text" name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->capacity; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="from[<?php echo $id?>]"><?php echo JText::_('From'); ?>: </label></td>
    			<td>
    				<div style="display: inline-block;">
    					<?php echo AHtml::getCalendar($reservedItem->from, 'from['.$id.']','from['.$id.']', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); ?>
	    			</div>
    			</td>
    		</tr>
    		<tr>
    			<td class="key"><label for="to[<?php echo $id?>]"><?php echo JText::_('To'); ?>: </label></td>
    			<td>
    				<div style="display: inline-block;">
    					<?php echo AHtml::getCalendar($reservedItem->to, 'to['.$id.']', 'to['.$id.']', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); ?>
    				</div>
    			</td>
    		</tr>
    		<tr>
    			<td class="key"><label for="price"><?php echo ITEM_PRICE_TIP ?>: </label></td>
    			<td><input type="text" name="price[<?php echo $id?>]" id="price[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->price; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="fullPrice"><?php echo FULL_PRICE_TIP ?>: </label></td>
    			<td><input type="text" name="fullPrice[<?php echo $id?>]" id="fullPrice[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->fullPrice; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="fullPriceSupplements"><?php echo FULL_PRICE_SUPPLEMENTS_TIP ?>: </label></td>
    			<td><input type="text" name="fullPriceSupplements[<?php echo $id?>]" id="fullPriceSupplements[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->fullPriceSupplements; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="deposit"><?php echo ITEM_DEPOSIT_TIP ?>: </label></td>
    			<td><input type="text" name="deposit[<?php echo $id?>]" id="deposit[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->deposit; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="fullDeposit"><?php echo FULL_DEPOSIT_TIP ?>: </label></td>
    			<td><input type="text" name="fullDeposit[<?php echo $id?>]" id="fullDeposit[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->fullDeposit; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="tax"><?php echo JText::_('TAX'); ?>: </label></td>
    			<td><input type="text" name="tax[<?php echo $id?>]" id="tax[<?php echo $id?>]" maxlength="255" value="<?php echo $reservedItem->tax; ?>" /></td>
    		</tr>
    		<?php 
    			foreach ($reservedItem->supplementsRaw as $supplement) {
    				$value = $capacity = null;
					foreach ($reservedItem->supplements as $item) {
						$toCompare = $this->reservation->id ? $item->supplement : $item->id;
						if ($toCompare == $supplement->id) {
							$value = $item->value;
							$capacity = $item->capacity;
							break;
						}
					}
				?>
					<tr>
						<td class="key"><label><?php echo $supplement->title; ?>: </label></td>
						<td><?php echo BookingHelper::displaySupplementInput($supplement, $value, $capacity, $id); ?></td>
					</tr>  	
    		<?php } ?>		
    		</table>
    	</fieldset>
    <?php } ?>
    	<fieldset>
    		<legend><?php echo JText::_('Payment'); ?></legend>
    		<table>
    		<tr>
    			<td class="key"><label for="fax"><?php echo JText::_('Is Receive'); ?>: </label></td>
    			<td>
    				<select name="paid" id="paid">
    					<option value="<?php echo RESERVATION_RECEIVE; ?>" <?php if ($this->reservation->paid == RESERVATION_RECEIVE) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('JYES'); ?></option>
	    				<option value="<?php echo RESERVATION_RECEIVE_DEPOSIT; ?>" <?php if ($this->reservation->paid == RESERVATION_RECEIVE_DEPOSIT) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('Deposit'); ?></option>
    					<option value="<?php echo RESERVATION_PENDING; ?>" <?php if ($this->reservation->paid == RESERVATION_PENDING) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('JNO'); ?></option>
    				</select>
				</td>
			</tr>
			<tr>
				<td class="key"><label for="fax"><?php echo JText::_('Status'); ?>: </label></td>
				<td>
					<select name="state" id="state">
						<option value="<?php echo RESERVATION_PRERESERVED; ?>" <?php if ($this->reservation->state == RESERVATION_PRERESERVED) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('Pre-reserved'); ?></option>
	    				<option value="<?php echo RESERVATION_ACTIVE; ?>" <?php if ($this->reservation->state == RESERVATION_ACTIVE) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('Reserved'); ?></option>
    					<option value="<?php echo RESERVATION_STORNED; ?>" <?php if ($this->reservation->state == RESERVATION_STORNED) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('Cancelled'); ?></option>
    					<option value="<?php echo RESERVATION_TRASHED; ?>" <?php if ($this->reservation->state == RESERVATION_TRASHED) { ?>selected="selected"<?php } ?>>
    						<?php echo JText::_('Trashed'); ?></option>
		    				<option value="<?php echo RESERVATION_CONFLICTED; ?>" <?php if ($this->reservation->state == RESERVATION_TRASHED) { ?>selected="selected"<?php } ?>>
    					<?php echo JText::_('Conflicted'); ?></option>
    				</select>
				</td>
			</tr>
    		    		</table>
    	</fieldset>
    	<fieldset>
    		<legend><?php echo JText::_('Contact'); ?></legend>
    		<table>
    		<tr>
    			<td class="key"><label for="street"><?php echo JText::_('Street'); ?>: </label></td>
    			<td><input type="text" name="street" id="street" maxlength="255" value="<?php echo $this->reservation->street; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="city"><?php echo JText::_('City'); ?>: </label></td>
    			<td><input type="text" name="city" id="city" maxlength="255" value="<?php echo $this->reservation->city; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="zip"><?php echo JText::_('Zip'); ?>: </label></td>
    			<td><input type="text" name="zip" id="zip" maxlength="255" value="<?php echo $this->reservation->zip; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="country"><?php echo JText::_('Country'); ?>: </label></td>
    			<td><input type="text" name="country" id="country" maxlength="255" value="<?php echo $this->reservation->country; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="email"><?php echo JText::_('Email'); ?>: </label></td>
    			<td><input type="text" name="email" id="email" maxlength="255" value="<?php echo $this->reservation->email; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="telephone"><?php echo JText::_('Telephone'); ?>: </label></td>
    			<td><input type="text" name="telephone" id="telephone" maxlength="255" value="<?php echo $this->reservation->telephone; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="fax"><?php echo JText::_('Fax'); ?>: </label></td>
    			<td><input type="text" name="fax" id="fax" maxlength="255" value="<?php echo $this->reservation->fax; ?>" /></td>
    		</tr>
    		<tr>
    			<td class="key"><label for="note"><?php echo JText::_('Note'); ?></label></td>
    			<td><textarea name="note" id="note" cols="50" rows="10"><?php echo $this->reservation->note; ?></textarea></td>
    		</tr>
		    </table>
    	</fieldset>
	<div class="bookingToolbar">
		<a class="aIconToolSave tool save" title="<?php echo JText::_('Save', true); ?>" href="javascript:submitbutton('save')"><?php echo JText::_('Save', true); ?></a>
		<a class="aIconToolApply tool apply" title="<?php echo JText::_('Apply', true); ?>" href="javascript:submitbutton('apply')"><?php echo JText::_('Apply', true); ?></a>
		<a class="aIconToolCancel tool cancel" title="<?php echo JText::_('Cancel', true); ?>" href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATIONS)); ?>"><?php echo JText::_('Cancel', true); ?></a>
	</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>" />
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>" />
	<input type="hidden" name="boxchecked" value="1" />
	<input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
	<input type="hidden" name="cid[]" value="<?php echo $this->reservation->id; ?>" />
	<input type="hidden" name="task" value="" />
	<?php echo JHTML::_('form.token'); ?>
</form>
</div>