<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelLocation extends JModel
{
	
	public function getItem($id = 0)
	{
		$id = reset(JRequest::getVar('cid', array(JRequest::getInt('id', $id))));
		$item = $this->getTable();
		/* @var $item TableLocation */
		$item->load($id);
		return $item;
	}
	
	public function save()
	{
		$data = JRequest::get('request');
		$location = $this->getTable();
		/* @var $location TableLocation */
		$location->bind($data);
		$location->store();
		return $location->id;
	}
	
	public function delete()
	{
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query = 'DELETE FROM #__booking_location WHERE id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
	
	public function pick_up_publish() {
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query .= 'UPDATE  #__booking_location SET pick_up = 1 WHERE id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
	
	public function pick_up_unpublish() {
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query .= 'UPDATE  #__booking_location SET pick_up = 0 WHERE id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
	
	public function drop_off_publish() {
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query .= 'UPDATE  #__booking_location SET drop_off = 1 WHERE id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
	
	public function drop_off_unpublish() {
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query .= 'UPDATE  #__booking_location SET drop_off = 0 WHERE id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
}