<?php

/**
 * Subjects list model. Support for loading database data with apply filter.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  models 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed Joomla! libraries
jimport('joomla.application.component.model');

//import needed JoomLIB helpers
AImporter::helper('image', 'model', 'request', 'tree');

class BookingModelSubjects extends AModel
{
    
    /**
     * Main table
     * 
     * @var TableSubject
     */
    var $_table;

    function __construct()
    {
        parent::__construct();
        $this->_table = $this->getTable('subject');
    }

    /**
     * Get complet list data
     * 
     * @return array subjects objects
     */
    function getData()
    {
        if (empty($this->_data)) {
            if (IS_ADMIN) {
                $fullList = $this->getFullList();
                $filterList = $this->getFilterList();
                            
				$this->_data = ATree::getListTree($fullList, $filterList, 0, 2);
				
            } elseif (IS_SITE) {
                $config = &AFactory::getConfig();
                /* @var $config BookingConfig */
                $query = $this->buildSimpleQuery();
                            
                $this->_data = $this->_getList($query, 0, 2);
                
            }
        }
        return $this->_data;
    }

    /**
     * Get total items count
     * 
     * @return int total count limited by filter
     */
    function getTotal()
    {
            
    	return 2;
    	
    }

    /**
     * Get full subjects list without apply filter
     * 
     * @return array subjects objects
     */
    function getFullList()
    {
        $query = $this->buildQuery(false);
            
        return $this->_getList($query, 0, 2);
        
    }

    /**
     * Get filtered subject list
     * 
     * @return array subjects objects 
     */
    function getFilterList()
    {
        $query = $this->buildQuery();
            
        return $this->_getList($query, 0, 2);
        
    }

    /**
     * Get MySQL loading query for subjects list.
     * 
     * @return string complet MySQL query
     */
    function buildQuery($filter = true)
    {
        if ($filter) {
            $query = 'SELECT `subject`.`id` FROM `' . $this->_table->getTableName() . '` AS `subject` ';
            $query .= $this->buildContentWhere();
        } else {
            $query = 'SELECT `subject`.*,`usergroup`.`' . (ISJ16 ? 'title' : 'name') . '` AS `groupname`, `editor`.`name` AS `editor` ';
            $query .= 'FROM `' . $this->_table->getTableName() . '` AS `subject` ';
            if (ISJ16)
                $query .= 'LEFT JOIN `#__viewlevels` AS `usergroup` ON `usergroup`.`id` = `subject`.`access` ';
            else
                $query .= 'LEFT JOIN `#__groups` AS `usergroup` ON `usergroup`.`id` = `subject`.`access` ';
            $query .= 'LEFT JOIN `#__users` AS `editor` ON `subject`.`checked_out` = `editor`.`id` ';
            $query .= $this->buildContentOrderBy();
        }
        return $query;
    }

    /**
     * Get query to load only currently published subjects.
     * 
     * @return string
     */
    function buildSimpleQuery()
    {
    	/*
    	 * Complex query:
    	* Select subject, join items from reservation (with specific date) and reservation
    	* Then group this records by subject id and set isEngaged to 0 if there is no reservation for object
    	* Select only objects without reservation (isEngaged=0) from all objects previosly selected
    	*/
    	
        static $query;
        
        if (empty($query)) {
            $templateHelper = AFactory::getTemplateHelper();
            /* @var $templateHelper ATemplateHelper */
            
            $cap = abs($this->_lists['required_capacity']); // capacity should be positive integer
        	if ($cap < 1) 
        		$cap = 1; // capacity has to be at lest 1
            
            $query = 'SELECT `sbj`.`id`, `sbj`.`title`, `sbj`.`alias`, `sbj`.`template`, `sbj`.`introtext`, `sbj`.`params`, COUNT(`kid`.`id`) AS `children` '; 
            
            if ($this->_lists['date_from'] || $this->_lists['date_to']) {
            	// search for reservations what cover date range and sum of their capacity make subject full in this period
            	$query .= ', (MAX(`rsv`.`state`) = ' . RESERVATION_ACTIVE . ' AND (`sbj`.`total_capacity` - SUM(CASE WHEN `rsv`.`state` IS NOT NULL THEN `itm`.`capacity` ELSE 0 end)) < ' . $cap . ') AS `isEngaged` '; // it will be test in parent select
            }
            	
            $query .= 'FROM `#__booking_subject` AS `sbj` ';
            $query .= 'LEFT JOIN `#__booking_subject` AS `kid` ON `kid`.`parent` = `sbj`.`id` '; // indentify parent - search if object has children
           	
            if ($this->_lists['date_from'] || $this->_lists['date_to']) {
            	if ($this->_lists['date_type'] == 'date') { // hardly to full day reservation format
            		$this->_lists['date_from'] = date('Y-m-d 00:00:00', strtotime($this->_lists['date_from']));
            		$this->_lists['date_to'] = date('Y-m-d 23:59:59', strtotime($this->_lists['date_to']));
            	}
            	// search for reservations what cover date range and sum of their capacity make subject full in this period
           		$query .= ' LEFT JOIN `#__booking_reservation_items` AS `itm` ON `itm`.`subject` = `sbj`.`id` ';
           		if ($this->_lists['date_from'])
            		$query .= ' AND `itm`.`from` <= ' . $this->_db->quote($this->jdate2save($this->_lists['date_to'], ADATE_FORMAT_MYSQL_DATETIME, true));
            	if ($this->_lists['date_to'])
            		$query .= ' AND `itm`.`to` >= ' . $this->_db->quote($this->jdate2save($this->_lists['date_from'], ADATE_FORMAT_MYSQL_DATETIME, true));
           		$query .= ' LEFT JOIN `#__booking_reservation` AS `rsv` ON `rsv`.`id` = `itm`.`reservation_id` ';
           		$query .= ' AND `rsv`.`state` = ' . RESERVATION_ACTIVE . ' '; // only active reservations
           	}
           	
            if ($this->_lists['price_from'] || $this->_lists['price_to']) // search for required price range 
            	$query .= 'LEFT JOIN `#__booking_price` AS `pre` ON `pre`.`subject` = `sbj`.`id` ';	
			
            if (!empty($this->_lists['properties'])) {
	            // filter by template properties
                foreach ($this->_lists['properties'] as $templateId => $properties) {
                    $template = $templateHelper->getTemplateById($templateId);
                    /* @var $template ATemplate */
                    $id = '`tmpl' . $templateId . '`'; // alias of template database table
                    foreach ($properties as $name => $param) { // check if properties has value to filter
                    	$value = JString::trim($param['value']);
                        if ($value) {
                            if ($param['type'] == 'text' || $param['type'] == 'textarea') // fulltext search
                                $where[] = $id . '.`' . $name . '` LIKE ' . $this->_db->Quote('%' . $value . '%');
                            else // search by key
                                $where[] = $id . '.`' . $name . '` = ' . $this->_db->Quote($value);
                        }
                    }
                    if (!empty($where)) // there is params to filter - join with template
                        $query .= ' LEFT JOIN `' . $template->getDBTableName() . '` AS ' . $id . ' ON ' . $id . '.`id` = `sbj`.`id` ';
                }
            }
            
            $where[] = '`sbj`.`state` = ' . SUBJECT_STATE_PUBLISHED; // always only published items
            $where[] = '`sbj`.`access` IN (' . implode(',', $this->_lists['access']) . ')'; // logged user ACL
            
            if (!is_null($this->_lists['parent'])) // search in parent branch
            	$where[] = '`sbj`.`parent` = ' . $this->_lists['parent'];
            else // search in all bookable objects - ignore no-bookable parents
            	$where[] = '`kid`.`id` IS NULL'; // hasn't children	
            
			$gmt0 = $this->_db->quote(AModel::getNow());            	
			$null = $this->_db->quote(AModel::getNullDate());
            	
            $where[] = '(`sbj`.`publish_up` <= ' . $gmt0 . ' OR `sbj`.`publish_up` = ' . $null . ')';
            $where[] = '(`sbj`.`publish_down` >= ' . $gmt0 . ' OR `sbj`.`publish_down` = ' . $null . ')'; // always only published items
            
            if ($this->_lists['template_area']) // search in specific template
            	$where[] = '`sbj`.`template` = ' . abs($this->_lists['template_area']); // template shoud be positive integer

            if ($this->_lists['price_from'] || $this->_lists['price_to']) {
            	// search for price covered required price range
            	if ($this->_lists['price_from'])
            		$where[] = '`pre`.`value` >= ' . $this->_db->quote($this->_lists['price_from']);
            	if ($this->_lists['price_to'])
            		$where[] = '`pre`.`value` <= ' . $this->_db->quote($this->_lists['price_to']);
            	// search for price covered required date range
            	if ($this->_lists['date_from']) {
            		$where[] = '`pre`.`date_up` <= ' . $this->_db->quote($this->jdate2save($this->_lists['date_to'], ADATE_FORMAT_MYSQL_DATE, true));
            		$where[] = '(`pre`.`time_up` <= ' . $this->_db->quote($this->jdate2save($this->_lists['date_to'], ADATE_FORMAT_MYSQL_TIME, true)) . ' OR `pre`.`time_up` = "00:00:00")'; // time up only in hourly reservation types
            	}
            	if ($this->_lists['date_to']) {
            		$where[] = '`pre`.`date_down` >= ' . $this->_db->quote($this->jdate2save($this->_lists['date_from'], ADATE_FORMAT_MYSQL_DATE, true));
            		$where[] = '(`pre`.`time_down` >= ' . $this->_db->quote($this->jdate2save($this->_lists['date_from'], ADATE_FORMAT_MYSQL_TIME, true)) . ' OR `pre`.`time_down` = "00:00:00")';
            	}
            }		
            	
            if ($this->_lists['required_capacity'])
            	$where[] = '`sbj`.`total_capacity` >= ' . $cap; // subject has to have required capacity, at lest 1
            	
            $query .= ' WHERE ' . implode(' AND ', $where);
            $query .= ' GROUP BY `sbj`.`id` '; // prevent for duplicities provided by joins
            $query .= ' ORDER BY `sbj`.`ordering` ASC ';
            
            if ($this->_lists['date_from'] || $this->_lists['date_to']) // parent select to test if subject is not engaged with reservations
            	$query = 'SELECT * FROM (' . $query . ') AS `s` WHERE `isEngaged` = 0 OR `isEngaged` IS NULL';
        }
        return $query;
    }

    /**
     * Get templates of all subjects with same parent a available on frontend.
     * 
     * @return array
     */
    function getAvailableTemplates()
    {
    	if ($this->_lists['parent'] !== '') {
        	$where[] = '`state` = ' . SUBJECT_STATE_PUBLISHED;
        	$where[] = '`access` IN (' . implode(',', $this->_lists['access']) . ')';
        	if ($this->_lists['parent'] !== null)
        		$where[] = '`parent` = ' . (int) $this->_lists['parent'];
        	$where[] = '(`publish_up` <= \'' . ($now = AModel::getNow()) . '\' OR `publish_up` = \'' . ($nullDate = AModel::getNullDate()) . '\')';
        	$where[] = '(`publish_down` >= \'' . $now . '\' OR `publish_down` = \'' . $nullDate . '\')';
        	$this->_db->setQuery('SELECT DISTINCT `template` FROM `' . $this->_table->getTableName() . '` WHERE ' . implode(' AND ', $where));
        	return $this->_db->loadResultArray();
    	}
    	return array();
    }

    
    /**
     * Get MySQL filter criteria for subjects list
     * 
     * @return string filter criteria in MySQL format
     */
    function buildContentWhere()
    {
        $search = isset($this->_lists['search']) ? JString::trim($this->_lists['search']) : '';
        $parent = isset($this->_lists['parent']) ? (int) $this->_lists['parent'] : 0;
        $state = isset($this->_lists['state']) ? $this->_lists['state'] : '';
        $access = isset($this->_lists['access']) ? $this->_lists['access'] : array();
        $template = isset($this->_lists['template']) ? (int) $this->_lists['template'] : 0;
        if ($search)
            $where[] = 'LOWER(`subject`.`title`) LIKE ' . $this->_db->Quote('%' . JString::strtolower($search) . '%');
        if ($parent) {
        	$childs = array();
            $this->loadChilds($parent, $childs);
            $childs[] = $parent;
            $where[] = '`subject`.`id` IN (' . implode(',', $childs) . ')';
        }
        if ($state !== '')
            $where[] = '`state` = ' . (int) $state;
        AModel::clean($access);
        if (($countAccess = count($access)))
            $where[] = '`access` IN (' . implode(',', $access) . ')';
        if ($template)
            $where[] = '`template` = ' . $template;

        return isset($where) ? ' WHERE ' . implode(' AND ', $where) : '';
    }

    /**
     * Load parents subjects Ids
     * 
     * @return array unique IDs
     */
    function loadParents()
    {
        $query = 'SELECT DISTINCT `parent` FROM ' . $this->_table->getTableName() . ' WHERE `parent` <> 0';
                
        $this->_db->setQuery($query, 0, 2);
        
        return $this->_db->loadResultArray();
    }

    /**
     * Load short list (only ID,title and parent ID) by subjects IDs
     * 
     * @param array $ids subjects IDs if null load all subjects
     * @return array stdClass objects contains subjects data
     */
    function loadShortListByIds($ids = null, $ignore = null)
    {
        $where = array();
        if (is_array($ids) && count($ids)) {
            $where[] = '`id` IN (' . implode(',', $ids) . ')';
        }
        if (is_array($ignore) && count($ignore)) {
            $where[] = '`id` NOT IN (' . implode(',', $ignore) . ')';
        }
        $where = count($where) ? ' WHERE ' . implode(' AND ', $where) : '';
        $query = 'SELECT `id`, `title`, `parent` FROM `' . $this->_table->getTableName() . '`' . $where;
                
        $this->_db->setQuery($query, 0, 2);
        
        return $this->_db->loadObjectList();
    }

    /**
     * Load IDs of parents childs recursive into deepth
     * 
     * @param int $parent parent ID
     * @param array $result array to saving IDs
     */
    function loadChilds($parent, &$result)
    {
        static $cache;
        static $list;
        if (is_null($list)) {
            $this->_db->setQuery('SELECT `id`,`parent` FROM `' . $this->_table->getTableName() . '` WHERE `parent` <> 0');
            $rows = &$this->_db->loadRowList();
            $list = array();
            $count = count($rows);
            for ($i = 0; $i < $count; $i ++) {
                $row = &$rows[$i];
                $list[(int) $row[0]] = (int) $row[1];
            }
            unset($rows);
        }
        if (! isset($cache[$parent])) {
            $childs = array();
            $parents = array($parent);
            while (true) {
                $count = count($parents);
                $nextParents = array();
                for ($i = 0; $i < $count; $i ++) {
                    $nextParents = array_merge($nextParents, array_keys($list, $parents[$i]));
                }
                if (count($nextParents)) {
                    $childs = array_merge($childs, $nextParents);
                    $parents = $nextParents;
                } else
                    break;
            }
            $cache[$parent] = $childs;
        }
        $result = $cache[$parent];
    }

    function loadSubjectParentsLine($id, $result = array())
    {
        $tableName = '`' . $this->_table->getTableName() . '`';
        $query = 'SELECT `parent`.`id`, `parent`.`title`, `parent`.`alias` ';
        $query .= 'FROM ' . $tableName . ' AS `child` ';
        $query .= 'LEFT JOIN ' . $tableName . ' AS `parent` ON `child`.`parent` = `parent`.`id` ';
        $query .= 'WHERE `child`.`id` = ' . $id;
                
        $this->_db->setQuery($query, 0, 2);
        
        $parent = $this->_db->loadObject();
        if ($parent && $parent->id) {
            $result[] = $parent;
            return $this->loadSubjectParentsLine($parent->id, $result);
        }
        return $result;
    }

    /**
     * Get query to loading subject ordering branch by parent
     * 
     * @return string complet MySQL query 
     */
    function getLoadOrderingQuery($subject)
    {
        return 'SELECT `ordering` AS `value`, `title` AS `text` FROM `' . $this->_table->getTableName() . '` WHERE `parent` = ' . (int) $subject->parent . ' ORDER BY `ordering`';
    }
    
    /**
     * Load reservations for concrete subjects in defined interval.
     * 
     * @param array $objectIds subjects ids
     * @param string $from from datetime
     * @param string $to to datetime
     */
    function loadReservations ($objectIds, $from, $to) 
    {
    	if (empty($objectIds)) return array();
		JArrayHelper::toInteger($objectIds);
    	$query = 'SELECT i.subject, s.total_capacity, i.from, i.to, i.capacity';
    	$query .= ' FROM #__booking_reservation_items AS i';
    	$query .= ' RIGHT JOIN #__booking_subject AS s ON s.id = i.subject';
    	$query .= ' RIGHT JOIN #__booking_reservation AS r ON r.id = i.reservation_id';
    	$query .= ' WHERE subject IN (' . implode(', ', $objectIds) . ')';
    	$query .= ' AND i.from <= ' . $this->_db->quote($to); 
    	$query .= ' AND i.to >= ' . $this->_db->quote($from); 
    	$query .= ' AND i.rtype = ' . RESERVATION_TYPE_DAILY;
    	$query .= ' AND r.state = ' . RESERVATION_ACTIVE;
    	return $this->_getList($query);
    }
}
?>
