<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelUsers extends JModel
{

	public function populateState()
	{
		$app = JFactory::getApplication();
		$this->setState('filter.search', $app->getUserStateFromRequest('com_booking.users.filter.search', 'filter_search', '', 'string'));
		$this->setState('list.limitstart', $app->getUserStateFromRequest('com_booking.users.filter.limitstart', 'limitstart', 0, 'int'));
		$this->setState('list.limit', $app->getUserStateFromRequest('com_booking.users.filter.limit', 'limit', 5, 'int'));
		$this->setState('list.ordering', $app->getUserStateFromRequest('com_booking.users.filter.order', 'filter_order', 'id'));
		$this->setState('list.direction', $app->getUserStateFromRequest('com_booking.users.filter.orderdir', 'filter_order_Dir', 'asc'));
	}
	
	public function getItems()
	{
		$this->populateState();
		
		$query = 'SELECT id, name, username, email FROM #__users ' . 
			$this->getWhere() . 
			' ORDER BY ' . $this->getState('list.ordering', 'l.title') . ' ' . $this->getState('list.direction', 'asc');
		
		$this->_db->setQuery($query);
		return $this->_db->loadObjectList();
	}
	
	public function getTotal()
	{
		$query = 'SELECT COUNT(*) FROM #__users ' . $this->getWhere();
	
		$this->_db->setQuery($query);
		return $this->_db->loadResult();
	}
	
	public function getPagination()
	{
		jimport('joomla.html.pagination');
		$pagination = new JPagination($this->getTotal(), $this->getState('list.limitstart'), $this->getState('list.limit'));
		return $pagination;
	}
	
	public function getWhere()
	{
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $this->_db->quote('%'.JString::strtolower($search).'%');
			return " WHERE LOWER(name) LIKE $search OR LOWER(username) LIKE $search OR LOWER(email) LIKE $search ";
		}
	
		return '';
	}
}