<?php
/**
 * Reservations list template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservations */

?>
<h1><?php echo JText::_('Reservation List'); ?></h1>
<form action="<?php echo JRoute::_(ARoute::viewlayout(VIEW_RESERVATIONS, 'customer')); ?>" method="post" name="adminForm" id="adminForm" class="registration">
	<div class="filter">
		<div class="filterItem">
		<label for="filter_items-subject_title" id="filter_subject_label"><?php echo JText::_('Item'); ?>: </label>
			<input type="text" name="filter_items-subject_title" id="filter_items-subject_title" size="15" class="inputbox" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['items-subject_title']); ?>"/>
			<label for="filter_from" id="filter_from_label"><?php echo JText::_('From'); ?>: </label>
			<?php echo AHtml::getCalendar($this->lists['from'], 'filter_from', 'filter_from', ADATE_FORMAT_MYSQL_DATE, ADATE_FORMAT_MYSQL_DATE_CAL); ?>
			<label for="filter_to" id="filter_to_label"><?php echo JText::_('To'); ?>: </label>
			<?php echo AHtml::getCalendar($this->lists['to'], 'filter_to', 'filter_to', ADATE_FORMAT_MYSQL_DATE, ADATE_FORMAT_MYSQL_DATE_CAL); ?>
		</div>
		<div class="filterItem">
			<?php 
				$options = array();
				$options[] = JHtml::_('select.option', '', '- ' . JText::_('Reservation Status') . ' -');
				$options[] = JHtml::_('select.option', RESERVATION_ACTIVE, JText::_('Reserved'));
				$options[] = JHtml::_('select.option', RESERVATION_STORNED, JText::_('Cancelled'));
				echo JHtml::_('select.genericlist', $options, 'filter_reservation_status', 'onchange="this.form.submit()"', 'value', 'text', $this->lists['reservation_status']);
				$options = array();
				$options[] = JHtml::_('select.option', '', '- ' . JText::_('Payment Status') . ' -');
				$options[] = JHtml::_('select.option', RESERVATION_PENDING, JText::_('Unpaid'));
				$options[] = JHtml::_('select.option', RESERVATION_RECEIVE_DEPOSIT, JText::_('Deposit Paid'));
				$options[] = JHtml::_('select.option', RESERVATION_RECEIVE, JText::_('Paid in full'));
				echo JHtml::_('select.genericlist', $options, 'filter_payment_status', 'onchange="this.form.submit()" class="inputbox"', 'value', 'text', $this->lists['payment_status']);
			?>
		</div>
		<div class="buttons">
			<input class="button btn btn-primary" type="submit" onclick="this.form.submit();" value="<?php echo $this->escape(JText::_('Go')); ?>" />
			<input class="button btn btn-primary" type="submit" onclick="this.form.reset.value=1; this.form.submit();" value="<?php echo $this->escape(JText::_('Reset')); ?>" />
		</div>
		<div class="clr"></div>
	</div>
	<table width="100%">
		<thead>
			<tr>
				<td nowrap="nowrap" class="sectiontableheader"><?php echo JText::_('Res. #'); ?></td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Item', 'items-subject_title', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Cap.', 'items-capacity', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td colspan="2" nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'From', 'from', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'To', 'to', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Price', 'reservationFullPrice', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'Deposit', 'reservationFullDeposit', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Payment Status', 'paid', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'Reservation Status', 'state', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
					<?php echo JText::_('Cancel'); ?>
				</td>
			</tr>
		</thead>
		<tbody>
			<?php if (! is_array($this->items) || ! count($this->items)) { ?>
				<tr><td colspan="9"><?php echo JText::_('No items found.'); ?></td></tr>
			<?php 
				} else {
					foreach ($this->items as $i => $reservation) {
						/* @var $item TableReservation */
						foreach ($this->reservedItems[$reservation->id] as $j => $reservedItem) {
			?>
				    <tr class="sectiontableentry<?php echo $i % 2 ? 1 : 2; ?>">
				    	<?php if ($j==0){ ?>
				    	<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="center">
				    		<a href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATION, null, null, array('cid' => $reservation->id))); ?>" title="<?php echo $this->escape(JText::_('Display reservation detail')); ?>"><?php echo $reservation->id; ?></a>
				    	</td>
				    	<?php } ?>
				    	<?php if (!$reservedItem) { ?>
				    		<td colspan="4">No subject reserved</td>
				    	<?php } else { ?>
				    	<td>
				    		<?php if (! is_null($reservedItem->subjectId)) { ?>
				    			<a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $reservedItem->subject, $reservedItem->subjectAlias)); ?>" title="<?php echo $this->escape(sprintf($this->escape(JText::_('Display object %s')), $reservedItem->subject_title)); ?>"><?php echo $reservedItem->subject_title; ?></a>
				    		<?php } else { ?>
				    			<span title="<?php echo $this->escape(JText::_('Subject not found')); ?>"><?php echo $reservedItem->subject_title; ?></span>
				    		<?php } ?>
				    	</td>
				    	<td align="center">
				    		<?php echo $reservedItem->capacity; ?>
				    	</td>
				    	<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
				    		<td colspan="2"><?php echo JText::_('Periodic Reservation'); ?></td>
				    	<?php } else { ?>
				    		<td>
				    			<?php echo AHtml::date($reservedItem->from, ADATE_FORMAT_NORMAL); ?>
				    			<br/><br/>
				    			<?php echo AHtml::date($reservedItem->to, ADATE_FORMAT_NORMAL); ?>
				    		</td>
				    		<td>
				    			<?php echo AHtml::date($reservedItem->from, ATIME_FORMAT_SHORT); ?>
				    			<br/><br/>
				    			<?php echo AHtml::date($reservedItem->to, ATIME_FORMAT_SHORT); ?>
				    		</td>
				    	<?php } ?>
				    	<?php } ?>
				    	<?php if ($j==0){ ?>
				    	<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
				    		<?php echo BookingHelper::displayPrice($reservation->reservationFullPrice); ?>
				    		<br/><br/>
				    		<span class="hasTip" title="<?php echo $this->escape(JText::_('Expiration'))?>::<?php echo $this->escape($this->depositExpires[$reservation->id]); ?>"><?php echo BookingHelper::displayPrice($reservation->reservationFullDeposit); ?></span>
				    	</td>
				    	<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="center">
				    		<?php echo AHtml::renderReservationPaymentStateIcon($reservation); ?>
					    	<br/><br/>
				    		<?php echo AHtml::renderReservationStateIcon($reservation); ?>
				    	</td>
				    	<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
				    		 <?php if (!$reservation->isExpired && $reservation->state == RESERVATION_ACTIVE) { ?> 
				    			<a title="<?php echo JText::_('Cancel Reservation'); ?>" class="aIcon aIconUnpublish" href="<?php echo JRoute::_('index.php?option=com_booking&controller=reservation&task=storno&cid[]=' . $reservation->id); ?>"/>
				    		<?php } ?>
				    	</td>
				    	<?php } ?>
				    </tr>
				    <?php } ?>
				<?php } ?>
			<?php } ?>
		</tbody>
	</table>
	<?php if ($this->customerHomepage) { ?>
		<a href="<?php echo $this->customerHomepage; ?>"><?php echo JText::_('Back'); ?></a>
	<?php } ?>
	<div class="reservations-legend">
			<span class="aIconLegend aIconTick"><?php echo $this->escape(JText::_('Reserved')); ?><span class="aIconSeparator">&nbsp;</span></span>
			<span class="aIconLegend aIconUnpublish"><?php echo $this->escape(JText::_('Cancelled')); ?><span class="aIconSeparator">&nbsp;</span></span>
			<span class="aIconLegend aIconExpired"><?php echo $this->escape(JText::_('Expired')); ?></span>
	</div>
	<div class="reservations-legend">
			<span class="aIconLegend aIconExpired"><?php echo $this->escape(JText::_('Unpaid')); ?><span class="aIconSeparator">&nbsp;</span></span>
			<span class="aIconLegend aIconPending"><?php echo $this->escape(JText::_('Deposit paid')); ?><span class="aIconSeparator">&nbsp;</span></span>
			<span class="aIconLegend aIconPublished"><?php echo $this->escape(JText::_('Paid in full')); ?><span>&nbsp;</span></span>
	</div>
    <?php if ($this->pagination->total > $this->pagination->minLimit) { ?>
   		<div class="pagination"><?php echo $this->pagination->getListFooter(); ?></div> 
    <?php } ?>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="reset" value="0"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>"/>
	<input type="hidden" name="<?php echo SESSION_TESTER; ?>" value="1"/>
	<?php echo JHTML::_( 'form.token' ); ?>
</form>	