<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

// this calendar does not work with date - set only empty values
$this->setting = new stdClass();
$this->setting->day = $this->setting->month = $this->setting->year = $this->setting->week = '';

$cfg = AFactory::getConfig();
/* @var $cfg BookingConfig */

JHtml::_('behavior.modal');

?>
<div class="clr"></div>
<div class="period">
	<h2><?php echo JText::_('Periodic Reservation'); ?></h2>
	<fieldset class="timeframe">
		<legend><?php echo JText::_('Timeframe'); ?></legend>
		<?php 
			$options = array(JHtml::_('select.option', '', JText::_('Select Timeframe')));
			
			foreach ($this->get('rtypes') as $rtype)
				if (!empty($rtype->prices))
					foreach ($rtype->prices as $i => $price)
						$options[] = JHtml::_('select.option', $i, $rtype->title . ' ' . JFactory::getDate($price->time_up)->toFormat('%H:%M') . ' - ' . JFactory::getDate($price->time_down)->toFormat('%H:%M') . ' ' . BookingHelper::displayPrice($price->value));
			
			echo JHtml::_('select.genericlist', $options, 'period_timeframe', 'autocomplete="off"');
		?>
		<input type="hidden" name="period_time_up" id="period_time_up" value="" />
		<input type="hidden" name="period_time_down" id="period_time_down" value="" />
		<input type="hidden" name="period_rtype_id" id="period_rtype_id" value="" />
		<input type="hidden" name="period_price_id" id="period_price_id" value="" />
	</fieldset>
	<fieldset class="recurrence-pattern">
		<legend><?php echo JText::_('Recurrence Pattern'); ?></legend>
		<div class="type">
			<input type="radio" name="period_type" id="period_type_daily" value="<?php echo PERIOD_TYPE_DAILY; ?>" autocomplete="off" />
			<label for="period_type_daily"><?php echo JText::_('Daily'); ?></label>
			<input type="radio" name="period_type" id="period_type_weekly" value="<?php echo PERIOD_TYPE_WEEKLY; ?>" autocomplete="off" />
			<label for="period_type_weekly"><?php echo JText::_('Weekly'); ?></label>
			<input type="radio" name="period_type" id="period_type_monthly" value="<?php echo PERIOD_TYPE_MONTHLY; ?>" autocomplete="off" />
			<label for="period_type_monthly"><?php echo JText::_('Monthly'); ?></label>
			<input type="radio" name="period_type" id="period_type_yearly" value="<?php echo PERIOD_TYPE_YEARLY; ?>" autocomplete="off" />
			<label for="period_type_yearly"><?php echo JText::_('Yearly'); ?></label>
		</div>
		<div class="intensity" id="daily_weekly" style="display: none">
			<div id="recurrence">
				<label for="period_recurrence"><?php echo JText::_('Recur Every'); ?></label>
				<input type="text" name="period_recurrence" id="period_recurrence" value="" size="1" autocomplete="off" />
				<label for="period_recurrence"><?php echo JText::_('weeks on'); ?></label>
			</div>
			<div class="clr"></div>
			<?php if ($cfg->firstDaySunday) { ?>
				<input type="checkbox" name="p" id="period_sunday_checkbox" disabled="disabled" />
				<input type="hidden" name="period_sunday" id="period_sunday_hidden" value="0" autocomplete="off" />
				<label for="period_sunday_checkbox"><?php echo JText::_('Sunday'); ?></label>
			<?php } ?>
			<input type="checkbox" name="p" id="period_monday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_monday" id="period_monday_hidden" value="0" autocomplete="off" />
			<label for="period_monday_checkbox"><?php echo JText::_('Monday'); ?></label>
			
			<input type="checkbox" name="p" id="period_tuesday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_tuesday" id="period_tuesday_hidden" value="0" autocomplete="off" />
			<label for="period_tuesday_checkbox"><?php echo JText::_('Tuesday'); ?></label>
			
			<input type="checkbox" name="p" id="period_wednesday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_wednesday" id="period_wednesday_hidden" value="0" autocomplete="off" />
			<label for="period_wednesday_checkbox"><?php echo JText::_('Wednesday'); ?></label>
			
			<input type="checkbox" name="p" id="period_thursday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_thursday" id="period_thursday_hidden" value="0" autocomplete="off" />
			<label for="period_thursday_checkbox"><?php echo JText::_('Thursday'); ?></label>
			
			<input type="checkbox" name="p" id="period_friday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_friday" id="period_friday_hidden" value="0" autocomplete="off" />
			<label for="period_friday_checkbox"><?php echo JText::_('Friday'); ?></label>
			
			<input type="checkbox" name="p" id="period_saturday_checkbox" disabled="disabled" />
			<input type="hidden" name="period_saturday" id="period_saturday_hidden" value="0" autocomplete="off" />
			<label for="period_saturday_checkbox"><?php echo JText::_('Saturday'); ?></label>
			
			<?php if (!$cfg->firstDaySunday) { ?>
				<input type="checkbox" name="p" id="period_sunday_checkbox" disabled="disabled" />
				<input type="hidden" name="period_sunday" id="period_sunday_hidden" value="0" autocomplete="off" />
				<label for="period_sunday_checkbox"><?php echo JText::_('Sunday'); ?></label>
			<?php } ?>
		</div>
		<div class="intensity" id="monthly_yearly" style="display: none">
			<?php 
				$options = array(JHtml::_('select.option', '', JText::_('Select Month')));
				
				$options[] = JHtml::_('select.option', 1,  JText::_('JANUARY'));
				$options[] = JHtml::_('select.option', 2,  JText::_('FEBRUARY'));
				$options[] = JHtml::_('select.option', 3,  JText::_('MARCH'));
				$options[] = JHtml::_('select.option', 4,  JText::_('APRIL'));
				$options[] = JHtml::_('select.option', 5,  JText::_('MAY'));
				$options[] = JHtml::_('select.option', 6,  JText::_('JUNE'));
				$options[] = JHtml::_('select.option', 7,  JText::_('JULY'));
				$options[] = JHtml::_('select.option', 8,  JText::_('AUGUST'));
				$options[] = JHtml::_('select.option', 9,  JText::_('SEPTEMBER'));
				$options[] = JHtml::_('select.option', 10, JText::_('OCTOBER'));
				$options[] = JHtml::_('select.option', 11, JText::_('NOVEMBER'));
				$options[] = JHtml::_('select.option', 12, JText::_('DECEMBER'));
				
				echo JHtml::_('select.genericlist', $options, 'period_month');
			
				$options = array(JHtml::_('select.option', '', JText::_('Select Week')));
				
				$options[] = JHtml::_('select.option', 1, JText::_('1st Week'));
				$options[] = JHtml::_('select.option', 2, JText::_('2nd Week'));
				$options[] = JHtml::_('select.option', 3, JText::_('3rd Week'));
				$options[] = JHtml::_('select.option', 4, JText::_('4th Week'));
				
				echo JHtml::_('select.genericlist', $options, 'period_week');
				
				$options = array(JHtml::_('select.option', '', JText::_('Select Day')));
				
				$options[] = JHtml::_('select.option', 1, JText::_('Monday'));
				$options[] = JHtml::_('select.option', 2, JText::_('Tuesday'));
				$options[] = JHtml::_('select.option', 3, JText::_('Wednesday'));
				$options[] = JHtml::_('select.option', 4, JText::_('Thursday'));
				$options[] = JHtml::_('select.option', 5, JText::_('Friday'));
				$options[] = JHtml::_('select.option', 6, JText::_('Saturday'));
				$options[] = JHtml::_('select.option', 7, JText::_('Sunday'));
				echo JHtml::_('select.genericlist', $options, 'period_day');
				
			?>
		</div>
	</fieldset>
	<fieldset class="recurrence-range">
		<legend><?php echo JText::_('Range of Recurrence'); ?></legend>
		<div class="begin">
			<label for="period_date_up"><?php echo JText::_('Start'); ?></label>
			<?php echo JHtml::calendar('', 'period_date_up', 'period_date_up', '%Y-%m-%d', 'autocomplete="off"'); ?>
		</div>
		<div class="end">
			<div class="no-end">
				<input type="radio" name="period_end" id="period_end_no" value="<?php echo PERIOD_END_TYPE_NO; ?>" autocomplete="off" />
				<label for="period_end_no"><?php echo JText::_('No End Date'); ?></label>
				<div class="clr"></div>
			</div>
			<div class="end-after">
				<input type="radio" name="period_end" id="period_occurrences" value="<?php echo PERIOD_END_TYPE_AFTER; ?>" autocomplete="off" />
				<label for="period_occurrences" id="period_occurrences_lbl"><?php echo JText::_('End After'); ?></label>
				<input type="text" name="period_occurrences" id="period_occurrences_occurrences" size="1" value="" disabled="disabled" autocomplete="off" />
				<label for="period_occurrences_occurrences"><?php echo JText::_('Occurrences'); ?></label>
				<div class="clr"></div> 
			</div>
			<div class="end-by">
				<input type="radio" name="period_end" id="period_date_down" value="<?php echo PERIOD_END_TYPE_DATE; ?>" autocomplete="off" />
				<label for="period_date_down" id="period_date_down_lbl" ><?php echo JText::_('End By'); ?></label>
				<?php echo JHtml::calendar('', 'period_date_down', 'period_date_down_date', '%Y-%m-%d', 'disabled="disabled" autocomplete="off"'); ?>
				<div class="clr"></div>
			</div>
		</div>
	</fieldset>
	<?php if (JFactory::getUser()->get('id') || AFactory::getConfig()->unRegisteregCanReserve || !AFactory::getConfig()->loginBeforeReserving) { ?>
		<div class="tools">
			<div class="bookit">
				<a class="checkButton bookitButton" id="bookIt" href="javascript:Calendars.bookIt()">
					<?php echo JText::_('Book it'); ?></a>
			</div>
		</div>
	<?php } ?>
</div>
<script type="text/javascript">
	//<![CDATA[
		window.addEvent('domready', function() {
			$('period_date_down_date_img').setStyle('display','none'); // hide end date - user selects end type
			<?php 
				$items = $rtypeIds = $priceTimeUps = $priceTimeDowns = $priceIds = array();
				$i = 1;
				foreach ($this->get('rtypes') as $rtype)
					if (!empty($rtype->prices))
						foreach ($rtype->prices as $price) {
							$item = array();
							// availability in week days for each timeframe
							$item[] = "0:[$price->monday]";	
							$item[] = "1:[$price->tuesday]";
							$item[] = "2:[$price->wednesday]";
							$item[] = "3:[$price->thursday]";
							$item[] = "4:[$price->friday]";
							$item[] = "5:[$price->saturday]";
							$item[] = "6:[$price->sunday]";
								
							$items[] = $i . ':{' . implode(', ', $item) . '}';
								
							$rtypeIds[] = "$i:[$price->rezervation_type]";
							$priceIds[] = "$i:[$price->id]";
							$priceTimeUps[] = "$i:['$price->time_up']";
							$priceTimeDowns[] = "$i:['$price->time_down']";
							
							$i++;
						}
				echo 'var weekdays = {' . implode(', ', $items) . '};' . "\n";
				echo 'var rtypeIds = {' . implode(', ', $rtypeIds) . '};' . "\n"; // list of reservation types ids for each timeframe							
				echo 'var priceIds = {' . implode(', ', $priceIds) . '};' . "\n"; // list of prices ids for each timeframe
				echo 'var priceTimeUps = {' . implode(', ', $priceTimeUps) . '};' . "\n"; // list of prices time ups for each timeframe
				echo 'var priceTimeDowns = {' . implode(', ', $priceTimeDowns) . '};' . "\n"; // list of prices time downs each timeframe
			?>
			$('period_timeframe').addEvent('change', function() { // on change timeframe
				if (this.selectedIndex != '') {
					$('period_rtype_id').value  = rtypeIds[this.selectedIndex]; // selected reservation type in form hidden field
					$('period_price_id').value  = priceIds[this.selectedIndex]; // selected price in form hidden field
					$('period_time_up').value   = priceTimeUps[this.selectedIndex]; // selected time up in form hidden field
					$('period_time_down').value = priceTimeDowns[this.selectedIndex]; // selected time down in form hidden field
				}
				if ($('period_type_daily').checked)
					$('period_type_daily').fireEvent('click');

				if ($('period_type_weekly').checked)
					$('period_type_weekly').fireEvent('click');

				if ($('period_type_monthly').checked)
					$('period_type_monthly').fireEvent('click');

				if ($('period_type_yearly').checked)
					$('period_type_yearly').fireEvent('click');
			});
			$('period_type_daily').addEvent('click', function() {
				$('daily_weekly').setStyle('display','');
				$('recurrence').setStyle('display','none');
				$('monthly_yearly').setStyle('display','none');
				
				$('period_monday_checkbox').disabled = $('period_tuesday_checkbox').disabled = $('period_wednesday_checkbox').disabled = $('period_thursday_checkbox').disabled = $('period_friday_checkbox').disabled = $('period_saturday_checkbox').disabled = $('period_sunday_checkbox').disabled = true;

				$('period_monday_checkbox').checked    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][0] == '1' : false;
				$('period_tuesday_checkbox').checked   = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][1] == '1' : false;
				$('period_wednesday_checkbox').checked = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][2] == '1' : false;
				$('period_thursday_checkbox').checked  = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][3] == '1' : false;
				$('period_friday_checkbox').checked    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][4] == '1' : false;
				$('period_saturday_checkbox').checked  = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][5] == '1' : false;
				$('period_sunday_checkbox').checked    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][6] == '1' : false;
				
				$('period_monday_hidden').value        = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][0] : 0;
				$('period_tuesday_hidden').value       = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][1] : 0;
				$('period_wednesday_hidden').value     = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][2] : 0;
				$('period_thursday_hidden').value      = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][3] : 0;
				$('period_friday_hidden').value        = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][4] : 0;
				$('period_saturday_hidden').value      = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][5] : 0;
				$('period_sunday_hidden').value        = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][6] : 0;

				$('period_recurrence').value = '1';
				$('period_month').value = $('period_week').value = $('period_day').value = '';
			});
			$('period_type_weekly').addEvent('click', function() {
				
				$('daily_weekly').setStyle('display','');
				$('recurrence').setStyle('display','');
				$('monthly_yearly').setStyle('display','none');
				
				$('period_monday_checkbox').disabled    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][0] == '0' : true;
				$('period_tuesday_checkbox').disabled   = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][1] == '0' : true;
				$('period_wednesday_checkbox').disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][2] == '0' : true;
				$('period_thursday_checkbox').disabled  = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][3] == '0' : true;
				$('period_friday_checkbox').disabled    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][4] == '0' : true;
				$('period_saturday_checkbox').disabled  = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][5] == '0' : true;
				$('period_sunday_checkbox').disabled    = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][6] == '0' : true;

				$('period_monday_checkbox').checked = $('period_tuesday_checkbox').checked = $('period_wednesday_checkbox').checked = $('period_thursday_checkbox').checked = $('period_friday_checkbox').checked = $('period_saturday_checkbox').checked = $('period_sunday_checkbox').checked = false;

				$('period_monday_hidden').value = $('period_tuesday_hidden').value = $('period_wednesday_hidden').value = $('period_thursday_hidden').value = $('period_friday_hidden').value = $('period_saturday_hidden').value = $('period_sunday_hidden').value = 0;

				$('period_recurrence').value = $('period_month').value = $('period_week').value = $('period_day').value = '';
				
			});
			$('period_type_monthly').addEvent('click', function() {
				$('daily_weekly').setStyle('display','none');
				$('monthly_yearly').setStyle('display','');
				$('period_month').setStyle('display','none');

				$('period_monday_checkbox').checked = $('period_tuesday_checkbox').checked = $('period_wednesday_checkbox').checked = $('period_thursday_checkbox').checked =$('period_friday_checkbox').checked = $('period_saturday_checkbox').checked = $('period_sunday_checkbox').checked = false;

				$('period_monday_hidden').value = $('period_tuesday_hidden').value = $('period_wednesday_hidden').value = $('period_thursday_hidden').value = $('period_friday_hidden').value = $('period_saturday_hidden').value = $('period_sunday_hidden').value = 0;

				$('period_recurrence').value = $('period_month').value = '';

				$('period_day').options[1].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][0] == '0' : false;
				$('period_day').options[2].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][1] == '0' : false;
				$('period_day').options[3].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][2] == '0' : false;
				$('period_day').options[4].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][3] == '0' : false;
				$('period_day').options[5].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][4] == '0' : false;
				$('period_day').options[6].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][5] == '0' : false;
				$('period_day').options[7].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][6] == '0' : false;
			});
			$('period_type_yearly').addEvent('click', function() {
				$('daily_weekly').setStyle('display','none');
				$('monthly_yearly').setStyle('display','');
				$('period_month').setStyle('display','');

				$('period_monday_checkbox').checked = $('period_tuesday_checkbox').checked = $('period_wednesday_checkbox').checked = $('period_thursday_checkbox').checked =$('period_friday_checkbox').checked = $('period_saturday_checkbox').checked = $('period_sunday_checkbox').checked = false;

				$('period_monday_hidden').value = $('period_tuesday_hidden').value = $('period_wednesday_hidden').value = $('period_thursday_hidden').value = $('period_friday_hidden').value = $('period_saturday_hidden').value = $('period_sunday_hidden').value = 0;

				$('period_recurrence').value = '';

				$('period_day').options[1].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][0] == '0' : false;
				$('period_day').options[2].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][1] == '0' : false;
				$('period_day').options[3].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][2] == '0' : false;
				$('period_day').options[4].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][3] == '0' : false;
				$('period_day').options[5].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][4] == '0' : false;
				$('period_day').options[6].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][5] == '0' : false;
				$('period_day').options[7].disabled = $('period_timeframe').selectedIndex ? weekdays[$('period_timeframe').selectedIndex][6] == '0' : false;
			});
			$('period_end_no').addEvent('click', function() {
				$('period_occurrences_occurrences').disabled = true;
				$('period_date_down_date_img').setStyle('display','none');
				$('period_occurrences_occurrences').value = '';
				$('period_date_down_date').value = '';
			});
			$('period_occurrences').addEvent('click', function() {
				$('period_occurrences_occurrences').disabled = false;
				$('period_date_down_date_img').setStyle('display','none');
				$('period_date_down_date').value = '';
			});
			$('period_date_down').addEvent('click', function() {
				$('period_occurrences_occurrences').disabled = true;
				$('period_date_down_date').disabled = false;
				$('period_date_down_date_img').setStyle('display','');
				$('period_occurrences_occurrences').value = '';
			});
			$('period_monday_checkbox').addEvent('click', function() {
				$('period_monday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_tuesday_checkbox').addEvent('click', function() {
				$('period_tuesday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_wednesday_checkbox').addEvent('click', function() {
				$('period_wednesday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_thursday_checkbox').addEvent('click', function() {
				$('period_thursday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_friday_checkbox').addEvent('click', function() {
				$('period_friday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_saturday_checkbox').addEvent('click', function() {
				$('period_saturday_hidden').value = this.checked ? 1 : 0;
			});
			$('period_sunday_checkbox').addEvent('click', function() {
				$('period_sunday_hidden').value = this.checked ? 1 : 0;
			});
			$('bookIt').addEvent('click', function() {
				if ($('period_timeframe').value == '') {
					alert("<?php echo JText::_('You must select timeframe', true); ?>");
					return false;
				}
				if (!($('period_type_daily').checked || $('period_type_weekly').checked || $('period_type_monthly').checked || $('period_type_yearly').checked)) {
					alert("<?php echo JText::_('You must select recurrence type', true); ?>");
					return false;
				}				
				if ($('period_type_weekly').checked && !$('period_recurrence').value.match(/^[1-9]+[0-9]*$/)){
					alert("<?php echo JText::_('Recur every weeks must be an integer', true); ?>");
					return false;
				}
				if ($('period_type_weekly').checked && !($('period_sunday_checkbox').checked || $('period_monday_checkbox').checked || $('period_tuesday_checkbox').checked || $('period_wednesday_checkbox').checked || $('period_thursday_checkbox').checked || $('period_friday_checkbox').checked || $('period_saturday_checkbox').checked)) {
					alert("<?php echo JText::_('You must select at least one week day', true); ?>");
					return false;
				}
				if ($('period_type_yearly').checked && $('period_month').value == '') {
					alert("<?php echo JText::_('You must select a month', true); ?>");
					return false;
				}
				if (($('period_type_monthly').checked || $('period_type_yearly').checked) && $('period_week').value == '') {
					alert("<?php echo JText::_('You must select a week', true); ?>");
					return false;
				}
				if (($('period_type_monthly').checked || $('period_type_yearly').checked) && $('period_day').value == '') {
					alert("<?php echo JText::_('You must select a day', true); ?>");
					return false;
				}        
				if ($('period_date_up').value == '') {
					alert("<?php echo JText::_('You must select start day', true); ?>");
					return false;
				}
				if (!($('period_end_no').checked || $('period_occurrences').checked || $('period_date_down').checked)) {
					alert("<?php echo JText::_('You must select end type', true); ?>");
					return false;
				}
				if ($('period_occurrences').checked && !$('period_occurrences_occurrences').value.match(/^[1-9]+[0-9]*$/)) {
					alert("<?php echo JText::_('End after occurrences must be an integer', true); ?>");
					return false;
				}
				if ($('period_date_down').checked && $('period_date_down_date').value == '') {
					alert("<?php echo JText::_('You must select end date', true); ?>");
					return false;
				}  
				if ($('period_date_up').value > $('period_date_down').value) {
					alert("<?php echo JText::_('Date range is invalid', true); ?>");
					return false;
				}
				
				document.bookSetting.controller.value = 'reservation';
				document.bookSetting.task.value = 'addPeriod';
				return true;
			});
		});
	//]]>
</script>