<?php

/**
* @version		$Id$
* @package		ARTIO Booking
* @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
* @author		ARTIO s.r.o., http://www.artio.net
* @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
* @link			http://www.artio.net Official website
*/

defined('_JEXEC') or die('Restricted access');

require_once(dirname(__FILE__).DS.'reinstall.php');

/* @var $this BookingModelUpgrade */

/* Create tax rates lov from subjects taxes */

$db = JFactory::getDbo();

$db->setQuery('SELECT COUNT(*) FROM #__booking_subject'); // get subjects count for batch process
$count = $db->loadResult();

$taxes = array();
for ($i = 0; $i < $count; $i += 100) { // load taxes from exists subjects in batch process
	$db->setQuery('SELECT params FROM #__booking_subject', $i, 100);
	foreach ($db->loadResultArray() as $params) {
		$params = new JParameter($params);
		if ($params->getValue('tax') !== null)
			$taxes[] = $params->getValue('tax');
	}
}

$taxes = array_unique($taxes);
sort($taxes, SORT_NUMERIC);
$taxrates = array();
$map = array();

foreach ($taxes as $id => $value) { // create taxes lov
	$taxrates[$id] = array($value, $value); // use tax value as tax rate title
	$map[$value] = $id; // save tax id and value for subjects updating
}

$taxrates = $db->quote(serialize($taxrates)); // convert to database string
$db->setQuery("INSERT INTO #__booking_config (`key`, value) VALUES ('taxrates', $taxrates) ON DUPLICATE KEY UPDATE value = $taxrates"); // save taxes lov into configuration
$db->query();

for ($i = 0; $i < $count; $i += 100) { // update exists subjects in batch process
	$db->setQuery('SELECT id, params FROM #__booking_subject', $i, 100);
	foreach ($db->loadObjectList() as $subject) {
		$params = new JParameter($subject->params);
		if ($params->getValue('tax') !== null) {
			$params->setValue('tax_rate_id', $map[$params->getValue('tax')]); // get id from tax rates lov acording to subject tax
			$subject->params = $db->quote($params->toString()); // back to database format
			$db->setQuery("UPDATE #__booking_subject SET params = $subject->params WHERE id = $subject->id");
			$db->query();
		}
	}
}