<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class ARTIOFusionChartsController extends JController
{

    /**
     * Display page by task type.
     */
    function display()
    {
        if (($task = $this->getTask()))
            switch ($task) {
                case 'add':
                    if (ARTIOFUSIONCHARTS_CREATE) {
                        $this->editing('artiofusionchart', false);
                        break;
                    }
                case 'edit':
                    if (ARTIOFUSIONCHARTS_EDIT) {
                        $this->editing('artiofusionchart', true);
                        break;
                    }
                case 'addDatabase':
                    if (ARTIOFUSIONCHARTS_CREATE) {
                        JRequest::setVar('cid', array(0));
                        $this->editing('database', false);
                        break;
                    }
                case 'editDatabase':
                    if (ARTIOFUSIONCHARTS_EDIT) {
                        $this->editing('database', true);
                        break;
                    }
                case 'create':
                    if (ARTIOFUSIONCHARTS_CREATE) {
                        JRequest::setVar('view', 'create');
                        break;
                    }
                default:
                    ARTIOFusionChartsHelper::noauth();
            }
        parent::display();
    }

    function editing($entity, $edit)
    {
        JRequest::setVar('hidemainmenu', 1);
        JRequest::setVar('layout', 'form');
        JRequest::setVar('view', $entity);
        $id = reset(JRequest::getVar('cid', array(0), 'default', 'array'));
        $model = &$this->getModel($entity);
        if ($edit) {
            if ($model->isCheckedOut($id)) {
                $this->homePage(JText::_('Item is already checked'), 'notice');
            } else {
                $model->checkout($id);
            }
        }
    }

    /**
     * Cancel chart editing out of saving changes.
     */
    function cancel()
    {
        $this->checkin();
        $this->homePage();
    }

    /**
     * Go to componet home page.
     *
     * @param string $msg
     */
    function homePage($msg = '', $type = 'message')
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $link = 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION;
        $mainframe->redirect($link, $msg, $type);
    }

    /**
     * Apply chart editing changes and stay on editing page. 
     */
    function apply()
    {
        $this->save(true);
    }

    /**
     * Save editing changes.
     *
     * @param boolean $apply true: stay on editing page, false: go to home page and check out chart
     */
    function save($apply = false)
    {
        JRequest::checkToken() or jexit('Invalid Token');
        $post = JRequest::get('post');
        $cid = JRequest::getVar('cid', array(0), 'post', 'array');
        $post['id'] = (int) reset($cid);
        
        ARTIOFusionChartsHelper::canEdit($post['id']);
        
        $model = &$this->getModel('artiofusionchart');
        /* @var $model ARTIOFusionChartsModelARTIOFusionChart */
        if (($id = $model->store($post)) != 0) {
            $msg = JText::_('Chart Saved');
        } else {
            $msg = JText::_('Error Saving Chart');
        }
        if (! $apply) {
            $this->checkin();
            $this->homePage($msg);
        } else {
            $link = ARTIOFusionChartsHelperRoute::getEditRoute($id);
            $mainframe = &JFactory::getApplication();
            /* @var $mainframe JApplication */
            $mainframe->redirect($link, $msg);
        }
    }

    /**
     * Remove chart from db.
     */
    function remove()
    {
        if (! ARTIOFUSIONCHARTS_DELETE)
            ARTIOFusionChartsHelper::noauth();
        
        $cid = JRequest::getVar('cid', array(), 'default', 'array');
        $model = &$this->getModel('artiofusionchart');
        /* @var $model ARTIOFusionChartsModelARTIOFusionChart */
        $model->remove($cid);
        $this->homePage();
    }

    /**
     * Checkin chart on ending editing.
     */
    function checkin()
    {
        $model = &$this->getModel('artiofusionchart');
        /* @var $model ARTIOFusionChartsModelARTIOFusionChart */
        $model->checkin();
    }

    /**
     * Try run given SQL query and create output for ajax calling.
     */
    function trySqlQuery()
    {
        $output = ARTIOFusionChartsHelper::trySqlQuery(ARTIOFusionChartsHelper::decodeParam(stripslashes($_REQUEST['sqlQuery'])), JRequest::getString('database'));
        ob_clean();
        die($output);
    }

    /**
     * Import chart data from given source file.
     */
    function importSource()
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        if (isset($_FILES['source'])) {
            $sourceType = JRequest::getInt('sourceType');
            if (! $sourceType) {
                $mainframe->enqueueMessage('Select source type', 'notice');
            } else {
                $importSource = ARTIOFusionChartsHelper::importSource($_FILES['source']['tmp_name'], $sourceType);
                JRequest::setVar('importSource', $importSource);
            }
        } else {
            $mainframe->enqueueMessage('Select source file', 'notice');
        }
        parent::display();
    }

    /**
     * Save database setting data from request into database 
     * and redirect on edit page.
     * 
     * @return void
     */
    function applyDatabase()
    {
        $this->saveDatabase(true);
    }

    /**
     * Save database setting data from request into database.
     * 
     * @param boolean $apply true: redirect on edit page, false: redirect on list databases page
     * @return void
     */
    function saveDatabase($apply = false)
    {
        JRequest::checkToken() or jexit('Invalid Token');
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $post = JRequest::get('post');
        $post['id'] = reset(JRequest::getVar('cid', array(0), 'post', 'array'));
        
        ARTIOFusionChartsHelper::canEdit($post['id']);
        
        $model = &$this->getModel('database');
        /* @var $model ARTIOFusionChartsModelDatabase */
        $id = $model->store($post);
        $msg = JText::_($id ? 'Database saved' : 'Error during saving database');
        $type = $id ? 'message' : 'error';
        $link = $apply ? ARTIOFusionChartsHelperRoute::getEditDatabaseRoute($id) : ARTIOFusionChartsHelperRoute::getListDatabasesRoute();
        $mainframe->redirect($link, $msg, $type);
    }

    /**
     * Cancel editing database. Unlock database row and redirect on list databases page.
     * 
     * @return void
     */
    function cancelDatabase()
    {
        JRequest::checkToken() or jexit('Invalid Token');
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $id = reset(JRequest::getVar('cid', array(0), 'default', 'array'));
        $model = &$this->getModel('database');
        /* @var  $model ARTIOFusionChartsModelDatabase */
        $model->checkin($id);
        $mainframe->redirect(ARTIOFusionChartsHelperRoute::getListDatabasesRoute(), JText::_('Database editing canceled'), 'message');
    }

    /**
     * Remove selected databases settings from database.
     * 
     * @return void
     */
    function removeDatabase()
    {
        JRequest::checkToken() or jexit('Invalid Token');
        
        if (! ARTIOFUSIONCHARTS_DELETE)
            ARTIOFusionChartsHelper::noauth();
        
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        $cid = JRequest::getVar('cid', array(), 'default', 'array');
        $model = &$this->getModel('database');
        /* @var  $model ARTIOFusionChartsModelDatabase */
        $count = $model->remove($cid);
        
        $mainframe->redirect(ARTIOFusionChartsHelperRoute::getListDatabasesRoute(), JText::sprintf('%s databases removed', $count), 'message');
    }

    /**
     * Copy selected charts.
     * 
     * @return void
     */
    function copy()
    {
        JRequest::checkToken() or jexit('Invalid Token');
        
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        $cid = JRequest::getVar('cid', array(), 'default', 'array');
        $count = (int) $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'copy', 'copy', 0, 'int');
        $model = &$this->getModel('artiofusionchart');
        /* @var $model ARTIOFusionChartsModelARTIOFusionChart */
        
        $total = $model->copy($cid, $count);
        
        if (JRequest::getString('view') == 'artiofusionchart') {
            if ($total)
                $mainframe->redirect(ARTIOFusionChartsHelperRoute::getEditRoute(reset($cid)), JText::_('Chart copied'), 'message');
            else
                $mainframe->redirect(ARTIOFusionChartsHelperRoute::getEditRoute(reset($cid)), JText::_('Unable copy chart'), 'error');
        } else
            $mainframe->redirect(ARTIOFusionChartsHelperRoute::getListChartsRoute(), JText::sprintf('%s copies created', $total), 'message');
    }
}

?>