<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class plgContentARTIOFusionCharts extends JPlugin
{

    /**
     * Create object.
     * 
     * @param JDispatcher $subject plugins events dispatcher 
     * @param array $config plugin settings
     * @return void
     */
    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }

    /**
     * Run plugin on event onPrepareContent. Insert chart if in article is sign like {fusionchart id="1" chartTitle}.
     * 
     * @param stdClass $row current displayed article
     * @param JParameter $params article setting
     * @param int $page
     * @return boolean
     */
    function onPrepareContent(&$row, &$params, $page = 0)
    {
    	$matches = array();
    	
        if (preg_match_all('#\{fusionchart id\="([^"]*)"([^\}]*)\}#iU', $row->text, $matches, PREG_SET_ORDER)) {
        	
            if (! class_exists('JParameter'))
                jimport('joomla.html.parameter');
            
            $files[] = realpath(($component = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_artiofusioncharts' . DS) . 'helpers' . DS . 'helper.php');
            $files[] = realpath($component . 'config.php');
            $files[] = realpath($component . 'helpers' . DS . 'route.php');
            $files[] = realpath($component . 'models' . DS . 'artiofusionchart.php');
            $files[] = realpath($component . 'models' . DS . 'database.php');
            $files[] = realpath($component . 'tables' . DS . 'artiofusionchart.php');
            $files[] = realpath($component . 'tables' . DS . 'database.php');
            
            foreach ($files as $file) {
                if (file_exists($file))
                    include_once ($file);
                else {
                    $msg = JText::_('Unable display chart. Component ARTIOFusionCharts isn\'t installed or is installed incorectly');
                    foreach ($matches as $match)
                        $row->text = str_replace($match[0], $msg, $row->text);
                    return false;
                }
            }
            
            JHTML::_('behavior.caption');
            JHTML::script('FusionCharts.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
            
            foreach ($matches as $match) {
                $html = ($chart = &ARTIOFusionChartsHelper::getChart(($id = (int) $match[1]))) ? ARTIOFusionChartsHelper::displayChart($chart, 'content') : JText::sprintf('Chart with ID %s not found', $id);
                $row->text = JString::substr($row->text, 0, ($position = JString::strpos($row->text, ($text = $match[0]), 0))) . $html . JString::substr($row->text, $position + ($length = JString::strlen($text)), ($textLength = JString::strlen($row->text)) - $position - $length);
            }
        }
        return true;
    }

    /**
     * Run plugin on event onContentPrepare. This is same function as onPrepareContent used in Joomla! 1.6.x.
     * 
     * @param stdClass $row current displayed article
     * @param JParameter $params article setting
     * @param int $page
     * @return boolean
     */
    function onContentPrepare($context, &$row, &$params, $page = 0)
    {
        return $this->onPrepareContent($row, $params, $page);
    }
}

?>