<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class ARTIOFusionChartsModelDatabase extends JModel
{
    /**
     * @var JDatabaseMySQL 
     */
    var $_db;

    /**
     * Load database.
     * 
     * @param int $id
     * @return TableDatabase
     */
    function getData($id, $getEmptyTable = false)
    {
        $database = &$this->getTable();
        /* @var $database TableDatabase */
        if (! $database->load($id) && ! $getEmptyTable)
            return false;
        return $database;
    }

    /**
     * Check in database after editing.
     *
     * @param int $id
     * @return boolean
     */
    function checkin($id)
    {
        $database = &$this->getTable();
        /* @var $database TableDatabase */
        $database->checkin($id);
    }

    /**
     * Check out database before editing.
     *
     * @param int $id
     * @return boolean
     */
    function checkout($id)
    {
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $database = &$this->getTable();
        /* @var $database TableDatabase */
        return $database->checkout($user->id, $id);
    }

    /**
     * Get information row is checked by other user then logged.
     *
     * @param int $id
     * @return boolean
     */
    function isCheckedOut($id)
    {
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $database = &$this->getTable();
        /* @var $database TableDatabase */
        $database->load($id);
        return $database->isCheckedOut($user->id);
    }

    /**
     * Save database setting into database.
     * 
     * @param array $data data to bind
     * @return int|false false: error during saving, int: successfuly saved
     */
    function store(&$data)
    {
        $database = &$this->getTable();
        /* @var $database TableDatabase */
        $database->bind($data);
        $success = $database->store();
        $db = &JFactory::getDBO();
        /* @var $db JDatabaseMySQL */
        $success = $success ? $database->id : false;
        return $success;
    }

    /**
     * Remove selected databases setting from database.
     * 
     * @param array $cid
     * @return int count of deleted databases 
     */
    function remove($cid)
    {
        JArrayHelper::toInteger($cid);
        $count = 0;
        if (count($cid)) {
            $this->_db->setQuery('DELETE FROM `#__artiofusioncharts_database` WHERE `id` IN (' . implode(',', $cid) . ')');
            $this->_db->query();
            $count = $this->_db->getAffectedRows();
        }
        return $count;
    }
}

?>