<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class TableDatabase extends JTable
{
    /**
     * Unique system id
     *
     * @access var
     * @var int
     */
    var $id;
    /**
     * Database name
     * 
     * @access var 
     * @var string
     */
    var $title;
    /**
     * Connection host dns name ip adrress
     * 
     * @access var 
     * @var string
     */
    var $host;
    /**
     * Connection user name
     * 
     * @access var
     * @var string
     */
    var $user;
    /**
     * Connection password
     * 
     * @var string
     */
    var $password;
    /**
     * Database name
     * 
     * @access var
     * @var string
     */
    var $database;
    /**
     * Database type
     * 
     * @var string
     */
    var $type;
    /**
     * Database prefix
     * 
     * @var string
     */
    var $prefix;
    /**
     * Id of user who just editing database
     *
     * @access var
     * @var int
     */
    var $checked_out;
    /**
     * Time of database locked by editing - mysql datetime, like YYYY-MM-DD HH:MM:SS
     *
     * @access var 
     * @var string
     */
    var $checked_out_time;

    /**
     * Create object and set database connector.
     * 
     * @param JDatabaseMySQL $db
     * @return void
     */
    function __construct(&$db)
    {
        parent::__construct('#__artiofusioncharts_database', 'id', $db);
    }
}

?>