<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewARTIOFusionChart */

?>
<fieldset class="adminform">
	<legend><?php echo JText::_('SQL Query'); ?></legend>
	<div class="sqlQueryToolbar">
		<input type="radio" name="useSqlQuery" id="useSqlQuery1" value="<?php echo ARTIOFUSIONCHARTS_USE_SQL_QUERY_NO; ?>" <?php if ($this->chart->useSqlQuery == ARTIOFUSIONCHARTS_USE_SQL_QUERY_NO) { ?>checked="checked"<?php } ?> onclick="ARTIOFusionCharts.setUseSqlQuery()" /><label for="useSqlQuery1"><?php echo JText::_('No use'); ?></label>
		<input type="radio" name="useSqlQuery" id="useSqlQuery2" value="<?php echo ARTIOFUSIONCHARTS_USE_SQL_QUERY_ONE_TIME; ?>" <?php if ($this->chart->useSqlQuery == ARTIOFUSIONCHARTS_USE_SQL_QUERY_ONE_TIME) { ?>checked="checked"<?php } ?> onclick="ARTIOFusionCharts.setUseSqlQuery()" /><label for="useSqlQuery2"><?php echo JText::_('Use one-time'); ?></label>
		<input type="radio" name="useSqlQuery" id="useSqlQuery3" value="<?php echo ARTIOFUSIONCHARTS_USE_SQL_QUERY_REAL_TIME; ?>" <?php if ($this->chart->useSqlQuery == ARTIOFUSIONCHARTS_USE_SQL_QUERY_REAL_TIME) { ?>checked="checked"<?php } ?> onclick="ARTIOFusionCharts.setUseSqlQuery()" /><label for="useSqlQuery3"><?php echo JText::_('Use real time'); ?></label>
		<?php echo $this->lists['databases']; ?>
		<a class="info" href="<?php echo JURI::root(); ?>components/com_artiofusioncharts/documentation/useSql.php" title="" target="_blank" ><?php echo JText::_('Help'); ?></a>
		<div class="clr"></div>
	</div>
	<div id="sqlQueryBox" <?php if ($this->chart->useSqlQuery == ARTIOFUSIONCHARTS_USE_SQL_QUERY_NO) { ?>style="display: none"<?php } ?>>
		<textarea name="sqlQuery" id="sqlQuery" rows="10" cols="50" style="width: 100%"><?php echo $this->escape($this->chart->sqlQuery); ?></textarea>
		<button onclick="return ARTIOFusionCharts.trySqlQuery()" style="float: none"><?php echo JText::_('Try'); ?></button>
		<input type="radio" name="sqlQueryReplace" id="sqlQueryReplace1" value="1" checked="checked" />
		<label for="sqlQueryReplace1"><?php echo JText::_('Replace current data by new'); ?></label>
		<input type="radio" name="sqlQueryReplace" id="sqlQueryReplace2" value="2" />
		<label for="sqlQueryReplace2"><?php echo JText::_('Concat current data by new'); ?></label>
		<p><?php echo JText::_('SQL query info'); ?></p>
		<div id="sqlQueryOutput"></div>
	</div>
	<dl class="system-message" id="sglQueryOutput" style="display: none">
		<dd class="message message fade" id="sglQueryMessage" style="display: none">
			<ul>
				<li id="sglQueryMessageText"></li>
			</ul>
		</dd>
		<dd class="notice message fade" id="sglQueryNotice" style="display: none">
			<ul>
				<li id="sglQueryNoticeText"></li>
			</ul>
		</dd>
		<dd class="error message fade" id="sglQueryError" style="display: none">
			<ul>
				<li id="sglQueryErrorText"></li>
			</ul>
		</dd>
	</dl>
</fieldset>