<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewDatabase */

JToolBarHelper::title(JText::_('Database'), 'db');
if (ARTIOFUSIONCHARTS_EDIT || ARTIOFUSIONCHARTS_CREATE)
	JToolBarHelper::save('saveDatabase');
if (ARTIOFUSIONCHARTS_EDIT)
	JToolBarHelper::apply('applyDatabase');
JToolBarHelper::cancel('cancelDatabase', 'Close');
if (ARTIOFUSIONCHARTS_CREATE)
	JToolBarHelper::addNewX('addDatabase');

if ($this->database->id && ARTIOFUSIONCHARTS_DELETE)
    JToolBarHelper::deleteListX(JText::_('Are you sure to delete this database?'), 'removeDatabase');

JFilterOutput::objectHTMLSafe($this->database);

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table class="admintable">
		<tr>
			<td class="key"><label for="title"><?php echo JText::_('JGLOBAL_TITLE'); ?></label></td>
			<td><input type="text" name="title" id="title" value="<?php echo $this->database->title; ?>" size="60" /></td>
		</tr>
		<tr>
			<td class="key"><label for="host"><?php echo JText::_('Host'); ?></label></td>
			<td><input type="text" name="host" id="host" value="<?php echo $this->database->host; ?>" size="60" /></td>
			<td><?php echo JText::_('Domain name or IP adrress. Usually localhost.'); ?></td>
		</tr>
		<tr>
			<td class="key"><label for="database"><?php echo JText::_('Database'); ?></label></td>
			<td><input type="text" name="database" id="database" value="<?php echo $this->database->database; ?>" size="60" /></td>
			<td><?php echo JText::_('Database name.'); ?></td>
		</tr>
		<tr>
			<td class="key"><label for="type"><?php echo JText::_('Type'); ?></label></td>
			<td><input type="text" name="type" id="type" value="<?php echo $this->database->type; ?>" size="60" /></td>
			<td><?php echo JText::_('Database adapter. MySQL, MySQLi or MSSQL.'); ?></td>
		</tr>
		<tr>
			<td class="key"><label for="prefix"><?php echo JText::_('Prefix'); ?></label></td>
			<td><input type="text" name="prefix" id="prefix" value="<?php echo $this->database->prefix; ?>" size="60" /></td>
			<td><?php echo JText::_('Database tables prefix. Usually jos_.'); ?></td>
		</tr>
		<tr>
			<td class="key"><label for="user"><?php echo JText::_('JGLOBAL_USERNAME'); ?></label></td>
			<td><input type="text" name="user" id="user" value="<?php echo $this->database->user; ?>" size="60" autocomplete="off" /></td>
			<td><?php echo JText::_('Database account user name.'); ?></td>
		</tr>
		<tr>
			<td class="key"><label for="password"><?php echo JText::_('Password'); ?></label></td>
			<td><input type="password" name="password" id="password" value="<?php echo $this->database->password; ?>" size="60" /></td>
			<td><?php echo JText::_('Database account user password.'); ?></td>
		</tr>
	</table>
	<input type="hidden" name="option" value="<?php echo ARTIOFUSIONCHARTS_OPTION; ?>" /> 
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="cid[]" value="<?php echo $this->database->id; ?>" />
	<input type="hidden" name="boxchecked" value="1" />
	<?php echo JHTML::_('form.token'); ?>
</form>