<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewDatabases */
	
JHTML::_('behavior.tooltip');

JToolBarHelper::title( JText::_('Databases Manager'), 'dbs');
if (ARTIOFUSIONCHARTS_DELETE)
	JToolBarHelper::deleteListX(JText::_('Are you sure to delete selected databases?'), 'removeDatabase');
if (ARTIOFUSIONCHARTS_EDIT)	
	JToolBarHelper::editListX('editDatabase');
if (ARTIOFUSIONCHARTS_CREATE)	    
	JToolBarHelper::addNewX('addDatabase');
if (ARTIOFUSIONCHARTS_ADMIN)	
	JToolBarHelper::preferences(ARTIOFUSIONCHARTS_OPTION, 600);
	
$editDatabase = JText::_('Edit database');

$user = &JFactory::getUser();
/* @var $user JUser */

?>
<form action="index.php" method="post" name="adminForm">
	<table>
		<tr>
			<td align="left" width="100%">
				<?php echo JText::_('JSEARCH_FILTER_LABEL'); ?>
				<input type="text" name="search" id="search" value="<?php echo $this->escape($this->filter->search); ?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</td>
		</tr>
	</table>
	<div id="editcell">
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="3%">
						<?php echo JText::_('JGRID_HEADING_ROW_NUMBER'); ?>
					</th>
					<?php if (($check = ARTIOFUSIONCHARTS_EDIT || ARTIOFUSIONCHARTS_DELETE)) { ?>
						<th width="2%">
							<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
						</th>
					<?php } ?>
					<th>
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_TITLE', 'title', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'Host', 'host', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'Database', 'database', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'Type', 'type', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'Prefix', 'prefix', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_USERNAME', 'user', $this->filter->orderDir, $this->filter->order); ?>
					</th>
					<th width="5%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'ID', 'id', $this->filter->orderDir, $this->filter->order); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="<?php echo ($check ? 9 : 8); ?>" align="center">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
				<?php 
					foreach ($this->items as $i => $item) {
						/* @var $item TableDatabase */ 
				?>
						<tr class="row<?php echo ($i % 2); ?>">
							<td><?php echo $this->pagination->getRowOffset($i); ?></td>
							<?php if ($check) { ?>
								<td><?php echo JHTML::_('grid.checkedout', $item, $i); ?></td>
							<?php } ?>
							<td>
								<?php
									if (JTable::isCheckedOut($user->id, $item->checked_out) || ! ARTIOFUSIONCHARTS_EDIT) {
										echo $item->title;
									} else {
								?>
										<span class="editlinktip hasTip" title="<?php echo $this->escape($editDatabase . '::' . $item->title); ?>">
											<a href="<?php echo JRoute::_(ARTIOFusionChartsHelperRoute::getEditDatabaseRoute($item->id)); ?>" title=""><?php echo $item->title; ?></a>
										</span>
								<?php 
									} 
								?>
							</td>
							<td align="center"><?php echo $item->host; ?></td>
							<td align="center"><?php echo $item->database; ?></td>
							<td align="center"><?php echo $item->type; ?></td>
							<td align="center"><?php echo $item->prefix; ?></td>
							<td align="center"><?php echo $item->user; ?></td>
							<td align="center"><?php echo $item->id; ?></td>
						</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<input type="hidden" name="option" value="<?php echo ARTIOFUSIONCHARTS_OPTION; ?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="view" value="databases" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $this->filter->order; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->filter->orderDir; ?>" />
	<?php echo JHTML::_('form.token'); ?>
</form>