/**
 * Componet for creating Fusion Charts XML source in graphic mode. Can create,
 * modified and deleting assorted Fusion Charts. Charts can display on frontend
 * page by module or content plugin.
 * 
 * @version $Id$
 * @package ArtioFusioncharts
 * @copyright Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link http://www.artio.net Official website
 */

var ARTIOFusionCharts = {
	rowsDelimiter : '|',
	colsDelimiter : '-',
	add : function(idParent, idMask, values) {
		var nextColor = ARTIOFusionCharts.getColor($(idParent)
				.getElements('tr').length - 1);

		/* copy default mask row */
		var clone = $(idMask).clone().inject(idParent);
		/* set as visible */
		clone.style.display = '';
		/* remove element ID - no duplicity */
		clone.removeProperty('id');

		var length = values != undefined ? values.length : 0;
		var index = 0;

		var anchors = clone.getElements('*[name^=' + idParent + ']');

		for ( var i = 0; i < anchors.length; i++) {
			var anchor = $(anchors[i]);
			if (index < length) {
				var value = trim(values[index++]);
			} else {
				var value = '';
			}
			if (anchor.className == "color {pickerPosition:'top',required:false}") {
				var parent = anchor.getParent();

				var color = document.createElement('input')

				color.className = "color {pickerPosition:'top',required:false}";
				color.name = anchor.name;
				color.size = '7';
				color.value = value != '' ? value : nextColor;

				var pixer = new jscolor.color(color);
				pixer.pickerPosition = 'top';
				pixer.valueElement.value = value != '' ? value : nextColor;
				parent.removeChild(anchor);
				parent.appendChild(color);

			} else if (value != '') {
				anchor.value = value;
			}
		}
	},

	remove : function(idParent, idMask, all) {
		// All input form field in parent element
		var anchors = $(document.getElementById(idParent)).getElements('input');
		for ( var i = 0; i < anchors.length; i++) {
			// If field is checkbox and is checked
			if ($(anchors[i]).getProperty('type') == 'checkbox'
					&& (all == true || $(anchors[i]).checked)) {
				// Table cell containing checkbox
				var cell = $(anchors[i]).getParent();
				// Table row containing cell - will be remove
				var row = $(cell).getParent();
				// No remove mask
				if (row.id != idMask) {
					// Table row parent - table body
					var body = $(row).getParent();
					// Remove row
					body.removeChild(row);
				}
			}
		}
	},

	checkAll : function(idParent, parent) {
		// All input form field in parent element
		var anchors = $(document.getElementById(idParent)).getElements('input');
		for ( var i = 0; i < anchors.length; i++) {
			// If field is checkbox
			if ($(anchors[i]).getProperty('type') == 'checkbox') {
				$(anchors[i]).checked = parent.checked;
			}
		}
	},

	getParams : function(idParent, mask) {
		// All table rows in parent
		var rows = $(document.getElementById(idParent)).getElements('tr');
		var params = new Array();
		// Work without first - is row mask
		for ( var i = 1; i < rows.length; i++) {
			params[i - 1] = '';
			// All input and selects
			var anchors = $(rows[i]).getElements('input').concat(
					$(rows[i]).getElements('select'));
			// Work without checkbox on row start
			for ( var j = 1; j < anchors.length; j++) {
				var anchor = $(anchors[j]);
				var name = anchor.name.replace(mask + '[', '');
				var name = name.replace('][]', '');
				params[i - 1] += ' ' + name + "='" + this.quote(anchor.value)
						+ "' ";
			}
		}
		return params;
	},

	renderSingle : function() {
		var xml = SingleSeries.getXML();
		this.render(xml);
		return false;
	},

	renderMulti : function() {
		var xml = MultiSeries.getXML();
		this.render(xml);
	},

	render : function(cols) {
		var params = this.loadParams();
		var width = this.quote(document.getElementById('width').value);
		var height = this.quote(document.getElementById('height').value);
		var lines = typeof TrendLines == 'undefined' ? '' : TrendLines.getXML();
		xml = '<' + CHART + ' ' + params + '>' + cols + ' ' + lines + '</'
				+ CHART + '>';
		chartObj.initialDataSet = false;
		if (width) {
			chartObj.setAttribute('width', width);
			chartObj.addVariable('chartWidth', width);
		}
		if (height) {
			chartObj.setAttribute('height', height);
			chartObj.addVariable('chartHeight', height);
		}
		chartObj.setDataXML(xml);
		chartObj.render("chartdiv");
	},

	loadParams : function() {
		var data = "";
		var params = document.getElementsByTagName('input');
		for ( var i = 0; i < params.length; i++) {
			if (params[i].type != 'hidden') {
				var id = params[i].id;
				if (id.match('params') && params[i].value != '') {
					var name = id.replace(/(params)/ig, "");
					if (params[i].type == 'radio') {
						if (!params[i].checked)
							continue;
						name = name.replace(/(0)/ig, "");
						name = name.replace(/(1)/ig, "");
					}
					var value = params[i].value;
					if (value != '') {
						data += ' ' + name + "='" + this.quote(value) + "'";
					}
				}
			}
		}
		var params = document.getElementsByTagName('select');
		for ( var i = 0; i < params.length; i++) {
			var id = params[i].id;
			if (id.match('params')) {
				var name = id.replace(/(params)/ig, "");
				var value = params[i].value;
				if (value != '') {
					data += ' ' + name + "='" + this.quote(value) + "'";
				}
			}
		}
		return data;
	},

	quote : function(string) {
		string = string.split(' ').join('&nbsp;');
		string = string.split("'").join('&#039;');
		return string.split('"').join('&#034;');
	},

	unquote : function(string) {
		string = string.split('&nbsp;').join(' ');
		string = string.split('&#039;').join("'");
		return string.split('&#034;').join('"');
	},

	arraysMerge : function(array1, array2) {
		var output = new Array(array1.length + array2.length);
		for ( var i = 0; i < array1.length; i++) {
			output[i] = array1[i];
		}
		for ( var j = 0; j < array2.length; j++) {
			output[j + i] = array2[j];
		}
		return output;
	},

	changeType : function() {
		if (document.adminForm.type.value == "0") {
			alert(lgErrorMissType);
			return false;
		}
		if (confirm(lgChangeTypeConfirm)) {
			submitbutton('apply');
		}
	},

	insertChart : function(id, title, eName) {
		window.parent.jInsertEditorText('{fusionchart id="' + id + '" ' + title
				+ '}', eName);
		window.parent.SqueezeBox.close();
		return false;
	},

	changeCharts : function() {
		var category = document.getElementById('category');
		var selectedCategory = document.getElementById('selectedCategory');
		var old = document.getElementById(selectedCategory.value);
		if (old) {
			old.style.display = 'none';
			old.name = '';
		}
		var newCharts = document.getElementById(category.value);
		if (newCharts) {
			newCharts.style.display = 'inline';
			newCharts.name = 'type';
			selectedCategory.value = category.value;
		}
	},

	addNext : function(container, lastItem, nextItem) {
		if (container && lastItem && nextItem) {
			container.insertBefore(nextItem, lastItem.nextSibling);
			return true;
		}
		return false;
	},

	getColor : function(count) {
		var length = afcolors.length;
		var position = count % length;
		return afcolors[position];
	},

	importSource : function(element) {
		if (trim(element.form.source.value) == '') {
			alert(lgAddFileSource);
			return false;
		}
		if (!document.getElementById('sourceTypeXml').checked
				&& !document.getElementById('sourceTypeCsv').checked) {
			alert(lgSelectImportType);
			return false;
		}
		element.form.submit();
	},

	prepareScrollElements : function() {
		var dataset = document.getElementById('dataset');
		var chartContainer = document.getElementById('chartContainer');
		if (dataset) {
			dataset.style.width = (screen.width - 140) + 'px';
		}
		if (chartContainer) {
			chartContainer.style.width = (screen.width * 0.60) + 'px';
		}
	},

	setUseSqlQuery : function() {
		document.getElementById('sqlQueryBox').style.display = document
				.getElementById('useSqlQuery1').checked ? 'none' : 'block';
	},

	trySqlQuery : function() {
		var sqlQuery = document.getElementById('sqlQuery');
		var database = document.getElementById('database');
		if (trim(sqlQuery.value) == '') {
			alert(lgSqlQueryEmpty);
		} else {
			var url = juri + 'index.php';
			var params = 'option=com_artiofusioncharts&task=trySqlQuery&sqlQuery='
					+ ARTIOFusionChartsAjax.encodeParam(sqlQuery.value) + '&database=' + database.value;
			ARTIOFusionChartsAjax.post(url, params, function(result) {
				var parts = result.split(ARTIOFusionCharts.rowsDelimiter);
				var code = parts[0];

				switch (code) {
				case 'SQL QUERY FAILED':
					ARTIOFusionCharts.sqlQueryFailed(parts);
					break;
				case 'SQL QUERY EMPTY':
					ARTIOFusionCharts.sqlQueryEmpty(parts);
					break;
				case 'SQL QUERY OK':
					ARTIOFusionCharts.sqlQueryOk(parts);
					break;
				default:
				case 'SQL QUERY ERROR':
					ARTIOFusionCharts.sqlQueryFailed(parts);
					break;
				}

			});
		}
		return false;
	},

	sqlQueryFailed : function(parts) {
		if (trim(parts[1]) != '') {
			ARTIOFusionCharts.sqlQueryOutput(sqlQueryFailedDbErrorMessage
					+ parts[1], 'error');
		} else {
			ARTIOFusionCharts.sqlQueryOutput(sqlQueryFailed, 'error');
		}
	},

	sqlQueryEmpty : function(parts) {
		ARTIOFusionCharts.sqlQueryOutput(sqlQueryEmpty, 'notice');
	},

	sqlQueryOutput : function(content, type) {
		var sglQueryOutput = document.getElementById('sglQueryOutput');

		var sglQueryMessage = document.getElementById('sglQueryMessage');
		var sglQueryNotice = document.getElementById('sglQueryNotice');
		var sglQueryError = document.getElementById('sglQueryError');

		var sglQueryMessageText = document
				.getElementById('sglQueryMessageText');
		var sglQueryNoticeText = document.getElementById('sglQueryNoticeText');
		var sglQueryErrorText = document.getElementById('sglQueryErrorText');

		sglQueryOutput.style.display = 'block';

		sglQueryMessage.style.display = 'none';
		sglQueryNotice.style.display = 'none';
		sglQueryError.style.display = 'none';

		sglQueryMessageText.innerHTML = '';
		sglQueryNoticeText.innerHTML = '';
		sglQueryErrorText.innerHTML = '';

		switch (type) {
		case 'message':
			sglQueryMessage.style.display = 'block';
			sglQueryMessageText.innerHTML = content;
			break;
		case 'notice':
			sglQueryNotice.style.display = 'block';
			sglQueryNoticeText.innerHTML = content;
			break;
		case 'error':
			sglQueryError.style.display = 'block';
			sglQueryErrorText.innerHTML = content;
			break;
		}
	},

	sqlQueryOk : function(parts) {
		var replace = document.getElementById('sqlQueryReplace1').checked;
		if (document.getElementById('sets') != undefined) {
			if (replace) {
				ARTIOFusionCharts.remove('sets', 'set', true);
			}
			for ( var i = 1; i < parts.length; i++) {
				ARTIOFusionCharts.add('sets', 'set', this.getCols(parts[i]));
			}
			ARTIOFusionCharts.renderSingle();
		}
		if (document.getElementById('chart-data') != undefined) {
			if (replace) {
				MultiSeries.removeDatasets(true);
				MultiSeries.removeCategories(true);
			}
			var cols = this.getCols(parts[1]);
			for ( var i = 1; i < cols.length; i++) {
				MultiSeries.addCategory(cols[i]);
			}
			for ( var i = 2; i < parts.length; i++) {
				MultiSeries.addDataset(this.getCols(parts[i]));
			}
			ARTIOFusionCharts.renderMulti();
		}
		ARTIOFusionCharts.sqlQueryOutput(sqlQueryOk, 'message');
	},

	fillSource : function(result) {
		var parts = result.split(this.rowsDelimiter);
		if (window.parent.document.getElementById('sets') != undefined) {
			window.parent.ARTIOFusionCharts.remove('sets', 'set', true);
			for ( var i = 0; i < parts.length; i++) {
				window.parent.ARTIOFusionCharts.add('sets', 'set', this
						.getCols(parts[i]));
			}
			window.parent.ARTIOFusionCharts.renderSingle();
		}
		if (window.parent.document.getElementById('chart-data') != undefined) {
			window.parent.MultiSeries.removeDatasets(true);
			window.parent.MultiSeries.removeCategories(true);
			var cols = this.getCols(parts[0]);
			for ( var i = 1; i < cols.length; i++) {
				window.parent.MultiSeries.addCategory(cols[i]);
			}
			for ( var i = 1; i < parts.length; i++) {
				window.parent.MultiSeries.addDataset(this.getCols(parts[i]));
			}
			window.parent.ARTIOFusionCharts.renderMulti();
		}
	},

	getCols : function(row) {
		var cols = row.split(this.colsDelimiter);
		for ( var i = 0; i < cols.length; i++) {
			cols[i] = cols[i].replace(/&brvbar;/g, '|');
			cols[i] = cols[i].replace(/&ndash;/g, '-');
			cols[i] = cols[i].replace(/&amp;brvbar;/g, '|');
			cols[i] = cols[i].replace(/&amp;ndash;/g, '-');
		}
		return cols;
	},
	
	toInt : function(el) {
		var oldValue = el.value;
		var newValue = this.parseInt(oldValue);
		if (oldValue.toString() != newValue.toString()) {
			el.value = newValue;
		}
	},
	
	parseInt : function(value) {
		value = trim(value);
		var newValue = '';
		var length = value.length;
		for ( var i = 0; i < length; i++) {
			var char = value.charAt(i);
			if (i == 0 && (char == '0' || char == 0)) {
				continue;
			}
			switch (char) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					newValue += char;
			}
		}
		if (newValue != '') {
			newValue = parseInt(newValue);
		}
		return newValue;
	},
	
	copy : function(el){
		if (el.form.boxchecked.value == '0') 
			alert(lgSelectChartsToCopy);
		else if (el.form.copy.value == '0' || el.form.copy.value == '') 
			alert(lgAddValidCopyCount);
		else {
			el.form.task.value = 'copy';
			el.form.submit();
		}
		return false;
	}
}