
/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

var MultiSeries = {
	addCategory : function(value) {
		var categories = document.getElementById('categories');
		var lid = this.getLastCategoryID();
		var last = document.getElementById('category-cont-' + lid);
		var next = document.createElement('td');
		var nid = lid;
		nid++;
		next.id = 'category-cont-' + nid;
		next.className = 'chart';
		next.innerHTML = '<input type="checkbox" id="category-checkbox-' + nid + '" name="category-checkbox-' + nid + '" value="' + nid + '" class="checkbox"/>\n' + '<input type="text" id="category-'
				+ nid + '" name="chart-category[]" value="' + (value != undefined ? value : '') + '" size="15"/>\n' + '<input type="hidden" id="category-' + nid + '-params" name="chart-category-params[]" value=""/>\n' + '<img src="'
				+ setImage + '" class="setImage" onclick="MultiSeries.setParams(\'category-' + nid + '-params\',\'maskCategory\')" alt="' + lgConfig + '"/>\n';
		if (ARTIOFusionCharts.addNext(categories, last, next)) {
			this.setLastCategoryID(nid);
		}
		var dlid = this.getLastDatasetID();
		for ( var i = 1; i <= dlid; i++) {
			var dataset = document.getElementById('dataset-' + i);
			var last = document.getElementById('dataset-' + i + '-value-' + lid);
			var next = document.createElement('td');
			next.id = 'dataset-' + i + '-value-' + nid;
			next.className = 'chart';
			next.innerHTML = '<input type="text" id="dataset-' + i + '-name-' + nid + '" value="" name="dataset-' + i + '-values[]" size="15"/>\n' + '<input type="hidden" id="dataset-' + i
					+ '-value-' + nid + '-params" name="dataset-' + i + '-value-params[]" value=""/>\n' + '<img src="' + setImage + '" class="setImage" onclick="MultiSeries.setParams(\'dataset-' + i
					+ '-value-' + nid + '-params\',\'maskSet\')" alt="' + lgConfig + '"/>\n';
			ARTIOFusionCharts.addNext(dataset, last, next);
		}
	},

	getDatasetsCount : function() {
		var count = 0;
		var ldid = this.getLastDatasetID();
		for ( var i = 1; i <= ldid; i++) {
			var checkbox = document.getElementById('dataset-checkbox-' + i);
			if (checkbox) {
				count++;
			}
		}
		return count;
	},
	
	addDataset : function(values) {
		var chartData = document.getElementById('chart-data');
		var ldid = this.getLastDatasetID();
		var last = document.getElementById('dataset-' + ldid);
		var ndid = ldid;
		ndid++;
		var next = document.createElement('tr');
		next.id = 'dataset-' + ndid;
		var cell = document.createElement('td');
		cell.className = 'chart';
		var count = this.getDatasetsCount();
		var color = ARTIOFusionCharts.getColor(count);
		var value = this.getValue(values, 0);
		var html = '<input id="dataset-checkbox-' + ndid + '" type="checkbox" value="' + ndid + '" name="dataset-checkbox-' + ndid + '" class="checkbox"/>\n'
				+ '<input type="text" value="' + value + '" name="dataset[' + ndid + ']" id="dataset-name-' + ndid + '" size="15"/>\n';
		if (datasetGroup == '1' && datasetGroupCount > '0') {
			html += '<select autocomplete="off" class="datasetGroup" name="dataset-group[' + ndid + ']" id="dataset-group-' + ndid + '">\n';
			for (var i = 1; i <= datasetGroupCount; i++)
				html += '<option value="' + i + '">' + lgDatasetGroup.replace(/12345/, i) + '</option>\n';
			html += '</select>\n';
		}
		html += '<input type="hidden" id="dataset-' + ndid
				+ '-params" name="dataset-params[' + ndid + ']" value="color=\'' + color + '\'"/>\n' + '<img src="' + setImage + '" class="setImage"  onclick="MultiSeries.setParams(\'dataset-' + ndid
				+ '-params\',\'maskDataset\')" alt="' + lgConfig + '"/>\n';
		
		cell.innerHTML = html;

		next.appendChild(cell);
		var lid = this.getLastCategoryID();
		for ( var i = 1; i <= lid; i++) {
			var category = document.getElementById('category-cont-' + i);
			if (category) {
				var value = this.getValue(values, i);
				cell = document.createElement('td');
				cell.id = 'dataset-' + ndid + '-value-' + i;
				cell.className = 'chart';
				cell.innerHTML = '<input type="text" id="dataset-' + ndid + '-name-' + i + '" value="' + value + '" name="dataset-' + ndid + '-values[]" size="15"/>\n' + '<input type="hidden" id="dataset-' + ndid
						+ '-value-' + i + '-params" name="dataset-' + ndid + '-value-params[]" value=""/>\n' + '<img src="' + setImage + '" class="setImage" onclick="MultiSeries.setParams(\'dataset-'
						+ ndid + '-value-' + i + '-params\',\'maskSet\')" alt="' + lgConfig + '"/>\n';
				next.appendChild(cell);
			}
		}
		if (ARTIOFusionCharts.addNext(chartData, last, next)) {
			this.setLastDatasetID(ndid);
		}
	},
	
	getValue : function(values, i) {
		var value = '';
		if (values != undefined && values.length > i) {
			value = values[i];
		}
		return value;
	},

	removeCategories : function(all) {
		var lid = this.getLastCategoryID();
		var ldid = this.getLastDatasetID();
		var nlid = lid;
		for ( var i = lid; i > 0; i--) {
			var checkbox = document.getElementById('category-checkbox-' + i);
			if (checkbox) {
				if (nlid == -1) {
					nlid = i;
				}
				if (checkbox.checked == true || all == true) {
					var categories = document.getElementById('categories');
					var category = document.getElementById('category-cont-' + i);
					if (categories && category) {
						categories.removeChild(category);
					}
					for ( var j = ldid; j > 0; j--) {
						var dataset = document.getElementById('dataset-' + j);
						var value = document.getElementById('dataset-' + j + '-value-' + i);
						if (dataset && value) {
							dataset.removeChild(value);
						}
					}
					if (i == nlid) {
						nlid = -1;
					}
				}
			}
		}
		if (nlid == -1) {
			nlid = 0;
		}
		this.setLastCategoryID(nlid);
		ARTIOFusionCharts.renderMulti();
	},

	removeDatasets : function(all) {
		var ldid = this.getLastDatasetID();
		var nldid = ldid;
		var chartData = document.getElementById('chart-data');
		for ( var i = ldid; i > 0; i--) {
			var checkbox = document.getElementById('dataset-checkbox-' + i);
			if (checkbox) {
				if (nldid == -1) {
					nldid = i;
				}
				if (checkbox.checked == true || all == true) {
					var dataset = document.getElementById('dataset-' + i);
					if (dataset && chartData) {
						chartData.removeChild(dataset);
					}
					if (i == nldid) {
						nldid = -1;
					}
				}
			}
		}
		if (nldid == -1) {
			nldid = 0;
		}
		this.setLastDatasetID(nldid);
		ARTIOFusionCharts.renderMulti();
	},
	
	addLineSet : function() {
		var id = this.getLastLinesetID();
		id++;
		
		Elements.from('<tr id="lineset-' + id + '">\n<td class="chart">\n<input type="checkbox" class="checkbox" value="1" name="lineset-checkbox-' + id + '" id="lineset-checkbox-' + id + '">\n<input type="text" size="15" value="" name="lineset[' + id + ']" id="lineset-name-' + id + '">\n<img alt="'+lgConfig+'" onclick="MultiSeries.setParams(\'lineset-' + id + '-params\',\'maskLineset\')" class="setImage" src="' + setImage + '">\n<img onclick="MultiSeries.addLineSetSet(' + id + ')" class="setImage" src="' + addImage + '">\n<input type="hidden" value="" name="lineset-params[' + id + ']" id="lineset-' + id + '-params">\n</td>\n<td style="display: none" id="lineset-' + id + '-value-0"></td>\n<td id="lineset-' + id + '-values">\n</td>\n</tr>\n').inject($('linesets'));
		
		this.setLastLinesetID(id);
	},
	
	addLineSetSet : function(id) {
		var sid = $('lineset-' + id + '-values').getElements('input[id^=lineset-' + id + '-value-]').length + 1;
		Elements.from('<input type="text" size="15" value="" name="lineset-' + id + '-values[]" id="lineset-' + id + '-value-'+sid+'">\n<img onclick="MultiSeries.removeLineSetSet('+id+', '+sid+', this)" class="setImage" src="' + remImage + '" id="lineset-' + id + '-remove-' + sid + '">').inject($('lineset-' + id + '-values'));
	},
	
	removeLineSets : function() {
		var e = $('linesets').getElements('input[type=checkbox]');
		e.each(function(e, i) {
			if (e.checked)
				e.getParent().getParent().dispose();
		});
	},
	
	removeLineSetSet : function(id, sid) {
		$('lineset-' + id + '-value-' + sid).dispose();
		$('lineset-' + id + '-remove-' + sid).dispose();
	},

	getXML : function() {
		var lid = this.getLastCategoryID();
		var ldid = this.getLastDatasetID();
		var lsid = this.getLastLinesetID();
		var params = document.getElementById('categories-params').value;
		var data = '<categories ' + params + '>';
		for ( var i = 1; i <= lid; i++) {
			var category = document.getElementById('category-' + i);
			var params = document.getElementById('category-' + i + '-params');
			if (category && params) {
				data += "<category name='" + ARTIOFusionCharts.quote(category.value) + "' " + params.value + "/>";
			}
		}
		data += '</categories>';
		var datasets = new Array();
		for ( var i = 1; i <= ldid; i++) {
			var name = document.getElementById('dataset-name-' + i);
			var params = document.getElementById('dataset-' + i + '-params');
			var dataset = '';
			if (name && params) {
				dataset += "<dataset seriesName='" + ARTIOFusionCharts.quote(name.value) + "' " + params.value + ">";
				for ( var j = 1; j <= lid; j++) {
					var val = document.getElementById('dataset-' + i + '-name-' + j);
					var params = document.getElementById('dataset-' + i + '-value-' + j + '-params');
					if (val && params) {
						dataset += "<set value='" + ARTIOFusionCharts.quote(val.value) + "' " + params.value + "/>";
					}
				}
				dataset += '</dataset>';
				
				if (document.getElementById('dataset-group-' + i)) { // there is parent dataset selector
					if (datasets[document.getElementById('dataset-group-' + i).value] == undefined)
						datasets[document.getElementById('dataset-group-' + i).value] = '';
					datasets[document.getElementById('dataset-group-' + i).value] += dataset; // split dataset list into parent dataset
				} else // non parent dataset mode    
					datasets[0] += dataset;
			}
		}
		
		if (datasets.length == 1 && datasets[0] != undefined) // non parent dataset mode
			data += datasets[0]; // only dataset level
		else
			for (var i = 0; i < datasets.length; i++)
				data += '<dataset>' + datasets[i] + '</dataset>'; // parent dataset level
		
		for ( var i = 1; i <= lsid; i++) {
			data += "<lineset seriesName='" + ARTIOFusionCharts.quote($('lineset-name-' + i).value) + "' " + $('lineset-' + i + '-params').value + ">";
			var sets = $('lineset-' + i).getElements('input[id^=lineset-' + i + '-value-]');
			for ( var j = 0; j < sets.length; j++)
				data += "<set value='" + ARTIOFusionCharts.quote(sets[j].value) + "'/>";
			data += '</lineset>';
		}
		
		return data;
	},

	getLastCategoryID : function() {
		var lastCategoryID = this.loadLastCategoryID();
		return lastCategoryID ? lastCategoryID.value : 0;
	},

	setLastCategoryID : function(value) {
		var lastCategoryID = this.loadLastCategoryID();
		if (lastCategoryID) {
			lastCategoryID.value = value;
		}
	},

	loadLastCategoryID : function() {
		return document.getElementById('lastCategoryID');
	},

	getLastDatasetID : function() {
		var lastDatasetID = this.loadLastDatasetID();
		return lastDatasetID ? lastDatasetID.value : 0;
	},

	setLastDatasetID : function(value) {
		var lastDatasetID = this.loadLastDatasetID();
		if (lastDatasetID) {
			lastDatasetID.value = value;
		}
	},

	loadLastLinesetID : function() {
		return document.getElementById('lastLinesetID');
	},
	
	getLastLinesetID : function() {
		var lastLinesetID = this.loadLastLinesetID();
		return lastLinesetID ? lastLinesetID.value : 0;
	},

	setLastLinesetID : function(value) {
		var lastLinesetID = this.loadLastLinesetID();
		if (lastLinesetID) {
			lastLinesetID.value = value;
		}
	},

	loadLastDatasetID : function() {
		return document.getElementById('lastDatasetID');
	},

	setParams : function(id, mask) {
		switch (mask) {
			case 'maskCategories' :
				var src = maskCategories;
				var width = maskCategoriesWidth;
				var height = maskCategoriesHeight;
				break;
			case 'maskCategory' :
				var src = maskCategory;
				var width = maskCategoryWidth;
				var height = maskCategoryHeight;
				break;
			case 'maskDataset' :
				var src = maskDataset;
				var width = maskDatasetWidth;
				var height = maskDatasetHeight;
				break;
			case 'maskSet' :
				var src = maskSet;
				var width = maskSetWidth;
				var height = maskSetHeight;
				break;
			case 'maskLineset' :
				var src = maskLineset;
				var width = maskLinesetWidth;
				var height = maskLinesetHeight;
				break;
		}

		var string = '<div class="setValuesToolbar">' + src + '<table class="toolbar">' + '<tbody>' + '<tr>' + '<td id="toolbar-save" class="button">'
				+ '<a class="toolbar" href="javascript:MultiSeries.setValues(\'' + id + '\')" >' + '<span class="icon-32-save" title="Save"></span>' + lgSave + '</a>' + '</td>'
				+ '<td id="toolbar-cancel" class="button">' + '<a class="toolbar" href="javascript:MultiSeries.close()">' + '<span class="icon-32-cancel" title="Close"></span>' + lgClose + '</a>'
				+ '</td>' + '</tr>' + '</tbody>' + '</table>' + '</div>';
		SqueezeBox.options.size = {
			x : width,
			y : height
		};
		SqueezeBox.setContent('string', string);
		window.setTimeout("MultiSeries.loadValues('" + id + "')", 400);
		window.setTimeout('jscolor.init()', 500);
	},

	loadValues : function(id) {
		var data = document.getElementById(id).value;
		var parts = data.split(' ');
		var params = this.getParams();
		for ( var i = 0; i < params.length; i++) {
			var id = params[i].id;
			if (id.match('paramsds_')) {
				id = this.cleanId(params[i])
				var name = this.getParamNameFromId(id);
				for ( var j = 0; j < parts.length; j++) {
					if (parts[j].match(name + "='")) {
						var p = parts[j].split("='");
						var value = p[1].substr(0, p[1].length - 1);
						if (params[i].type == 'radio') {
							var c = document.getElementById(id + value);
							if (c) {
								c.checked = c.value == value;
							}
						} else {
							document.getElementById(id).value = ARTIOFusionCharts.unquote(value);
						}
					}
				}
			}
		}
	},

	setValues : function(elId) {
		var params = this.getParams();
		var data = '';
		for ( var i = 0; i < params.length; i++) {
			var id = params[i].id;
			if (id.match('paramsds_')) {
				id = this.cleanId(params[i])
				var name = this.getParamNameFromId(id);
				if ((params[i].type == 'radio' && params[i].checked) || (params[i].type != 'radio' && params[i].value != '')) {
					data += name + "='" + ARTIOFusionCharts.quote(params[i].value) + "' ";
				}
			}
		}
		document.getElementById(elId).value = trim(data);
		ARTIOFusionCharts.renderMulti();
		this.close();
	},

	getParams : function() {
		var params = ARTIOFusionCharts.arraysMerge(document.getElementsByTagName('input'), document.getElementsByTagName('textarea'));
		return ARTIOFusionCharts.arraysMerge(params, document.getElementsByTagName('select'));
	},

	getParamNameFromId : function(id) {
		return id.replace(/(paramsds_)/ig, "");
	},

	cleanId : function(el, id) {
		var id = el.id;
		if (el.type == 'radio') {
			id = id.replace(/(0)/ig, "");
			id = id.replace(/(1)/ig, "");
		}
		return id;
	},

	close : function() {
		SqueezeBox.close();
	}
}
