<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

class ARTIOFusionChartsHelperRoute
{

    function getCreateRoute($type, $chart)
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&category=' . $type . '&type=' . $chart . '&task=add';
    }

    function getEditRoute($id)
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&view=artiofusionchart&task=edit&cid[]=' . $id;
    }

    function getEditDatabaseRoute($id)
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&view=artiofusionchart&task=editDatabase&cid[]=' . $id;
    }

    function getHomeRoute()
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION;
    }

    function getUserRoute($id)
    {
        return (ARTIOFUSIONCHARTS_J16 ? 'index.php?option=com_users&task=user.edit&id=' : 'index.php?option=com_users&view=user&task=edit&cid[]=') . $id;
    }

    function getListChartsRoute($plugin = null, $tmpl = null, $e_name = null)
    {
        $url = 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&view=artiofusioncharts';
        if (($plugin = JString::trim($plugin)))
            $url .= '&plugin=' . $plugin;
        if (($tmpl = JString::trim($tmpl)))
            $url .= '&tmpl=' . $tmpl;
        if (($e_name = JString::trim($e_name)))
            $url .= '&e_name=' . $e_name;
        return $url;
    }

    function getListDatabasesRoute()
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&view=databases';
    }

    function getCreateListRoute()
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&task=create';
    }

    function getSourceLayout()
    {
        return 'index.php?option=' . ARTIOFUSIONCHARTS_OPTION . '&view=artiofusionchart&tmpl=component&layout=form_source';
    }

    function setSubmenu($page)
    {
        if (class_exists('JSubMenuHelper')) {
            if (ARTIOFUSIONCHARTS_CREATE)
                JSubMenuHelper::addEntry(JText::_('Create New Chart'), ARTIOFusionChartsHelperRoute::getCreateListRoute(), $page == ARTIOFUSIONCHARTS_PAGE_CREATE);
            if (ARTIOFUSIONCHARTS_MANAGE)
                JSubMenuHelper::addEntry(JText::_('Charts Manager'), ARTIOFusionChartsHelperRoute::getListChartsRoute(), $page == ARTIOFUSIONCHARTS_PAGE_CHARTS);
                        }
    }
}
?>