<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

$items = array();

$items['lgConfirm'] = JText::_('Are you sure?');
$items['lgRemove'] = JText::_('Remove');
$items['lgNoCheckedToRemove'] = JText::_('Select Items To Remove By Check Checkboxes');
$items['lgChangeTypeConfirm'] = JText::_('Before Change Actual Data Will Be Saved. Want You Continue?');
$items['lgErrorMissType'] = JText::_('Select Type');
$items['lgSave'] = JText::_('Save');
$items['lgClose'] = JText::_('Close');
$items['parOption'] = ARTIOFUSIONCHARTS_OPTION;
$items['setImage'] = ARTIOFUSIONCHARTS_SET_IMAGE;
$items['addImage'] = ARTIOFUSIONCHARTS_ADD_IMAGE;
$items['remImage'] = ARTIOFUSIONCHARTS_REM_IMAGE;
$items['lgConfig'] = JText::_('Config');
$items['lgMustAddChartTitle'] = JText::_('Add Chart Title');
$items['lgMustAddChartCategory'] = JText::_('Add Chart Category');
$items['lgMustAddChartType'] = JText::_('Add Chart Type');
$items['lgAddFileSource'] = JText::_('Add File source');
$items['lgSelectImportType'] = JText::_('Select import type');
$items['lgSqlQueryEmpty'] = JText::_('Sql query is empty');
$items['CHART'] = CHART;
$items['juri'] = JURI::base();
$items['sqlQueryFailedDbErrorMessage'] = 'SQL Query failed. DB error message: ';
$items['sqlQueryFailed'] = 'SQL Query failed.';
$items['sqlQueryOk'] = 'SQL Query OK. The chart was fill and render by new data.';
$items['sqlQueryEmpty'] = 'SQL Query OK, but get empty output.';
$items['lgSelectChartsToCopy'] = JText::_('Select charts to copy.');
$items['lgAddValidCopyCount'] = JText::_('Count of copies must be number bigger then zero.');
$items['datasetGroup'] = empty($this->chart->chartSetting['datasetGroup']) ? 0 : 1;
$items['datasetGroupCount'] = empty($this->datasetGroup) ? 0 : count($this->datasetGroup);
$items['lgDatasetGroup'] = JText::sprintf('DATASET_GROUP', 12345);

$js = '';

foreach ($items as $var => $value) {
    $js .= 'var ' . $var . ' = "' . htmlspecialchars($value, ENT_QUOTES) . '";' . "\n";
}

$document = &JFactory::getDocument();
/* @var $document JDocument */
$document->addScriptDeclaration($js);

?>