<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class ARTIOFusionChartsModelARTIOFusionChart extends JModel
{
    /**
     * Id of manipulated chart from request
     *
     * @access var
     * @var int
     */
    var $_id = null;
    /**
     * Chart data
     *
     * @access var
     * @var TableChart
     */
    var $_data = null;

    /**
     * Database connector
     * 
     * @var JDatabaseMySQL
     */
    var $_db;
    
    /**
     * Constructor, set main params.
     *
     * @access public
     */
    function __construct()
    {
        parent::__construct();
        $array = JRequest::getVar('cid', array(0), '', 'array');
        $edit = JRequest::getVar('edit', true);
        if ($edit) {
            $this->setId((int) $array[0]);
        }
    }

    /**
     * Set chart id snd reset chart data.
     *
     * @access var
     * @param int $id new id
     */
    function setId($id)
    {
        $this->_id = $id;
        $this->_data = null;
    }

    /**
     * Get information row is checked by other user then logged.
     *
     * @param int $id
     * @return boolean
     */
    function isCheckedOut($id)
    {
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $chart = &$this->getTable();
        /* @var $database TableARTIOFusionChart */
        $chart->load($id);
        return $chart->isCheckedOut($user->id);
    }

    /**
     * Check in chart after end editing
     *
     * @access public
     * @return boolean true: succesfull, false: no set id or db error
     */
    function checkin()
    {
        if ($this->_id) {
            $chart = & $this->getTable();
            /* @var $row TableARTIOFusionChart */
            if (! $chart->checkin($this->_id)) {
                $this->setError($this->_db->getErrorMsg());
                return false;
            }
            return true;
        }
        return false;
    }

    /**
     * Check out chart for lock during editing
     *
     * @access public
     * @param int $uid user id who locked
     * @return boolean true: succesfull, false: no set id or db error
     */
    function checkout($uid = null)
    {
        if ($this->_id) {
            if (is_null($uid)) {
                $user = & JFactory::getUser();
                /* @var $user JUser */
                $uid = $user->get('id');
            }
            $chart = & $this->getTable();
            /* @var $row TableARTIOFusionChart */
            if (! $chart->checkout($uid, $this->_id)) {
                $this->setError($this->_db->getErrorMsg());
                return false;
            }
            return true;
        }
        return false;
    }

    /**
     * Save chart on db
     *
     * @access public
     * @param array $data request data
     * @return boolean true: successfull, false: db error or invalid data
     */
    function store(&$data)
    {
        $row = & $this->getTable();
        /* @var $row TableARTIOFusionChart */
        
        if (! $row->bind($data)) {
            $this->setError($this->_db->getErrorMsg());
            return 0;
        }
        
        $setting = &ARTIOFusionChartsHelper::loadChartSetting($data, true);
        
        $registry = new JRegistry();
        $registry->loadArray($setting);
        $row->setting = $registry->toString();
        
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $date = &JFactory::getDate();
        /* @var $date JDate */
        
        if (! $row->id) {
            $row->created = $date->toMySQL(true);
            $row->created_by = $user->id;
            $row->modified = $this->_db->getNullDate();
            $row->modified_by = 0;
        } else {
            $row->modified = $date->toMySQL(true);
            $row->modified_by = $user->id;
        }
        
        $row->xml = ARTIOFusionChartsHelper::getChartXMLFromRequest($data);
        
        if (! $row->check()) {
            $this->setError($this->_db->getErrorMsg());
            return 0;
        }
        if (! $row->store()) {
            $this->setError($this->_db->getErrorMsg());
            return 0;
        }
        
        return $row->id;
    }

    /**
     * Remove charts from database by ids from request.
     *
     * @access public
     */
    function remove($cid)
    {
        JArrayHelper::toInteger($cid);
        if (count($cid)) {
            $this->_db->setQuery('DELETE FROM `#__artiofusioncharts` WHERE `id` IN (' . implode(',', $cid) . ')');
            $this->_db->query();
        }
    }

    /**
     * Get chart id
     *
     * @access public
     * @param int $id
     * @return int
     */
    function getId($id = null)
    {
        return $id === null ? $this->_id : $id;
    }

    /**
     * Get chart data from db
     *
     * @access public
     * @param int $id
     * @return stdClass
     */
    function getData($id = null)
    {
        $id = ARTIOFusionChartsModelARTIOFusionChart::getId($id);
        $chart = &$this->getTable();
        /* @var $chart TableARTIOFusionChart */
        $chart->load($id);
        return $chart;
    }

    /**
     * Copy selected charts.
     * 
     * @param array $cid charts IDs
     * @param int $count number of copies
     * @return int number of successful copies
     */
    function copy($cid, $count)
    {
        $table = &$this->getTable();
        /* @var $table TableARTIOFusionChart */
        $total = 0;
        if (count($cid) && $count > 0)
            foreach ($cid as $id)
                if ($table->load((int) $id))
                    for ($i = 0; $i < $count; $i ++) {
                        $table->id = null;
                        if ($table->store())
                            $total ++;
                    }
        return $total;
    }
}

?>