<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class ARTIOFusionChartsModelARTIOFusionCharts extends JModel
{
    /**
     * Charts data
     *
     * @access var
     * @var array
     */
    var $_data = null;
    /**
     * Total charts count
     *
     * @access var
     * @var int
     */
    var $_total = null;
    /**
     * Page listing object
     *
     * @access var
     * @var JPagination
     */
    var $_pagination = null;

    /**
     * Constructor. Seting maim params.
     *
     * @access public
     */
    function __construct()
    {
        parent::__construct();
        
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        $limit = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . '_limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        
        if ($mainframe->isAdmin())
            $limitstart = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . '_limitstart', 'limitstart', 0, 'int');
        else
            $limitstart = JRequest::getInt('limitstart');
            
        $limitstart = $limit == 0 ? 0 : (floor($limitstart / $limit) * $limit);
        
        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);
    }

    /**
     * Get chart list by listing params.
     *
     * @return array
     */
    function getData()
    {
        if (empty($this->_data)) {
            $query = $this->_buildQuery();
            $this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_data;
    }

    /**
     * Get total charts count
     *
     * @return int
     */
    function getTotal()
    {
        if (empty($this->_total)) {
            $query = $this->_buildQuery();
            $this->_total = $this->_getListCount($query);
        }
        return $this->_total;
    }

    /**
     * Get listing object with seting
     *
     * @return JPagination
     */
    function getPagination()
    {
        jimport('joomla.html.pagination');
        $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
        return $this->_pagination;
    }

    /**
     * Build and return db query
     *
     * @return string
     */
    function _buildQuery()
    {
        static $query;
        if (empty($query)) {
            $query = 'SELECT `chart`.*, `user`.`name` AS `editor`, ';
            $query .= '`created`.`id` AS `created_id`, `created`.`name` AS `created_name`, ';
            $query .= '`modified`.`id` AS `modified_id`, `modified`.`name` AS `modified_name` ';
            $query .= 'FROM `#__artiofusioncharts` AS `chart` ';
            $query .= 'LEFT JOIN `#__users` AS `user` ON `chart`.`checked_out` = `user`.`id` ';
            $query .= 'LEFT JOIN `#__users` AS `created` ON `created`.`id` = `chart`.`created_by` ';
            $query .= 'LEFT JOIN `#__users` AS `modified` ON `modified`.`id` = `chart`.`modified_by` ';
            $query .= $this->_buildContentWhere() . ' ' . $this->_buildContentOrderBy();
        }
        return $query;
    }

    /**
     * Get db query order options 
     *
     * @return string
     */
    function _buildContentOrderBy()
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $filterOrder = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_order', 'filter_order', 'id', 'word');
        $filterOrderDir = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_order_Dir', 'filter_order_Dir', 'DESC', 'word');
        return ' ORDER BY `' . $filterOrder . '` ' . $filterOrderDir . ' ';
    }

    /**
     * Get db query where options
     *
     * @return string
     */
    function _buildContentWhere()
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $search = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'search', 'search', '', 'string');
        $search = JString::strtolower(JString::trim($search));
        $category = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_categories', 'filter_categories', '', 'string');
        $type = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_types', 'filter_types', '', 'string');
        if ($search) {
            $where[] = 'LOWER(`title`) LIKE ' . $this->_db->Quote('%' . $search . '%');
        }
        if ($category) {
            $where[] = '`category` = ' . $this->_db->Quote($category);
        }
        if ($type) {
            $where[] = '`type` = ' . $this->_db->Quote($type);
        }
        $where = (isset($where) ? ' WHERE ' . implode(' AND ', $where) : '');
        return $where;
    }
}

?>