<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class ARTIOFusionChartsModelDatabases extends JModel
{
    /**
     * @var JDatabaseMySQL
     */
    var $_db;

    /**
     * Get databases list by listing params.
     * 
     * @param stdClass $filter
     * @return array
     */
    function getData(&$filter)
    {
        $query = $this->_buildQuery($filter);
        $data = $this->_getList($query, $filter->limitstart, $filter->limit);
        return $data;
    }

    /**
     * Get simple databases list containing only id and title ordered by title ascend.
     * 
     * @return array
     */
    function getSimpleList()
    {
        $this->_db->setQuery('SELECT `id`,`title` FROM `#__artiofusioncharts_database` ORDER BY `title` ASC');
        $list = &$this->_db->loadObjectList();
        return $list;
    }

    /**
     * Get total databases count
     *
     * @param stdClass $filter
     * @return int
     */
    function getTotal(&$filter)
    {
        $query = $this->_buildQuery($filter);
        $total = $this->_getListCount($query);
        return $total;
    }

    /**
     * Build and return db query
     *
     * @param stdClass $filter
     * @return string
     */
    function _buildQuery(&$filter)
    {
        $query = 'SELECT `database`.*, `user`.`name` AS `editor` FROM `#__artiofusioncharts_database` AS `database` ';
        $query .= 'LEFT JOIN `#__users` AS `user` ON `database`.`checked_out` = `user`.`id` ';
        $query .= $this->_buildContentWhere($filter) . ' ' . $this->_buildContentOrderBy($filter);
        return $query;
    }

    /**
     * Get db query order options 
     *
     * @param stdClass $filter
     * @return string
     */
    function _buildContentOrderBy(&$filter)
    {
        $order = 'ORDER BY `' . $filter->order . '` ' . $filter->orderDir;
        return $order;
    }

    /**
     * Get db query where options
     *
     * @param stdClass $filter
     * @return string
     */
    function _buildContentWhere(&$filter)
    {
        $where = '';
        if ($filter->search) {
            $where = 'WHERE LOWER(`title`) LIKE ' . $this->_db->Quote('%' . $filter->search . '%');
        }
        return $where;
    }
}

?>