<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class TableARTIOFusionChart extends JTable
{
    /**
     * Unique system id
     *
     * @access var
     * @var int
     */
    var $id = 0;
    /**
     * Chart name
     * 
     * @access var 
     * @var string
     */
    var $title = null;
    /**
     * Category type chart
     *
     * @access var
     * @var string
     */
    var $category = null;
    /**
     * Chart type within the category of
     *
     * @access var
     * @var string
     */
    var $type = null;
    /**
     * Chart created mysql datetime like YYYY-MM-DD HH:MM:SS
     *
     * @access var
     * @var string
     */
    var $created = null;
    /**
     * Creator user id
     *
     * @access var
     * @var int
     */
    var $created_by = null;
    /**
     * Chart modified mysql datetime, like YYYY-MM-DD HH:MM:SS
     * If new chart is in null format - 0000-00-00 00:00:00
     *
     * @access var
     * @var string
     */
    var $modified = null;
    /**
     * Id of user who modified chart, if new chart is 0
     *
     * @var
     * @var int
     */
    var $modified_by = null;
    /**
     * Id of user who just editing chart
     *
     * @access var
     * @var int
     */
    var $checked_out = null;
    /**
     * Time of chart locked by editing - mysql datetime, like YYYY-MM-DD HH:MM:SS
     *
     * @access var 
     * @var string
     */
    var $checked_out_time = null;
    /**
     * Chart additional params
     *
     * @access var
     * @var string
     */
    var $setting = null;
    /**
     * Standard JTable object constructor
     *
     * @param JDatabaseMySQL $db Joomla database support object
     */
    var $xml = null;
    /**
     * Create object and set database connector.
     * 
     * @param JDatabaseMySQL $db
     * @return void
     */
    function __construct (&$db)
    {
        parent::__construct('#__artiofusioncharts', 'id', $db);
    }
}

?>