<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewARTIOFusionChart */

jimport ('joomla.html.pane');

JHTML::_('behavior.tooltip');
JHTML::_('behavior.modal');
JHTML::_('behavior.mootools');

JHTML::script('joomla-tools.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
JHTML::script('FusionCharts.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
JHTML::script('common.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
JHTML::script('ajax.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
JHTML::script('jscolor.js', ARTIOFUSIONCHARTS_ASSETS_JS . 'jscolor/');

ARTIOFusionChartsHelper::importJoomlaJS();
ARTIOFusionChartsHelper::importColorsToJS();

include (ARTIOFUSIONCHARTS_BASE_LANG . DS . 'chart.php');

$pane = &JPane::getInstance ('sliders', array('allowAllClose' => true));
/* @var $pane JPaneSliders */

JToolBarHelper::title(JText::_('Chart') . ': <small><small>[ ' . JText::_(! JRequest::getVar('edit', true) ? 'New' : 'Edit') . ' ]</small></small>', 'charts.png');
if (ARTIOFUSIONCHARTS_EDIT || ARTIOFUSIONCHARTS_CREATE)
	JToolBarHelper::save();
if (ARTIOFUSIONCHARTS_EDIT)	 
	JToolBarHelper::apply();
JToolBarHelper::cancel('cancel', 'Close');
if (ARTIOFUSIONCHARTS_CREATE)
	JToolBarHelper::addNewX('create');
	
if ($this->chart->id) {
		if (ARTIOFUSIONCHARTS_DELETE)
	    JToolBarHelper::deleteListX(JText::_('Are you sure to delete this chart?'));
}

$function = ($this->chart->chartType == ARTIOFUSIONCHARTS_SINGLE_SERIES_TYPE) ? 'renderSingle()' : 'renderMulti()';

$document = &JFactory::getDocument();
/* @var $document JDocument */
$document->addScriptDeclaration('window.addEvent(\'domready\', function() { ARTIOFusionCharts.prepareScrollElements(); } );');

?>

<form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<div class="width-100">
		<table cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td valign="top" colspan="2">
					<?php echo $this->loadTemplate('main'); ?>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2">
					<?php 
					    if ($this->chart->chartType == ARTIOFUSIONCHARTS_SINGLE_SERIES_TYPE) 
		    				echo $this->loadTemplate('sets');
					    if ($this->chart->chartType == ARTIOFUSIONCHARTS_MULTI_SERIES_TYPE)
							echo $this->loadTemplate('datasets');
											    if ($this->chart->chartSetting['useTrendLines'])
					        echo $this->loadTemplate('trendlines');
					    if (!empty($this->chart->chartSetting['useLineSets']))
					    	echo $this->loadTemplate('lineset');
					?>
				</td>
			</tr>
			<tr>
				<td valign="top" style="width: 70%;">
	    			<fieldset class="adminform" style="text-align: center;">
	    				<legend><?php echo JText::_('Chart Preview'); ?></legend>
	    					<div style="margin: 20px; text-align: center;">
	    						<button style="float: none" onclick="ARTIOFusionCharts.<?php echo $function; ?>; return false;"><?php echo JText::_('Render Chart'); ?></button>
	    					</div>
	    					<div style="text-align: center; overflow: auto" id="chartContainer">
	    						<div id="chartdiv"></div>
	    						<script type="text/javascript">
	    							//<![CDATA[ 
	    						    var chartObj = null;
	    							window.addEvent('load', function() {
	    								chartObj = new FusionCharts("<?php echo $this->chart->chart; ?>", "ChartId", "<?php echo $this->chart->width; ?>", "<?php echo $this->chart->height; ?>", "0", "0");
	    								var xml = "<?php echo $this->chart->xml; ?>";
	    								chartObj.setDataXML(xml);                                                                                                                                         chartObj.setTransparent(true);
	    								chartObj.render("chartdiv");
	                                    <?php if (! $this->chart->id) { ?>
	                                        ARTIOFusionCharts.<?php echo $function; ?>;
	                                    <?php } ?>
	    							});
	    							//]]>
	    						</script>
	    					</div>
	    			</fieldset> 
				</td>
				<td valign="top" style="width: 30%">
					<fieldset class="adminform" id="<?php echo ($id = 'chartParameters'); ?>">
	    				<legend><?php echo JText::_('Chart Parameters'); ?></legend>
	    				<?php
	    					echo $pane->startPane('content-pane');
	        				echo ARTIOFusionChartsHelper::replaceTopAnchor($pane->startPanel(JText::_('Sizes'), 'sizes-page'), $id);
	    				?>
	    					<fieldset class="panelform">
	    						<table width="100%" class="paramlist admintable" cellspacing="1">
			    					<tr>
			    						<td width="40%" class="paramlist_key">
			    							<span class="editlinktip">
			    								<label id="width-lbl" for="width"><?php echo JText::_('JGLOBAL_WIDTH'); ?></label>
			    							</span>
			    						</td>
			    						<td class="paramlist_value">
			    							<input type="text" name="width" id="width" value="<?php echo $this->chart->width; ?>" class="text_area" size="20" />
			    						</td>
			    					</tr>
			    					<tr>
			    						<td width="40%" class="paramlist_key">
			    							<span class="editlinktip">
			    								<label id="height-lbl" for="height"><?php echo JText::_('Height'); ?></label>
			    							</span>
			    						</td>
			    						<td class="paramlist_value">
			    							<input type="text" name="height" id="height" value="<?php echo $this->chart->height; ?>" class="text_area" size="20" />
			    						</td>
			    					</tr>
		    					</table>
		    				</fieldset>
	    				<?php
	    					echo $pane->endPanel();
	        				foreach ($this->chart->form->getGroups() as $name => $count) {
	            				echo ARTIOFusionChartsHelper::replaceTopAnchor($pane->startPanel(JText::_($name), JFilterOutput::stringURLSafe($name)), $id);
	            		?>
	            				<fieldset class="panelform">
	            					<table width="100%" class="paramlist admintable" cellspacing="1">
	            					<?php foreach ($this->chart->form->getParams('params', $name) as $param) { ?>
	            						<tr>
	            							<td width="40%" class="paramlist_key">
	            								<span class="editlinktip"><?php echo $param[0]; ?></span>
	            							</td>
	            							<td class="paramlist_value"><?php echo $param[1]; ?></td>
	            						</tr>
	            					<?php } ?>
									</table>
								</fieldset>
	            		<?php
	            				echo $pane->endPanel();
	        				}
	        				echo $pane->endPane();
	    				?>
					</fieldset>
				</td>
			</tr>
		</table>
		<input type="hidden" name="option" value="<?php echo ARTIOFUSIONCHARTS_OPTION; ?>" />
		<input type="hidden" name="cid[]" value="<?php echo $this->chart->id; ?>" />
		<input type="hidden" id="selectedCategory" name="selectedCategory" value="<?php echo $this->chart->category; ?>" />
		<input type="hidden" name="task" value="<?php echo JRequest::getString('task'); ?>" />
		<input type="hidden" name="view" value="artiofusionchart" />
		<input type="hidden" name="boxchecked" value="1" />
		<input type="hidden" name="copy" value="1" />
		<?php 
			if ($this->chart->chartType == ARTIOFUSIONCHARTS_MULTI_SERIES_TYPE) { 
		?>
				<input type="hidden" name="lastCategoryID" id="lastCategoryID" value="<?php echo count($this->chart->categories); ?>" />
				<input type="hidden" name="lastDatasetID" id="lastDatasetID" value="<?php echo count($this->chart->datasets); ?>" />
				<input type="hidden" name="lastLinesetID" id="lastLinesetID" value="<?php echo count($this->chart->linesets); ?>" />
		<?php 
			}
			echo JHTML::_('form.token'); 
		?>
	</div>
</form>