<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::script('multi-series.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);

?>
<fieldset class="adminform">
    <legend><?php echo JText::_('Chart Data'); ?></legend>
    <div id="dataset" style="overflow: auto">
    <div id="chartToolbar">
    	<a href="javascript:MultiSeries.addCategory()" class="addCat"><?php echo JText::_('Add Category')?></a>
    	<a href="javascript:MultiSeries.removeCategories()" class="removeCat"><?php echo JText::_('Remove Categories')?></a>
    	<a href="javascript:MultiSeries.addDataset()" class="addDat"><?php echo JText::_('Add Dataset')?></a>
    	<a href="javascript:MultiSeries.removeDatasets()" class="removeDat"><?php echo JText::_('Remove Datasets')?></a>
    	<div class="cleaner"></div>
    </div>
    <table class="admintable">
    	<tbody id="chart-data">
    		<tr>
    			<td></td>
    			<td class="chart" colspan="<?php echo count($this->chart->categories); ?>" style="text-align: center;">
    				<strong><?php echo JText::_('Categories'); ?></strong>
    				<img src="<?php echo ARTIOFUSIONCHARTS_SET_IMAGE; ?>" class="setImage"  onclick="MultiSeries.setParams('categories-params','maskCategories')" alt="<?php echo JText::_('Config'); ?>"/>
    				<input type="hidden" id="categories-params" name="categoryParams" value="<?php echo $this->chart->categoryParams; ?>"/>
    			</td>
    		</tr>
    		<tr id="categories">
    			<td></td>
    			<td id="category-cont-0" style="display: none"></td>
    			<?php 
    				foreach ($this->chart->categories as $i=>$category) {
    					JFilterOutput::objectHTMLSafe($category, ENT_QUOTES);
    			    	$categoryId = $i + 1; 
    			?>							
    				<td id="category-cont-<?php echo $categoryId; ?>" class="chart">
    					<input type="checkbox" id="category-checkbox-<?php echo $categoryId; ?>" name="category-checkbox-<?php echo $categoryId; ?>" value="<?php echo $categoryId; ?>" class="checkbox"/>
    					<input type="text" id="category-<?php echo $categoryId; ?>" name="chart-category[]" value="<?php echo $category->value; ?>" size="15"/>
    					<img src="<?php echo ARTIOFUSIONCHARTS_SET_IMAGE; ?>" class="setImage"  onclick="MultiSeries.setParams('category-<?php echo $categoryId; ?>-params','maskCategory')" alt="<?php echo JText::_('Config'); ?>"/>
    					<input type="hidden" id="category-<?php echo $categoryId; ?>-params" name="chart-category-params[]" value="<?php echo $category->params; ?>"/>
    				</td>		
    			<?php } ?>			
    		</tr>
    		<tr id="dataset-0" style="display: none"><td></td></tr>
    		<?php 
    			foreach ($this->chart->datasets as $i=>$dataset) {
    				JFilterOutput::objectHTMLSafe($dataset, ENT_QUOTES);
    				$dataSetId = $i+1; 
    		?>
    			<tr id="dataset-<?php echo $dataSetId; ?>">
    				<td class="chart">
    					<input type="checkbox" id="dataset-checkbox-<?php echo $dataSetId; ?>" name="dataset-checkbox-<?php echo $dataSetId; ?>" value="<?php echo $dataSetId; ?>" class="checkbox"/>
    					<input type="text" class="datasetName" id="dataset-name-<?php echo $dataSetId; ?>" name="dataset[<?php echo $dataSetId; ?>]" value="<?php echo $dataset->value; ?>" size="15"/>
    					<?php if (!empty($this->chart->chartSetting['datasetGroup']) && !empty($this->datasetGroup)) { ?>
    						<select id="dataset-group-<?php echo $dataSetId; ?>" name="dataset-group[<?php echo $dataSetId; ?>]" class="datasetGroup" autocomplete="off">
    							<?php echo JHtml::_('select.options', $this->datasetGroup, 'value', 'text', $dataset->object['datasetGroup']); ?>
    						</select>
    					<?php } ?>
    					<img src="<?php echo ARTIOFUSIONCHARTS_SET_IMAGE; ?>" class="setImage"  onclick="MultiSeries.setParams('dataset-<?php echo $dataSetId; ?>-params','maskDataset')" alt="<?php echo JText::_('Config'); ?>"/>
    					<input type="hidden" id="dataset-<?php echo $dataSetId; ?>-params" name="dataset-params[<?php echo $dataSetId; ?>]" value="<?php echo $dataset->params; ?>"/>
    				</td>
    				<td id="dataset-<?php echo $i+1; ?>-value-0" style="display: none"></td>
    				<?php 
    					foreach ($dataset->sets as $j=>$set) {
    				    	JFilterOutput::objectHTMLSafe($set, ENT_QUOTES);
    						$setId = $j + 1; 
    				?>
    					<td id="dataset-<?php echo $dataSetId; ?>-value-<?php echo $setId; ?>" class="chart">
    						<input type="text" id="dataset-<?php echo $dataSetId; ?>-name-<?php echo $setId; ?>" name="dataset-<?php echo $dataSetId; ?>-values[]" value="<?php echo $set->value; ?>" size="15"/>
    						<img src="<?php echo ARTIOFUSIONCHARTS_SET_IMAGE; ?>" class="setImage"  onclick="MultiSeries.setParams('dataset-<?php echo $dataSetId; ?>-value-<?php echo $setId; ?>-params','maskSet')" alt="<?php echo JText::_('Config'); ?>"/>
    						<input type="hidden" id="dataset-<?php echo $dataSetId; ?>-value-<?php echo $setId; ?>-params" name="dataset-<?php echo $dataSetId; ?>-value-params[]" value="<?php echo $set->params; ?>"/>
    					</td>
    				<?php } ?>	
    			</tr>
    		<?php } ?>
    	</tbody>	
    </table>
    <?php if (! $this->chart->id && (int) $this->config->get('sample_data_mc', 1)) { ?>
    	<p class="sampleDataInfo"><?php echo JText::_('The chart was rendered by sample data'); ?></p>
    <?php } ?>
    </div>
</fieldset>

<?php
    ARTIOFusionChartsHelper::exportParamsInJs($this->chart->paramsCategoriesSource,'maskCategories');
    ARTIOFusionChartsHelper::exportParamsInJs($this->chart->paramsCategorySource,'maskCategory');
    ARTIOFusionChartsHelper::exportParamsInJs($this->chart->paramsDatasetSource,'maskDataset');
    ARTIOFusionChartsHelper::exportParamsInJs($this->chart->paramsSetSource,'maskSet');
?>
