<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewARTIOFusionChart */

JHTML::stylesheet('iframe.css?v=119', ARTIOFUSIONCHARTS_ASSETS_CSS);
JHTML::stylesheet('system.css', 'templates/system/css/');
JHTML::script('common.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);

include (ARTIOFUSIONCHARTS_BASE_LANG . DS . 'chart.php');

$importSource = JRequest::getVar('importSource');

if ($importSource) {
	$document = &JFactory::getDocument();
	/* @var $document JDocument */
	$document->addScriptDeclaration('window.parent.addEvent(\'domready\', function() { ARTIOFusionCharts.fillSource("' . $this->escape($importSource) . '"); } );');
}

?>
<form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<table class="admintable">
		<tr>
			<td class="key"><?php echo JText::_('Source file'); ?></td>
			<td>
				<div style="float: left">
					<input type="file" name="source" value="" /> 
					<input type="radio" name="sourceType" id="sourceTypeXml" value="<?php echo ARTIOFUSIONCHARTS_SOURCE_TYPE_XML; ?>" class="inputRadio" style="display: none" /> 
					<label for="sourceTypeXml"  style="display: none"><?php echo JText::_('XML'); ?></label>
					<input type="radio" name="sourceType" id="sourceTypeCsv" value="<?php echo ARTIOFUSIONCHARTS_SOURCE_TYPE_CSV; ?>" class="inputRadio" checked="checked" style="display: none" /> 
					<label for="sourceTypeCsv"  style="display: none"><?php echo JText::_('CSV'); ?></label>
					<button onclick="return ARTIOFusionCharts.importSource(this)"><?php echo JText::_('Import'); ?></button>
				</div>
				<a class="info" href="<?php echo JURI::root(); ?>components/com_artiofusioncharts/documentation/useCsv.php" title="" target="_blank" ><?php echo JText::_('JHELP'); ?></a>
			</td>
		</tr>
	</table>
	<input type="hidden" name="option" value="<?php echo ARTIOFUSIONCHARTS_OPTION; ?>" /> 
	<input type="hidden" name="task" value="importSource" /> 
	<input type="hidden" name="view" value="artiofusionchart" /> 
	<input type="hidden" name="tmpl" value="component" /> 
	<input type="hidden" name="layout" value="form_source" />
	<?php echo JHTML::_('form.token'); ?>
</form>