<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this JView */

JHTML::script('trendlines.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);

$params = ARTIOFusionChartsHelper::getParamsInTableForm($this->chart->paramsTrendLinesSource, 'trendlines');
  
?>
<fieldset class="adminform">
    <legend><?php echo JText::_('Trend Lines'); ?></legend>
    <div class="chartToolbar">
        <a href="javascript:ARTIOFusionCharts.add('trendlines','trendline')" class="addCol"><?php echo JText::_('Add Trend Line'); ?></a>
        <a href="javascript:ARTIOFusionCharts.remove('trendlines','trendline')" class="removeCol"><?php echo JText::_('Remove Trend Lines'); ?></a>
        <div class="cleaner"></div>
    </div>
    <div>
    	<table class="adminlist" cellspacing="1">
    		<thead>
    			<tr>
    				<th class="title" align="left" width="2%">
    					<input type="checkbox" onclick="ARTIOFusionCharts.checkAll('trendlines',this)" name="checkbox"/>
    				</th>
                    <?php 
                    	$width = ARTIOFUSIONCHARTS_SHIT_BROWSER ? 'width="' . floor(98 / count($params->tableForms)) . '%"' : '';
                    	foreach ($params->tableForms as $param) { 
                    ?>
    				    <th class="title" <?php echo $width; ?>>
    					   <span class="editlinktip hasTip" title="<?php echo $this->escape($param->title . '::' . $param->desc); ?>">
    					        <?php echo $param->title; ?>
    					   </span>
    				    </th>
                    <?php } ?>
    			</tr>	
    		</thead>			
    		<tbody id="trendlines">				
                <?php
                	echo ARTIOFusionChartsHelper::getMaskRow($params->html, 'trendline');
                    foreach ($this->chart->trendlines as $trendline) {
                        echo ARTIOFusionChartsHelper::getFillTableRowFromParams($params->html, $trendline);
                    }
                ?>
    		</tbody>
    	</table>
    </div>
</fieldset>