<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.view');

class ARTIOFusionChartsViewARTIOFusionChart extends JView
{

    function display($tpl = null)
    {
        if ($this->getLayout() != 'form') {
            parent::display($tpl);
            return;
        }
        
        $chart = &$this->get('data');
        
        ARTIOFusionChartsHelper::canEdit($chart->id);
        
        $config = &JComponentHelper::getParams(ARTIOFUSIONCHARTS_OPTION);
        /* @var $config JParameter */
        
        // If new chart set default values
        if (! $chart->id) {
            $chart->category = JRequest::getString('category');
            $chart->type = JRequest::getString('type');
            $chart->width = (int) $config->get('new_chart_width', ARTIOFUSIONCHARTS_DEFAULT_WIDTH);
            $chart->height = (int) $config->get('new_chart_height', ARTIOFUSIONCHARTS_DEFAULT_HEIGHT);
            $chart->created = null;
            $chart->created_by = null;
            $chart->modified = null;
            $chart->modified_by = null;
            $chart->useSqlQuery = ARTIOFUSIONCHARTS_USE_SQL_QUERY_NO;
            $chart->sqlQuery = '';
            $chart->database = 0;
        }
        
        if (isset($_FILES['xml'])) {
            $chart->xml = file_get_contents($_FILES['xml']['tmp_name']);
            $chart->xml = ARTIOFusionChartsHelper::importXMl($chart->xml);
            unlink($_FILES['xml']['tmp_name']);
        }
        
        // Load comlplet chart assests
        $chart = &ARTIOFusionChartsHelper::loadChart($chart->type, $chart->category, $chart);
        
        // If create new chart can be render by samble data if set in configuration
        if (! $chart->id && ! $chart->xml) {
            if ($config->get('sample_data_sc', 1) == 1 && $chart->chartType == ARTIOFUSIONCHARTS_SINGLE_SERIES_TYPE)
                ARTIOFusionChartsHelper::getChartEmptySet($chart, $config->get('sample_data_sc_num_cl', 3));
            if ($config->get('sample_data_mc', 1) == 1 && $chart->chartType == ARTIOFUSIONCHARTS_MULTI_SERIES_TYPE) {
                ARTIOFusionChartsHelper::getChartEmptyCategories($chart, $config->get('sample_data_mc_num_ct', 4));
                ARTIOFusionChartsHelper::getChartEmptyDataset($chart, count($chart->categories), (int) $config->get('sample_data_mc_num_ds', 4), $config->get('dataset_group', 4));
                if (!empty($chart->chartSetting['useLineSets']))
                	ARTIOFusionChartsHelper::getChartEmptyLineset($chart);
                else
                	$chart->linesets = array();
            }
        }
        
        $categories = ARTIOFusionChartsHelper::loadCategories();
        $optCategories[] = JHTML::_('select.option', '0', '- ' . JText::_('Select category') . ' -', 'id', 'type');
        
        foreach ($categories as $item) {
            $optCategories[] = JHTML::_('select.option', $item->base, $item->name, 'id', 'type');
            $charts = array();
            $charts[] = JHTML::_('select.option', '0', '- ' . JText::_('Select Chart') . ' -', 'id', 'type');
            $names = &ARTIOFusionChartsHelper::getChartsNamesArray($item);
            foreach ($names as $i => $name)
                $charts[] = JHTML::_('select.option', $i, $name, 'id', 'type');
            $style = $item->base != $chart->category ? 'style="display: none"' : '';
            $name = $item->base != $chart->category ? '' : 'type';
            $lists_charts[$item->base] = JHTML::_('select.genericlist', $charts, $name, $style, 'id', 'type', strval($chart->type), $item->base);
        }
        $lists['categories'] = JHTML::_('select.genericlist', $optCategories, 'category', 'onchange="ARTIOFusionCharts.changeCharts()"', 'id', 'type', strval($chart->category));
        
        if ($chart->created_by) {
            $chart->created_by = &JFactory::getUser($chart->created_by);
            if ($chart->modified_by)
                $chart->modified_by = &JFactory::getUser($chart->modified_by);
        }
        
        $chart->title = $this->escape($chart->title);
        
        $modelDatabases = &JModel::getInstance('databases', 'ARTIOFusionChartsModel');
        /* @var $modelDatabases ARTIOFusionChartsModelDatabases */
        $databases = &$modelDatabases->getSimpleList();
        array_unshift($databases, JHTML::_('select.option', '0', '- ' . JText::_('default database') . ' -', 'id', 'title'));
        $lists['databases'] = JHTML::_('select.genericlist', $databases, 'database', '', 'id', 'title', $chart->database);
        
        if (!empty($chart->chartSetting['datasetGroup']))
         	for ($i = 1; $i <= $config->get('dataset_group', 100); $i++)
        		$this->datasetGroup[] = array('value' => $i, 'text' => JText::sprintf('DATASET_GROUP', $i));  
            								
        $this->assignRef('lists_charts', $lists_charts);
        $this->assignRef('lists', $lists);
        $this->assignRef('chart', $chart);
        $this->assignRef('config', $config);
        
        parent::display($tpl);
    }
}
?>