<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

/* @var $this ARTIOFusionChartsViewARTIOFusionCharts */

defined('_JEXEC') or die('Restricted access');
	
JHTML::_('behavior.tooltip');
JHTML::script('list.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
JHTML::script('common.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
ARTIOFusionChartsHelper::importJoomlaJS();

if (class_exists('JToolBarHelper')) {
	
	JToolBarHelper::title(JText::_('Charts Manager'), 'charts.png');
	if (ARTIOFUSIONCHARTS_DELETE)
		JToolBarHelper::deleteListX(JText::_('Are you sure to delete selected charts?'));
	if (ARTIOFUSIONCHARTS_EDIT)
		JToolBarHelper::editListX();    
	if (ARTIOFUSIONCHARTS_CREATE)
		JToolBarHelper::addNewX('create');
	if (ARTIOFUSIONCHARTS_ADMIN)
		JToolBarHelper::preferences(ARTIOFUSIONCHARTS_OPTION, 600);
	
}	
	
if (($isPlugin = JRequest::getInt('plugin')) == 1)
	$eName = JRequest::getVar('e_name');

include (ARTIOFUSIONCHARTS_BASE_LANG . DS . 'chart.php');

$orderDir = $this->lists['order_Dir'];
$order = $this->lists['order'];

$editChart = $this->escape(JText::_('Edit Chart'));
$dateFormat = JText::_('DATE_FORMAT_LC4');
$undefined = $this->escape(JText::_('Undefined'));
$tooltip = $this->escape(JText::_('Click To Insert Chart Into Article'));

$count = count($this->items)

?>
<form action="<?php echo JRoute::_($isPlugin ? ARTIOFusionChartsHelperRoute::getListChartsRoute(1, 'component', $eName) : ARTIOFusionChartsHelperRoute::getListChartsRoute(), false); ?>" method="post" name="adminForm" id="adminForm">
	<table>
		<tr>
			<td align="left" width="100%">
				<label for="search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
				<input type="text" name="search" id="search" value="<?php echo $this->escape($this->lists['search']); ?>" class="text_area" onchange="this.form.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button onclick="var f=this.form;f.search.value='';f.filter_categories.value='0';f.filter_types.value='0';f.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
							</td>
			<td nowrap="nowrap">
				<?php
					echo $this->lists['filter_categories'];
					echo $this->lists['filter_types'];
				?>
			</td>
		</tr>
	</table>
	<div id="editcell">
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="3%">
						<?php echo JText::_('JGRID_HEADING_ROW_NUMBER'); ?>
					</th>
					<?php if (($check = (! $isPlugin && ($check = ARTIOFUSIONCHARTS_EDIT || ARTIOFUSIONCHARTS_DELETE)))) { ?>
						<th width="2%">
							<?php if (ARTIOFUSIONCHARTS_J16) { ?>
								<input type="checkbox" name="checkall-toggle" value="" onclick="checkAll(this)" />
							<?php } else { ?>
								<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo $count; ?>);" />
							<?php } ?>
						</th>
					<?php } ?>
					<th class="title">
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_TITLE', 'title', $orderDir, $order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JCATEGORY', 'category', $orderDir, $order); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'Type', 'type', $orderDir, $order); ?>
					</th>
					<th width="5%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_CREATED', 'created', $orderDir, $order); ?>
					</th>
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JGRID_HEADING_CREATED_BY', 'created_by', $orderDir, $order); ?>
					</th>
					<th width="5%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_MODIFIED', 'modified', $orderDir, $order); ?>
					</th>
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'JGLOBAL_FIELD_MODIFIED_BY_LABEL', 'modified_by', $orderDir, $order); ?>
					</th>
					<th width="5%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort', 'ID', 'id', $orderDir, $order); ?>
					</th>
				</tr>
			</thead>
			<tfoot><tr><td colspan="<?php echo ($colspan = $check ? 10 : 9); ?>" align="center"><?php echo $this->pagination->getListFooter(); ?></td></tr></tfoot>
			<tbody>
				<?php 
					if (! $count) { 
				?>
						<tr><td colspan="<?php echo $colspan; ?>"><?php echo JText::_('Did not found any chart'); ?></td></tr>				
				<?php
					} 
					foreach ($this->items as $i => $row) { 
						$row->title = $this->escape($row->title)
				?>
					<tr class="row<?php echo ($i % 2); ?>">
						<td><?php echo $this->pagination->getRowOffset($i); ?></td>
						<?php if ($check) { ?>
							<td><?php echo ARTIOFUSIONCHARTS_J16 ? JHTML::_('grid.id', $i, $row->id) : JHTML::_('grid.checkedout', $row, $i); ?></td>
						<?php } ?>
						<td>
							<?php
								if ($isPlugin) {
							?>		
									<a href="javascript:ARTIOFusionCharts.insertChart('<?php echo $row->id;?>','<?php echo addslashes($row->title); ?>','<?php echo $eName; ?>')" title="<?php echo $tooltip; ?>"><?php echo $row->title; ?></a>							
							<?php
								} elseif (JTable::isCheckedOut($this->user->get('id'), $row->checked_out) || ! ARTIOFUSIONCHARTS_EDIT)
									echo $row->title;
								else {
							?>
									<span class="editlinktip hasTip" title="<?php echo $editChart; ?>::<?php echo $row->title; ?>">
										<a href="<?php echo JRoute::_(ARTIOFusionChartsHelperRoute::getEditRoute($row->id)); ?>"><?php echo $row->title; ?></a>
									</span>
							<?php 
								} 
							?>
						</td>
						<td align="center">
							<?php echo isset($this->categoryNames[$row->category]) ? $this->categoryNames[$row->category] : $undefined; ?>
						</td>
						<td align="center">
							<?php echo isset($this->typesNames[$row->type]) ? $this->typesNames[$row->type] : $undefined; ?>
						</td>
						<td align="center">
						    <?php echo JHTML::_('date', $row->created, $dateFormat); ?>
						</td>
						<td align="center">
							<?php echo $row->created_id ? $row->created_name : '-'; ?>
						</td>
						<td align="center">
							<?php echo $row->modified != $this->nullDate ? JHTML::_('date', $row->modified, $dateFormat) : '-'; ?>
						</td>
						<td align="center">
							<?php echo $row->modified_id ? $row->modified_name : '-'; ?>
						</td>
						<td align="center">
							<?php echo number_format($row->id, 0, '', ' '); ?>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $order; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $orderDir; ?>" />
	<?php echo JHTML::_('form.token'); ?>
</form>