<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCAccessDocument extends JoomDOCAccess {

    /**
     * Access create document in category.
     *
     * @param int $catid category ID
     * @return boolean
     */
    public static function create ($catid = null) {
        return parent::authorise(JOOMDOC_CORE_CREATE, $catid ? sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_CATEGORY, $catid) : JOOMDOC_OPTION);
    }

    /**
     * Access edit document.
     *
     * @param int $docid document ID
     * @return boolean
     */
    public static function edit ($docid = null) {
        return parent::authorise(JOOMDOC_CORE_EDIT, $docid ? sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid) : JOOMDOC_OPTION);
    }

    /**
     * Access edit document by webdav.
     *
     * @param int $docid document ID
     * @return boolean
     */
    public static function editWebDav ($docid = null) {
        if (!J16) {
            $config =& JoomDOCConfig::getInstance();
            $user =& JFactory::getUser();
            /* @var $user JUser */
            return $user->get('gid') == $config->webdavAllow;
        }
        return parent::authorise(JOOMDOC_CORE_EDIT_WEBDAV, $docid ? sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid) : JOOMDOC_OPTION);
    }

    /**
     * Access manage document.
     *
     * @param int $checkedOut user ID who checked out document
     * @param int $userId user ID who want to manage document
     * @return boolean
     */
    public static function manage ($checkedOut, $userId) {
        return parent::authorise(JOOMDOC_CORE_EDIT, 'com_checkin') || $checkedOut == $userId || $checkedOut == 0;
    }

    /**
     * Access edit own document.
     *
     * @param int $docid document ID
     * @param int $createdBy user ID who created document
     * @param int $userId user ID who want to edit document
     * @return boolean
     */
    public static function editOwn ($docid = null, $createdBy = null, $userId = null) {
        if ($docid)
            return parent::authorise(JOOMDOC_CORE_EDIT_OWN, sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid)) && $createdBy == $userId;
        else
            return parent::authorise(JOOMDOC_CORE_EDIT_OWN);
    }

    /**
     * Access set document state.
     *
     * @param int $docid document ID
     * @param int $checkedOut user ID who checked out document
     * @param int $userId user ID who want to set document state
     * @return boolean
     */
    public static function editState ($docid = null, $checkedOut = null, $userId = null, $catid = null) {
        if ($docid && $checkedOut && $userId)
            return parent::authorise(JOOMDOC_CORE_EDIT_STATE, sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid)) && JoomDOCAccessDocument::manage($checkedOut, $userId);
        elseif ($docid)
            return parent::authorise(JOOMDOC_CORE_EDIT_STATE, sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid));
        elseif ($catid)
            return parent::authorise(JOOMDOC_CORE_EDIT_STATE, sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_CATEGORY, $catid));
        else
            return parent::authorise(JOOMDOC_CORE_EDIT_STATE);
    }

    /**
     * Access delete documents.
     *
     * @return boolean
     */
    public static function delete ($docid = null) {
        if ($docid)
            return parent::authorise(JOOMDOC_CORE_DELETE, sprintf('%s.%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT, $docid));
        return parent::authorise(JOOMDOC_CORE_DELETE);
    }

    /**
     * Access view documents versions notes list.
     *
     * @return boolean
     */
    public static function viewVersionsNotes () {
        return parent::authorise(JOOMDOC_CORE_VIEW_VERSIONS_NOTES);
    }

}
?>