<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCAccess
{

    /**
     * Authorise concrete task in concrete section.
     * 
     * @param string $task task name
     * @param string $section section name, default component
     * @return boolean
     */
    public static function authorise($task, $section = JOOMDOC_OPTION)
    {
    	// Joomla 1.6.x
    	if (method_exists('JUser', 'authorise'))
        	return JFactory::getUser()->authorise($task, $section);
        // Joomla 1.5.x without permissions restrictions	
        return true;
    }

    /**
     * Access acces component.
     * 
     * @return boolean
     */
    public static function manage()
    {
        return JoomDOCAccess::authorise(JOOMDOC_CORE_MANAGE);
    }

    /**
     * Access configure component.
     * 
     * @return boolean
     */
    public static function admin()
    {
        return JoomDOCAccess::authorise(JOOMDOC_CORE_ADMIN);
    }

    /**
     * Logged have allowed categories to create. 
     * 
     * @return boolean
     */
    public function haveCategories()
    {
        return count(JFactory::getUser()->getAuthorisedCategories(JOOMDOC_OPTION, JOOMDOC_CORE_CREATE)) > 0;
    }
}

?>