<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

jimport('joomla.application.component.modeladmin');

class JoomDOCModelDocument extends JModelAdmin {

    function __construct ($config) {
        parent::__construct();
        $this->option = JOOMDOC_OPTION;
        $this->name = $this->getName();
        $this->setState($this->getName() . '.id', JRequest::getInt('id'));
        $this->checkin();
    }

    /**
     * @var string The prefix to use with controller messages.
     * @since	1.6
     */
    protected $text_prefix = JOOMDOC_OPTION;

    /**
     * Method to test whether a record can be deleted.
     *
     * @param object $record a record object.
     * @return boolean True if allowed to delete the record. Defaults to the permission set in the component.
     */
    protected function canDelete ($record) {
        return JoomDOCAccessDocument::delete($record->id);
    }

    /**
     * Method to test whether a record can be deleted.
     *
     * @param object $record a record object.
     * @return boolean True if allowed to change the state of the record. Defaults to the permission set in the component.
     */
    protected function canEditState ($record) {
        if (!empty($record->id))
            return JoomDOCAccessDocument::editState($record->id);
        return parent::canEditState($record);
    }

    /**
     * Prepare and sanitise the table data prior to saving.
     *
     * @param JTable A JTable object.
     * @return void
     */
    protected function prepareTable (&$table) {
        if ($table->state == 1 && intval($table->publish_up) == 0)
            $table->publish_up = JFactory::getDate()->toMySQL();
    }

    /**
     * Returns a Table object, always creating it.
     *
     * @param type The table type to instantiate
     * @param string A prefix for the table class name. Optional.
     * @param array Configuration array for model. Optional.
     * @return JTable A database object
     */
    public function getTable ($type = JOOMDOC_DOCUMENT, $prefix = JOOMDOC_TABLE_PREFIX, $config = array ()) {
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to get the record form.
     *
     * @param array	$data Data for the form.
     * @param boolean $loadData	True if the form is to load its own data (default case), false if not.
     * @return mixed A JForm object on success, false on failure
     */
    public function getForm ($data = array (), $loadData = true) {
        $form = $this->loadForm(sprintf('%s.%s', JOOMDOC_OPTION, JOOMDOC_DOCUMENT), JOOMDOC_DOCUMENT, array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form))
            return false;
        if (!$this->canEditState((object) $data)) {
            $form->setFieldAttribute('publish_up', 'disabled', 'true');
            $form->setFieldAttribute('publish_down', 'disabled', 'true');
            $form->setFieldAttribute('state', 'disabled', 'true');
            $form->setFieldAttribute('publish_up', 'filter', 'unset');
            $form->setFieldAttribute('publish_down', 'filter', 'unset');
            $form->setFieldAttribute('state', 'filter', 'unset');
        }
        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return	mixed	The data for the form.
     * @since	1.6
     */
    protected function loadFormData () {
        $data = JFactory::getApplication()->getUserState(sprintf('%s.%s.%s.data', JOOMDOC_OPTION, JOOMDOC_TASK_EDIT, JOOMDOC_DOCUMENT), array());
        if (empty($data))
            $data = $this->getItem();
        return $data;
    }

    /**
     * A protected method to get a set of ordering conditions.
     *
     * @param object A record object.
     * @return array An array of conditions to add to add to ordering queries.
     */
    protected function getReorderConditions ($table) {
        $condition[] = '`parent_path` = ' . $this->_db->quote($table->parent_path) . ' AND `id` IN (SELECT MIN(`id`) FROM `#__joomdoc` GROUP BY `path`)';
        return $condition;
    }

    /**
     * Load document by path value.
     *
     * @param string $path
     */
    public function getItemByPath ($path) {

        $nullDate = $this->_db->Quote($this->_db->getNullDate());
        /* @var $nullDate string null date in database format */
        $nowDate = $this->_db->Quote(JFactory::getDate()->toMySQL());
        /* @var $nowDate string current date in GMT0 */

        // only published item
        $published[] = '(`state` = ' . JOOMDOC_STATE_PUBLISHED . ' OR `state` IS NULL)';
        // control item published interval
        $published[] = '(`publish_up` = ' . $nullDate . ' OR `publish_up` <= ' . $nowDate . ' OR `publish_up` IS NULL)';
        $published[] = '(`publish_down` = ' . $nullDate . ' OR `publish_down` >= ' . $nowDate . ' OR `publish_down` IS NULL)';

        // control logged user access level
        if (count($groups = J16 ? JFactory::getUser()->getAuthorisedViewLevels() : J16User::getAuthorisedViewLevels())) {
            $published[] = '(`access` IN (' . implode(',', $groups) . ') OR `access` IS NULL)';
        }

        // complet SQL query statement
        $published = implode(' AND ', $published);

        $path = $this->_db->quote($path);

        $query = 'SELECT (' . $published . ') AS `published`, `document`.`title`, `document`.`description`, `document`.`params`, `document`.`full_alias`, ';
        // use document create or file upload date as created value (document primary)
        $query .= 'COALESCE(`document`.`created`,(SELECT MIN(`upload`) FROM `#__joomdoc_file` WHERE `path` = ' . $path . ')) AS `created`, ';
        // use document modified or file upload date as modified value (document primary)
        $query .= 'COALESCE(`document`.`modified`,(SELECT MAX(`upload`) FROM `#__joomdoc_file` WHERE `path` = ' . $path . ')) AS `modified`, ';
        $query .= '`document`.`favorite`, `document`.`parent_path` ';
        $query .= 'FROM `#__joomdoc_file` AS `file` ';
        $query .= 'LEFT JOIN `#__joomdoc` AS `document` ON `document`.`path` = `file`.`path` ';
        // search for relative file path
        $query .= 'WHERE `file`.`path` = ' . $path;
        // only document last version
        $query .= ' AND (`document`.`id` IN (SELECT MIN(`id`) FROM `#__joomdoc` GROUP BY `path`) OR `document`.`id` IS NULL) ';
        // only file last version
        $query .= 'AND (`file`.`id` IN (SELECT MAX(`id`) FROM `#__joomdoc_file` GROUP BY `path`)) ';

        $this->_db->setQuery($query);

        $item =& $this->_db->loadObject();

        if ($item) {
            $query = 'SELECT SUM(`hits`) FROM `#__joomdoc_file` WHERE `path` = ' . $path . ' GROUP BY `path`';
            $this->_db->setQuery($query);
            $item->hits = $this->_db->loadResult();
        }

        return $item;
    }
    /**
     * Get parent document by parent path.
     *
     * @param string $parentPath parent relative path
     * @return stdClass if not found return null
     */
    public function getParent ($parentPath) {
        $this->_db->setQuery('SELECT * FROM `#__joomdoc` WHERE `path` = ' . $this->_db->Quote($parentPath) . ' ORDER BY `version` DESC');
        return $this->_db->loadObject();
    }

    /**
     * Search document ID by file relative path.
     *
     * @param string $path relative path
     * @return int
     */
    public function searchIdByPath ($path) {
        $this->_db->setQuery('SELECT `id` FROM `#__joomdoc` WHERE `path` = ' . $this->_db->quote($path) . ' ORDER BY `version` DESC', 0, 1);
        return (int) $this->_db->loadResult();
    }

    /**
     * Search file relative path by document full alias.
     *
     * @param string $fullAlias value from table #__joomdoc column full_alias
     * @return string value from table #__joomdoc column columns parent_path and path
     */
    public function searchRelativePathByFullAlias ($fullAlias) {
        $this->_db->setQuery('SELECT `path` FROM `#__joomdoc` WHERE `full_alias` = ' . $this->_db->quote($fullAlias) . ' ORDER BY `version` DESC', 0, 1);
        return $this->_db->loadResult();
    }
    }
?>