<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCTableFile extends JTable {
    /**
     * Primary key
     *
     * @var int
     */
    var $id;
    /**
     * Relative path of original file
     *
     * @var string
     */
    var $path;
    /**
     * Version number
     *
     * @var int
     */
    var $version;
    /**
     * Date of file upload in GMT0
     *
     * @var string MySQL datetime format
     */
    var $upload;
    /**
     * Joomla user ID who uploaded file
     *
     * @var int ID from table #__users
     */
    var $uploader;
    /**
     * Cleaned content of file to full text search
     *
     * @var string
     */
    var $content;

    /**
     * Create object and set database conector
     *
     * @param JDatabaseMySQL $db
     */
    function __construct (&$db) {
        parent::__construct('#__joomdoc_file', 'id', $db);
    }

    /**
     * Store file row into database
     *
     * @param boolean $versions save file version
     */
    function store ($versions = false) {
        $this->id = null;
                if (!$versions) {
            $this->_db->setQuery('SELECT `id` FROM `#__joomdoc_file` WHERE `path` = ' . $this->_db->Quote($this->path)) . ' AND `version` = ' . $version;
            $this->id = $this->_db->loadResult();
        }
        $this->version = 1;
                $this->upload = JFactory::getDate()->toMySQL();
        $this->uploader = JFactory::getUser()->id;
                parent::store();
    }
    
    /**
     * Delete files and documents with their versions with path.
     *
     * @param array $paths absolute path to deleted files
     * @return array absolute paths of files and their versions to delete
     */
    function delete ($paths) {
        // prepare data
        foreach ($paths as $key => $path) {
            // search selected files
            $paths[$key] = $this->_db->Quote($path);
            // search children
            $childrenPaths[] = '`path` LIKE ' . $this->_db->Quote($path . DS . '%');
        }

        // sql format where
        $where = 'WHERE `path` IN (' . implode(', ', $paths) . ') OR ' . implode(' OR ', $childrenPaths);

        // search files row and rows their children
        $query = 'SELECT `path` FROM `#__joomdoc_file` ' . $where;
        $this->_db->setQuery($query);
        // complet tree parents and children with versions
        $tree =& $this->_db->loadResultArray();

        // delete tree
        $query = 'DELETE FROM `#__joomdoc_file` ' . $where;
        $this->_db->setQuery($query);
        $this->_db->query();

        // delete tree documents
        $query = 'DELETE FROM `#__joomdoc` ' . $where;
        $this->_db->setQuery($query);
        $this->_db->query();

        return $tree;
    }

    /**
     * Rename file/folder. Change their path and path of their children in file and document.
     * 
     * @param string $oldPath
     * @param string $newPath
     */
    function rename ($oldPath, $newPath) {
        $oldPathParent = $this->_db->Quote($oldPath);
        $oldPathChildren = $this->_db->Quote($oldPath . DS . '%');
        $newPathParent = $this->_db->Quote($newPath);
        $newPathChildren = $this->_db->Quote($newPath);

        $query = 'UPDATE `#__joomdoc` SET path = replace(path,' . $oldPathParent . ',' . $newPathParent . ') WHERE `path` = ' . $oldPathParent . ' OR `path` LIKE ' . $oldPathChildren;
        $this->_db->setQuery($query);
        $this->_db->query($query);
        $query = 'UPDATE `#__joomdoc_file` SET path = replace(path,' . $oldPathParent . ',' . $newPathParent . ') WHERE `path` = ' . $oldPathParent . ' OR `path` LIKE ' . $oldPathChildren;
        $this->_db->setQuery($query);
        $this->_db->query($query);
    }
}
?>