<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocument */

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('behavior.keepalive');

jimport('joomla.html.pane');
jimport('joomla.html.pagination');

$config = JoomDOCConfig::getInstance();
/* @var $config JoomDOCConfig */

$tabs = &JPane::getInstance('Tabs', array('startOffset' => JRequest::getInt('bookmark')));
/* @var $tabs JPaneTabs */
$tabs->useCookies = true;

echo $tabs->startPane('tabone');
echo $tabs->startPanel(JText::_('JOOMDOC_DOCUMENT_DETAILS'), 'details');

?>

<script type="text/javascript">
	//<![CDATA[
	/**
	 * Joomla 1.6.x
	 */
	Joomla.submitbutton = function(task) {
		if (task == 'document.cancel' || document.formvalidator.isValid(document.getElementById('item-form'))) {
			Joomla.submitform(task, document.getElementById('item-form'));
		} else {
			alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
		}
	}
	/**
	 * Table ordering change operation.
	 */
	function tableOrdering(order, dir, task) {
		document.versionForm.filter_order.value = order;
		document.versionForm.filter_order_Dir.value = dir;
		document.versionForm.submit();
	}
	/**
	 * Submit form operation.
	 *
	 * @param pressbutton taks value from toolbar button
	 */
	function submitform(pressbutton) {
		if (pressbutton) {
			// toolbar work with document edit form
			if (! Joomla.submitbutton(pressbutton)) {
				return false;
			}
			// set task operation into hidden field task (save, apply, cancel etc.)
			document.adminForm.task.value = pressbutton;
		} else {
			// others task are for version table
			document.versionForm.submit();
		}
		if (typeof document.adminForm.onsubmit == "function") {
			document.adminForm.onsubmit();
		}
		if (pressbutton) {
			// toolbar work with document edit form
			document.adminForm.submit();
		}
	}
	//]]>
</script>

<form action="<?php echo JRoute::_(JoomDOCRoute::saveDocument($this->document->id)); ?>" method="post" name="adminForm" id="item-form" class="form-validate">
	<div class="width-60 fltlft col">
		<fieldset class="adminform">
			<legend><?php echo JText::_('JOOMDOC_DOCUMENT'); ?></legend>
			<table class="admintable">
				<tr><td class="key"><?php echo $this->form->getLabel('title'); ?></td>
				<td><?php echo $this->form->getInput('title'); ?></td></tr>
				
				<tr><td class="key"><?php echo $this->form->getLabel('alias'); ?></td>
				<td><?php echo $this->form->getInput('alias'); ?></td></tr>

				<tr><td class="key"><?php echo $this->form->getLabel('state'); ?></td>
				<td><?php echo $this->form->getInput('state'); ?></td></tr>
				
				<tr><td class="key"><?php echo $this->form->getLabel('favorite'); ?></td>
				<td><?php echo $this->form->getInput('favorite'); ?></td></tr>

				<tr><td class="key"><?php echo $this->form->getLabel('access'); ?></td>
				<td><?php echo $this->form->getInput('access'); ?></td></tr>

				<?php if (JoomDOCAccessDocument::admin()) { ?>
					<!-- 
					<tr><td class="key"><span class="faux-label"><?php echo JText::_('JGLOBAL_ACTION_PERMISSIONS_LABEL'); ?></span>
						<div class="button2-left"><div class="blank">
							<button type="button" onclick="document.location.href='#access-rules';">
								<?php echo JText::_('JGLOBAL_PERMISSIONS_ANCHOR'); ?>
							</button>
						</div></div>
					</td></tr>
					 -->
				<?php } ?>

				<tr><td class="key"><?php echo $this->form->getLabel('id'); ?></td>
				<td><?php echo $this->form->getInput('id'); ?></td></tr>
				
				<tr><td class="key"><?php echo $this->form->getLabel('path'); ?></td>
				<td><?php echo $this->form->getInput('path'); ?></td></tr>
							</table>
			<div class="clr"></div>
			<?php echo $this->form->getLabel('description'); ?>
			<div class="clr"></div>
			<?php echo $this->form->getInput('description'); ?>
		</fieldset>
		<div class="clr"></div>
	</div>

	<div class="width-40 fltrt col">
		<?php 
			echo JHtml::_('sliders.start', 'content-sliders-' . $this->document->id, array('useCookie' => 1));
			echo JHtml::_('sliders.panel', JText::_('JOOMDOC_PUBLISHING'), 'publishing-details'); 
		?>
			
			<fieldset class="panelform">
				<table class="admintable">
					<tr><td class="key"><?php echo $this->form->getLabel('created_by'); ?></td>
					<td><?php echo $this->form->getInput('created_by'); ?></td></tr>

					<tr><td class="key"><?php echo $this->form->getLabel('created'); ?></td>
					<td><?php echo $this->form->getInput('created'); ?></td></tr>

					<tr><td class="key"><?php echo $this->form->getLabel('publish_up'); ?></td>
					<td><?php echo $this->form->getInput('publish_up'); ?></td></tr>

					<tr><td class="key"><?php echo $this->form->getLabel('publish_down'); ?></td>
					<td><?php echo $this->form->getInput('publish_down'); ?></td></tr>

					<?php if ($this->document->modified_by) { ?>
						<tr><td class="key"><?php echo $this->form->getLabel('modified_by'); ?></td>
						<td><?php echo $this->form->getInput('modified_by'); ?></td></tr>

						<tr><td class="key"><?php echo $this->form->getLabel('modified'); ?></td>
						<td><?php echo $this->form->getInput('modified'); ?></td></tr>
					<?php } ?>					
				</table>
			</fieldset>

			<?php 
				$fieldSets = $this->form->getFieldsets('params');
				foreach ($fieldSets as $name => $fieldSet) { 
					
					echo JHtml::_('sliders.panel', JText::_($fieldSet->label), $name . '-options');
					
					if (isset($fieldSet->description) && trim($fieldSet->description)) { 
			?>
						<p class="tip"><?php echo $this->escape(JText::_($fieldSet->description)); ?></p>
			<?php 
					}
			?>
				
					<fieldset class="panelform">
						<table class="admintable">
							<?php foreach ($this->form->getFieldset($name) as $field) { ?>
								<tr>
									<td class="key"><?php echo $field->label; ?></td>
									<td><?php echo $field->input; ?></td>
								</tr>
							<?php } ?>
						</table>
					</fieldset>
				
			<?php 
				}
				 
			echo JHtml::_('sliders.end'); 
			?>
	</div>

	<div class="clr"></div>
	
	<?php if (JoomDOCAccessDocument::admin()) { ?>
		<!-- 
		<div class="width-100 fltlft">
			<?php echo JHtml::_('sliders.start','permissions-sliders-'.$this->document->id, array('useCookie'=>1)); ?>

				<?php echo JHtml::_('sliders.panel',JText::_('JOOMDOC_FIELDSET_RULES'), 'access-rules'); ?>

				<fieldset class="panelform">
					<?php echo $this->form->getLabel('rules'); ?>
					<?php echo $this->form->getInput('rules'); ?>
				</fieldset>

			<?php echo JHtml::_('sliders.end'); ?>
		</div>
		 -->
	<?php } ?>
	
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="return" value="<?php echo JRequest::getCmd('return'); ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	
</form>

<?php 
	echo $tabs->endPanel();
		echo $tabs->endPane();
?>