<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCViewDocument extends JoomDOCView {
    /**
     * @var JForm
     */
    protected $form;
    /**
     * @var JObject
     */
    protected $document;
    /**
     * @var JObject
     */
    protected $state;
        /**
     * Document edit page.
     *
     * @param string $tpl used template name
     * @return void
     */
    public function display ($tpl = null) {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JAdministrator */
        $config = JoomDOCConfig::getInstance();
        $model = $this->getModel();
        /* @var $model JoomDOCModelDocument */

        $this->form = $model->getForm();
        $this->document = $model->getItem();
        $this->state = $model->getState();

        if (!isset($this->document->id) || is_null($this->document->id)) {
            $mainframe = JFactory::getApplication();
            /* @var $mainframe JAdministrator */
            $this->form->setValue('path', null, $mainframe->getUserState('path'));
        }
                $this->addToolbar();

        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @since	1.6
     */
    protected function addToolbar () {
        JRequest::setVar('hidemainmenu', true);
        $userId = JFactory::getUser()->get('id');
        $isNew = $this->document->id == 0;
        $checkedOut = !($this->document->checked_out == 0 || $this->document->checked_out == $userId);
        JToolBarHelper::title(JText::_('JOOMDOC_DOCUMENT'), 'document');
        if ($isNew) {
            JToolBarHelper::apply(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_APPLY), 'JTOOLBAR_APPLY');
            JToolBarHelper::save(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_SAVE), 'JTOOLBAR_SAVE');
            JToolBarHelper::cancel(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_CANCEL), 'JTOOLBAR_CANCEL');
        } else {
            if (!$checkedOut) {
                if (JoomDOCAccessDocument::edit() || (JoomDOCAccessDocument::editOwn() && $this->document->created_by == $userId)) {
                    JToolBarHelper::apply(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_APPLY), 'JTOOLBAR_APPLY');
                    JToolBarHelper::save(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_SAVE), 'JTOOLBAR_SAVE');
                }
            }
            JToolBarHelper::cancel(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_CANCEL), 'JTOOLBAR_CLOSE');
        }
        JToolBarHelper::divider();
    }
}
