<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */

$listOrder = $this->escape($this->state->get(JOOMDOC_FILTER_ORDERING));
$listDirn = $this->escape($this->state->get(JOOMDOC_FILTER_DIRECTION));

foreach (JoomDOCFileSystem::getPathBreadCrumbs($this->root->getAbsolutePath()) as $path => $name) {
?>
	<span> / <a href="<?php echo JRoute::_(JoomDOCRoute::modalDocuments($path)); ?>" class="hasTip" title="<?php echo $this->getTooltip($path, 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $name; ?></a></span>		
<?php	
}
?>
<form action="<?php echo JRoute::_(JoomDOCRoute::modalDocuments($this->root->getAbsolutePath())); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<fieldset id="filter-bar">
		<div>
			<label for="filter" class="hasTip filter-search-lbl" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_FILTER'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_FILTER'); ?>:</label>
			<input type="text" name="filter" id="filter" value="<?php echo $this->escape($this->filter); ?>" />
			<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="var f=this.form;f.filter.value='';f.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
		</div>
	</fieldset>
	<table class="adminlist">
		<thead>
			<tr>
				<th><?php echo JHtml::_('grid.sort',  'JOOMDOC_DOCUMENTS_ITEM', JOOMDOC_ORDER_PATH, $listDirn, $listOrder); ?></th>
				<th><?php echo JText::_('JOOMDOC_DOCUMENT'); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 
				$this->root->initIteration();
				$i = 0;
				while ($this->root->hasNext()) {
					$item = $this->root->getNext();					
					$document = isset($item->document) ? $item->document : false;
					$isFolder = $item instanceof JoomDOCFolder;
			?>

					<tr class="row<?php echo $i % 2; ?>">
						<td>
							<a href="javascript:window.parent.jSelectJoomdocDocument('<?php echo $this->escape($item->getRelativePath()); ?>','<?php echo $this->escape($document ? $document->title : $item->getRelativePath()); ?>')" class="hasTip addDocument" title="<?php echo $this->getTooltip('JOOMDOC_SET_DOCUMENT'); ?>"></a>
							
							<?php if ($isFolder) { ?>
								<a class="hasTip folder" href="<?php echo JRoute::_(JoomDOCRoute::modalDocuments($item->getAbsolutePath())); ?>" title="<?php echo $this->getTooltip($item->getAbsolutePath(), 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $this->escape($item->getFileName()); ?></a>
							<?php 
								} else {
							?>
									<span class="file"><?php echo $this->escape($item->getFileName()); ?></span>
							<?php
								}
						 	?>
						</td>
						<td><?php echo $document ? $this->escape($document->title) : '-'; ?></td>
					</tr>			
			<?php 
					$i ++;
				}
			?>
		</tbody>
	</table>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHtml::_('form.token'); ?>
</form>