<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCViewDocuments extends JoomDOCView {
    /**
     * Current viewed folder.
     *
     * @var JoomDOCFolder
     */
    protected $root;
    /**
     * Filter folder/file name.
     *
     * @var string
     */
    protected $filter;
    /**
     * Documents list for listed files/folders.
     *
     * @var array
     */
    protected $documents;

    /**
     * Request filter state.
     *
     * @var JObject
     */
    public $state;

    /**
     * Support for page listing.
     *
     * @var JPagination
     */
    public $pagination;

    /**
     * Display page with folder content.
     *
     * @param $tpl used template
     * @return void
     */
    public function display ($tpl = null) {
        $mainframe =& JFactory::getApplication();
        /* @var $mainframe JAdministrator */
        $config = JoomDOCConfig::getInstance();

        $path = $mainframe->getUserStateFromRequest('joomdoc_documents_path', 'path', $config->docroot, 'string');
        $this->filter = $mainframe->getUserStateFromRequest('joomdoc_documents_filter_' . $path, 'filter', '', 'string');
        $this->root = JoomDOCFileSystem::getFolderContent($path, '');

        if ((!JoomDOCFileSystem::isSubFolder($path, $config->docroot) || $this->root === false) && $config->docroot !== false)
            $mainframe->redirect(JoomDOCRoute::viewDocuments($config->docroot));

        $model = $this->getModel();
        /* @var $model JoomDOCModelDocuments */
        $model->setKeywords($this->filter);
        $model->setState(JoomDOCView::getStateName(JOOMDOC_FILTER_PATHS), $this->root->getPaths());

        $this->documents = $model->getItems();
        $this->state = $model->getState();
        
        $this->pagination = $model->getPagination();

        $this->root->setDocuments($this->documents);
        $this->root->reorder($this->state->get(JOOMDOC_FILTER_ORDERING), $this->state->get(JOOMDOC_FILTER_ORDERING), $this->state->get(JOOMDOC_FILTER_DIRECTION));

        $this->addToolbar();

        JoomDOCHelper::setSubmenu(JOOMDOC_DOCUMENTS);

        parent::display($tpl);
    }

    /**
     * Add page main toolbar.
     *
     * @return void
     */
    protected function addToolbar () {
        JToolBarHelper::title(JText::_('JOOMDOC_DOCUMENTS'), 'documents');

        if (JoomDOCAccessDocument::editState()) {
            JToolBarHelper::custom(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_PUBLISH), 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
            JToolBarHelper::custom(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_UNPUBLISH), 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
            if (J16) {
                JToolBarHelper::custom(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_CHECKIN), 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
            }
        }

        // Document delete
        if (JoomDOCAccessDocument::delete()) {
            $bar = JToolBar::getInstance('toolbar');
            $bar->appendButton('Confirm', 'JOOMDOC_ARE_YOU_SURE_DELETE_DOCUMETS', 'docs-delete', 'JOOMDOC_DELETE_DOCUMENT', JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_DELETE), true);
        }

        // Item delete
        if (JoomDOCAccessFileSystem::deleteFile())
            JToolBarHelper::deleteList('JOOMDOC_ARE_YOU_SURE_DELETE_ITEMS', JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_DELETEFILE), 'JOOMDOC_DELETE_ITEM');
    }

}
?>