<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewFile */

jimport('joomla.html.pagination');

$config = &JoomDOCConfig::getInstance();

?>
<form name="adminForm" id="adminForm" action="<?php echo JURI::getInstance()->toString(); ?>" method="post">
	<fieldset id="filter-bar" class="autoHeight">
		<table class="fullWidth">
			<tr>
				<td width="1%" nowrap="nowrap">
					<label class="filter-search-lbl edit" for="uploader"><?php echo JText::_('JOOMDOC_UPLOADER'); ?></label>
				</td>
				<td width="1%" nowrap="nowrap">
					<input type="text" name="uploader" id="uploader" value="<?php echo $this->escape($this->filter->uploader); ?>" onchange="this.form.submit()" />
				</td>
				<td>
					<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
					<button type="button" onclick="this.form.uploader.value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
				</td>
			</tr>
		</table>
	</fieldset>
	<table class="adminlist">
		<thead>
			<tr>
				<th><?php echo JHtml::_('grid.sort', 'JOOMDOC_VERSION', 'version', $this->filter->listDirn, $this->filter->listOrder); ?></th>
				<th><?php echo JText::_('JOOMDOC_FILE'); ?></th>
				<th><?php echo JText::_('JOOMDOC_SIZE'); ?></th>
				<th><?php echo JHtml::_('grid.sort', 'JOOMDOC_UPLOADED', 'upload', $this->filter->listDirn, $this->filter->listOrder); ?></th>
				<th><?php echo JHtml::_('grid.sort', 'JOOMDOC_UPLOADER', 'name', $this->filter->listDirn, $this->filter->listOrder); ?></th>
				<th><?php echo JHtml::_('grid.sort', 'JOOMDOC_HITS', 'hits', $this->filter->listDirn, $this->filter->listOrder); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 
				foreach ($this->data as $item) {					
			?>
				<tr>
					<td><?php echo $item->version; ?></td>
					<td><a href="<?php echo JRoute::_(JoomDOCRoute::download($item->path, null, $item->version)); ?>" title="" target="_blank"><?php echo JText::_('JOOMDOC_DOWNLOAD'); ?></a></td>
					<td nowrap="nowrap"><?php echo JoomDOCFileSystem::getFileSize(JoomDOCFileSystem::getFullPath($item->path)); ?></td>
					<td nowrap="nowrap"><?php echo JoomDOCHelper::uploaded($item->upload, false); ?></td>
					<td nowrap="nowrap"><?php echo $item->name; ?></td>
					<td class="center" nowrap="nowrap"><?php echo JoomDOCHelper::number($item->hits); ?></td>
				</tr>
			<?php } ?>
		</tbody>
		<tfoot>
			<tr>
				<?php $pagination = new JPagination($this->filter->total, $this->filter->offset, $this->filter->limit); ?>
				<td colspan="6"><?php echo $pagination->getListFooter(); ?></td>
			</tr>
		</tfoot>
	</table>
	<input type="hidden" name="filter_order" value="<?php echo $this->filter->listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->filter->listDirn; ?>" />
</form>