<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */


$config = &JoomDOCConfig::getInstance();

// document has favorite mark
$isFavorite = $this->root->document && $this->root->document->favorite == 1;
$displayFavorite = $isFavorite && $config->displayFavorite;

?>
<div id="document"<?php if ($isFavorite) { ?> class="favorite"<?php } ?>>
	
	<?php if (!$this->inRoot && $this->root->getRelativePath()) { ?>

		<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getParentPath($this->root->getRelativePath()), $this->root->parent ? $this->root->parent->full_alias : null)); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>
	
	<?php } ?>
	
	<h1><?php echo $this->root->document->title ? $this->root->document->title : $this->root->getFileName(); ?></h1>
<?php 
	if (($this->root->document && ($config->showCreated || $config->showModified)) || (! JoomDOCFileSystem::isFolder($this->root) && ($config->showFileicon || $config->showFilesize || $config->showHits)) || $isFavorite) { 
?>
		<div class="info">
<?php 
			if ($displayFavorite) {
?>
				<span class="favorite"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></span>
<?php	
			}
?>

<?php 
			if ($config->showFilesize && ! JoomDOCFileSystem::isFolder($this->root)) { 
?>
				<span class="filesize"><?php echo JText::sprintf('JOOMDOC_FILESIZE', JoomDOCFileSystem::getFileSize($this->root->getAbsolutePath())); ?></span>
<?php 
			} 
			if ($this->root->document) {
				if ($config->showCreated && !is_null($this->root->document->created)) {
?>
					<span class="created"><?php echo JText::sprintf('JOOMDOC_CREATED', JHtml::date($this->root->document->created, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
<?php	
				}
				if ($config->showModified && $this->root->document->modified != '0000-00-00 00:00:00' && !is_null($this->root->document->modified) && $this->root->document->created != $this->root->document->modified) {
?>
					<span class="modified"><?php echo JText::sprintf('JOOMDOC_MODIFIED', JHtml::date($this->root->document->modified, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
<?php 
				}
			}
			if ($config->showHits && ! JoomDOCFileSystem::isFolder($this->root)) {
?>
				<span class="hits"><?php echo JText::sprintf('JOOMDOC_HITS_INFO', JoomDOCHelper::number($this->root->document->hits)); ?></span>
<?php		
			}
?>
			<div class="clr"></div>
		</div>
<?php 
	}
	if ($this->root->document && ($description = JString::trim($this->root->document->description))) { 
?>
		<p><?php echo $description; ?></p>
<?php 
	}
		if ( !JoomDOCFileSystem::isFolder($this->root)) { 
		$alias = $this->root->document ? $this->root->document->full_alias : null;
?>
		<div class="toolbar">
			<a class="download" href="<?php echo JRoute::_(JoomDOCRoute::download($this->root->getRelativePath(), $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_SITE_DOWNLOAD_FILE'); ?></a>
						<div class="clr"></div>
		</div>
<?php 
	} 
?>
</div>