<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */


$config = &JoomDOCConfig::getInstance();

$docid = JoomDOCHelper::getDocumentID($this->root);
$relativePath = $this->root->getRelativePath();
$absolutePath = $this->root->getAbsolutePath();
$alias = JoomDOCHelper::getDocumentAlias($this->root);

$isFolder = JoomDOCFileSystem::isFolder($this->root);
$isFile = JoomDOCFileSystem::isFile($this->root);

// document has favorite mark
$isFavorite = $docid && $this->root->document->favorite == 1;
$displayFavorite = $isFavorite && $config->displayFavorite;

// set user access
$showDownloadFile = JoomDOCAccessFileSystem::download($docid, $relativePath);
$showFileInfo = JoomDOCAccessFileSystem::viewFileInfo($docid, $relativePath);

// set component config
$showFileDates = $config->showCreated || $config->showModified;
$showFileDetails = $config->showFilesize || $config->showHits;

?>
<form action="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($relativePath, $alias)); ?>" method="post" name="adminForm" id="adminForm">
<div id="document"<?php if ($isFavorite) { ?> class="favorite"<?php } ?>>
	
	<?php if (!$this->inRoot && $relativePath) { ?>

		<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getParentPath($relativePath), $this->root->parent ? $this->root->parent->full_alias : null)); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>
	
	<?php } ?>
	
	<h1><?php echo $docid ? $this->root->document->title : $this->root->getFileName(); ?></h1>
<?php 
	if ($showFileInfo && (($docid && $showFileDates) || (! $isFolder && $showFileDetails) || $isFavorite)) { 
?>
		<div class="info">
<?php 
			if ($displayFavorite) {
?>
				<span class="favorite"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></span>
<?php	
			}
			if ($config->showFilesize && ! $isFolder) { 
?>
				<span class="filesize"><?php echo JText::sprintf('JOOMDOC_FILESIZE', JoomDOCFileSystem::getFileSize($this->root->getAbsolutePath())); ?></span>
<?php 
			} 
			if ($docid) {
				if ($config->showCreated && !is_null($this->root->document->created)) {
?>
					<span class="created"><?php echo JText::sprintf('JOOMDOC_CREATED', JHtml::date($this->root->document->created, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
<?php	
				}
				if ($config->showModified && JoomDOCHelper::canViewModified($this->root->document->created, $this->root->document->modified)) {
?>
					<span class="modified"><?php echo JText::sprintf('JOOMDOC_MODIFIED', JHtml::date($this->root->document->modified, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
<?php 
				}
			}
			if ($config->showHits && ! $isFolder) {
?>
				<span class="hits"><?php echo JText::sprintf('JOOMDOC_HITS_INFO', JoomDOCHelper::number($this->root->document->hits)); ?></span>
<?php		
			}
?>
			<div class="clr"></div>
		</div>
<?php 
	}
	if ($docid && ($description = JString::trim($this->root->document->description))) { 
?>
		<p><?php echo $description; ?></p>
<?php 
	}
		if ( !$isFolder) {
		
		$showWebDavInfo = false;
				
		// tools affected by document permissions
		$showEditDocument = $docid && JoomDOCAccessDocument::canEdit( $this->root->document);
		$showDeleteDocument = $docid && JoomDOCAccessDocument::delete($docid);
		$showPublishDocument = $docid && JoomDOCAccessDocument::editState($docid, $this->root->document->checked_out);
						
		// tools for files which can be without document (access are inherit) 
		$showAddDocument = !$docid && JoomDOCAccessDocument::create($relativePath);
		$showDeleteFile = JoomDOCAccessFileSystem::deleteFile($docid, $relativePath);
		
		if ($showDownloadFile || $showWebDavInfo || $showEditDocument || $showDeleteDocument || $showAddDocument || $showDeleteFile || $showPublishDocument) {
?>
			<div class="toolbar">
				<?php
					if ($showDownloadFile) { 
				?>
						<a class="download" href="<?php echo JRoute::_(JoomDOCRoute::download($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_DOWNLOAD_FILE'); ?></a>
				<?php 
					} 
					if ($showAddDocument) { 
				?>
						<a class="add" href="<?php echo JRoute::_(JoomDOCRoute::add($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_ADD_DOCUMENT'); ?></a>
				<?php 
					} 
					if ($showEditDocument) { 
				?>
						<a class="edit" href="<?php echo JRoute::_(JoomDOCRoute::edit($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_EDIT_DOC'); ?></a>
				<?php 
					}
					if ($showPublishDocument) {
						if ($this->root->document->state == JOOMDOC_STATE_UNPUBLISHED) {
				?>		
							<a class="publish" href="<?php echo JRoute::_(JoomDOCRoute::publish($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_PUBLISH'); ?></a>
				<?php 
						} elseif ($this->root->document->state == JOOMDOC_STATE_PUBLISHED) {
				?>		
							<a class="unpublish" href="<?php echo JRoute::_(JoomDOCRoute::unpublish($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_UNPUBLISH'); ?></a>
				<?php		 
						}
					}
					if ($showDeleteFile) { 
				?>
						<a class="delete" href="javascript:void(0)" onclick="JoomDOC.confirm('<?php echo addslashes(JRoute::_(JoomDOCRoute::deletefile($relativePath, $alias))); ?>')" title=""><?php echo JText::_('JOOMDOC_DELETE_ITEM'); ?></a>
				<?php 
					}
					if ($showDeleteDocument) { 
				?>
						<a class="deleteDocument" href="javascript:void(0)" onclick="JoomDOC.confirm('<?php echo addslashes(JRoute::_(JoomDOCRoute::delete($relativePath, $alias))); ?>')" title=""><?php echo JText::_('JOOMDOC_DELETE_DOCUMENT'); ?></a>
				<?php 
					}
				?>								
								<div class="clr"></div>
			</div>
<?php 
		}
	} 
?>
	<input type="hidden" id="joomdocToken" name="<?php echo JUtility::getToken(); ?>" value="1" />
</div>
</form>