<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage		JoomDOC
 * @author      	ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright		Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class com_joomdocInstallerScript
{
	function postflight($action, $installer)
	{
		$db = JFactory::getDbo();
		// allow basic rules for each group
		$rule = array();
		$rule[] = 'core.enterfolder'; // show folder
		$rule[] = 'core.viewfileinfo'; // show file
		$rule[] = 'core.download'; // download file
		
		// load existing rules
		$query = $db->getQuery(true);
		$query->select('rules')->from('#__assets')->where("name = 'com_joomdoc'");
		$db->setQuery($query);
		$rules = $db->loadResult();
		
		$rules = json_decode($rules);
		
		// initialize with fresh installation
		if (!is_object($rules))
			$rules = new stdClass();
		
		foreach ($rule as $r)
			if (!isset($rules->$r))
				$rules->$r = new stdClass();
		
		// load all usergroups
		$query = $db->getQuery(true);
		$query->select('id')->from('#__usergroups');
		$db->setQuery($query);
		$userGroups = $db->loadColumn();
		
		// allow all rules for each usergroup
		foreach ($userGroups as $userGroup)
			foreach ($rule as $r)
				$rules->$r->$userGroup = 1;
		
		// save rules back
		$rules = json_encode($rules);
		$rules = $db->quote($rules);
		
		$query = $db->getQuery(true);
		$query->update('#__assets')->set("rules = $rules")->where("name = 'com_joomdoc'");
		$db->setQuery($query);
		$db->query();
	}
}